/*
 * Decompiled with CFR 0.152.
 */
package com.ikasoa.zk.utils;

import com.ikasoa.core.utils.ObjectUtil;
import com.ikasoa.core.utils.StringUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public final class LocalUtil {
    public static String getLocalIP() throws UnknownHostException, SocketException {
        return LocalUtil.isWindowsOS() != false ? InetAddress.getLocalHost().getHostAddress() : LocalUtil.getLinuxLocalIp();
    }

    private static Boolean isWindowsOS() {
        Boolean isWindowsOS = Boolean.FALSE;
        String osName = System.getProperty("os.name");
        if (StringUtil.isNotEmpty((String)osName) && osName.toLowerCase().indexOf("windows") > -1) {
            isWindowsOS = Boolean.TRUE;
        }
        return isWindowsOS;
    }

    public static String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    private static String getLinuxLocalIp() throws SocketException {
        String ip = "";
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            String name;
            NetworkInterface intf = en.nextElement();
            if (ObjectUtil.isNull((Object)intf) || !StringUtil.isNotEmpty((String)(name = intf.getName())) || name.contains("docker") || name.contains("lo")) continue;
            Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
            while (enumIpAddr.hasMoreElements()) {
                String ipaddress;
                InetAddress inetAddress = enumIpAddr.nextElement();
                if (inetAddress.isLoopbackAddress() || (ipaddress = inetAddress.getHostAddress().toString()).contains("::") || ipaddress.contains("0:0:") || ipaddress.contains("fe80")) continue;
                ip = ipaddress;
            }
        }
        return ip;
    }

    private LocalUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

