/*
 * Decompiled with CFR 0.152.
 */
package com.iluwatar.urm;

import com.iluwatar.urm.DomainMapper;
import com.iluwatar.urm.presenters.Presenter;
import com.iluwatar.urm.presenters.Representation;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="map", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class DomainMapperMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}", property="outputDirectory", required=true)
    private File outputDirectory;
    @Component
    private MavenProject project;
    @Parameter(property="map.packages", required=true)
    private List<String> packages;
    @Parameter(property="map.ignores", required=false)
    private List<String> ignores;
    @Parameter(property="presenter", required=false)
    private String presenter;
    @Parameter(property="map.skipForProjects", required=false)
    private List<String> skipForProjects;
    @Parameter(property="includeMainDirectory", defaultValue="true")
    private boolean includeMainDirectory;
    @Parameter(property="includeTestDirectory", defaultValue="false")
    private boolean includeTestDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String projectName;
        if (this.skipForProjects != null && !this.skipForProjects.isEmpty() && this.skipForProjects.contains(projectName = this.project.getName())) {
            this.getLog().info((CharSequence)("Skip configured (in pom.xml) for current project \"" + projectName + "\". Plugin will not be executed!"));
            return;
        }
        if (this.packages.isEmpty()) {
            throw new MojoFailureException("No packages defined for scanning.");
        }
        try {
            Presenter selectedPresenter = Presenter.parse((String)this.presenter);
            String fileName = this.project.getName() + ".urm." + selectedPresenter.getFileEnding();
            Path path = Paths.get(this.outputDirectory.getPath(), fileName);
            Path dir = path.getParent();
            if (dir != null) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            if (!Files.exists(path, new LinkOption[0])) {
                List<URL> projectClasspathList = this.getClasspathUrls();
                DomainMapper mapper = DomainMapper.create((Presenter)selectedPresenter, this.packages, this.ignores, (URLClassLoader)new URLClassLoader(projectClasspathList.toArray(new URL[projectClasspathList.size()])));
                Representation representation = mapper.describeDomain();
                Files.write(path, representation.getContent().getBytes(), new OpenOption[0]);
                this.getLog().info((CharSequence)(fileName + " successfully written to: \"" + path + "\"!"));
            } else {
                this.getLog().info((CharSequence)(fileName + " already exists, file was not overwritten!"));
            }
        }
        catch (IOException | ClassNotFoundException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private List<URL> getClasspathUrls() throws DependencyResolutionRequiredException, MojoExecutionException {
        ArrayList<URL> projectClasspathList = new ArrayList<URL>();
        for (String element : this.getProjectClassPathList()) {
            try {
                projectClasspathList.add(new File(element).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException(element + " is an invalid classpath element", (Exception)e);
            }
        }
        return projectClasspathList;
    }

    private List<String> getProjectClassPathList() throws DependencyResolutionRequiredException {
        List<Object> projectClasspathList = new ArrayList();
        if (this.includeMainDirectory && this.includeTestDirectory) {
            projectClasspathList = this.project.getTestClasspathElements();
        } else if (this.includeMainDirectory) {
            projectClasspathList = this.project.getCompileClasspathElements();
        } else if (this.includeTestDirectory) {
            String outputDir = this.project.getBuild().getOutputDirectory();
            projectClasspathList = this.project.getTestClasspathElements().stream().filter(url -> !outputDir.equalsIgnoreCase((String)url)).collect(Collectors.toList());
        }
        return projectClasspathList;
    }
}

