/*
 * Decompiled with CFR 0.152.
 */
package com.imadcn.framework.idworker.exception;

import com.imadcn.framework.idworker.exception.RegException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegExceptionHandler {
    private static Logger logger = LoggerFactory.getLogger(RegExceptionHandler.class);

    public static void handleException(Exception cause) {
        if (null == cause) {
            return;
        }
        if (RegExceptionHandler.isIgnoredException(cause) || null != cause.getCause() && RegExceptionHandler.isIgnoredException(cause.getCause())) {
            logger.debug("Elastic job: ignored exception for: {}", (Object)cause.getMessage());
        } else if (cause instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        } else {
            throw new RegException(cause);
        }
    }

    private static boolean isIgnoredException(Throwable cause) {
        return cause instanceof KeeperException.ConnectionLossException || cause instanceof KeeperException.NoNodeException || cause instanceof KeeperException.NodeExistsException;
    }
}

