/*
 * Decompiled with CFR 0.152.
 */
package com.imadcn.framework.idworker.generator;

import com.imadcn.framework.idworker.algorithm.Snowflake;
import com.imadcn.framework.idworker.exception.RegException;
import com.imadcn.framework.idworker.generator.IdGenerator;
import com.imadcn.framework.idworker.register.GeneratorConnector;
import com.imadcn.framework.idworker.register.zookeeper.ZookeeperConnectionStateListener;
import com.imadcn.framework.idworker.register.zookeeper.ZookeeperWorkerRegister;
import java.io.IOException;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeGenerator
implements IdGenerator,
GeneratorConnector {
    static final String FIXED_STRING_FORMAT = "%019d";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Snowflake snowflake;
    private ZookeeperWorkerRegister register;
    private volatile boolean initialized = false;
    private volatile boolean working = false;
    private volatile boolean connecting = false;
    private ConnectionStateListener listener;

    public SnowflakeGenerator(ZookeeperWorkerRegister register) {
        this.register = register;
    }

    @Override
    public synchronized void init() {
        if (!this.initialized) {
            this.listener = new ZookeeperConnectionStateListener(this);
            this.register.addConnectionListener(this.listener);
            this.connect();
            this.initialized = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void connect() {
        if (!this.isConnecting()) {
            this.working = false;
            this.connecting = true;
            long workerId = this.register.register();
            if (workerId < 0L) throw new RegException("failed to get worker id", new Object[0]);
            this.snowflake = Snowflake.create(workerId);
            this.working = true;
            this.connecting = false;
            return;
        } else {
            this.logger.info("worker is connecting, skip this time of register.");
        }
    }

    @Override
    public long[] nextId(int size) {
        if (this.isWorking()) {
            return this.snowflake.nextId(size);
        }
        throw new IllegalStateException("worker isn't working, reg center may shutdown");
    }

    @Override
    public long nextId() {
        if (this.isWorking()) {
            return this.snowflake.nextId();
        }
        throw new IllegalStateException("worker isn't working, reg center may shutdown");
    }

    @Override
    public String nextStringId() {
        return String.valueOf(this.nextId());
    }

    @Override
    public String nextFixedStringId() {
        return String.format(FIXED_STRING_FORMAT, this.nextId());
    }

    @Override
    public void suspend() {
        this.working = false;
    }

    @Override
    public synchronized void close() throws IOException {
        this.reset();
        this.register.logout();
    }

    @Override
    public boolean isWorking() {
        return this.working;
    }

    @Override
    public boolean isConnecting() {
        return this.connecting;
    }

    protected void reset() {
        this.initialized = false;
        this.working = false;
        this.connecting = false;
    }

    @Deprecated
    public void setLowConcurrency(boolean lowConcurrency) {
    }
}

