/*
 * Decompiled with CFR 0.152.
 */
package com.imadcn.framework.idworker.register.zookeeper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.imadcn.framework.idworker.config.ApplicationConfiguration;
import com.imadcn.framework.idworker.exception.RegException;
import com.imadcn.framework.idworker.register.WorkerRegister;
import com.imadcn.framework.idworker.register.zookeeper.NodeInfo;
import com.imadcn.framework.idworker.register.zookeeper.NodePath;
import com.imadcn.framework.idworker.registry.CoordinatorRegistryCenter;
import com.imadcn.framework.idworker.util.HostUtils;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.jboss.netty.handler.timeout.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ZookeeperWorkerRegister
implements WorkerRegister {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperWorkerRegister.class);
    private static final long MAX_WORKER_NUM = 1024L;
    private static final int MAX_LOCK_WAIT_TIME_MS = 30000;
    private final CoordinatorRegistryCenter regCenter;
    private String registryFile;
    private final NodePath nodePath;

    public ZookeeperWorkerRegister(CoordinatorRegistryCenter regCenter, ApplicationConfiguration applicationConfiguration) {
        this.regCenter = regCenter;
        this.nodePath = new NodePath(applicationConfiguration.getGroup());
        this.registryFile = StringUtils.isEmpty((Object)applicationConfiguration.getRegistryFile()) ? this.getDefaultFilePath(this.nodePath.getGroupName()) : applicationConfiguration.getRegistryFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long register() {
        InterProcessMutex lock = null;
        try {
            String key;
            String zkNodeInfoJson;
            NodeInfo zkNodeInfo;
            CuratorFramework client = (CuratorFramework)this.regCenter.getRawClient();
            lock = new InterProcessMutex(client, this.nodePath.getGroupPath());
            int numOfChildren = this.regCenter.getNumChildren(this.nodePath.getWorkerPath());
            if ((long)numOfChildren >= 1024L) throw new RegException("max worker num reached. register failed", new Object[0]);
            if (!lock.acquire(30000L, TimeUnit.MILLISECONDS)) {
                String message = String.format("acquire lock failed after %s ms.", 30000);
                throw new TimeoutException(message);
            }
            NodeInfo localNodeInfo = this.getLocalNodeInfo();
            List<String> children = this.regCenter.getChildrenKeys(this.nodePath.getWorkerPath());
            if (localNodeInfo != null && children.contains(String.valueOf(localNodeInfo.getWorkerId())) && this.checkNodeInfo(localNodeInfo, zkNodeInfo = this.createNodeInfoFromJsonStr(zkNodeInfoJson = this.regCenter.get(key = this.getNodePathKey(this.nodePath, localNodeInfo.getWorkerId()))))) {
                this.nodePath.setWorkerId(zkNodeInfo.getWorkerId().intValue());
                zkNodeInfo.setUpdateTime(new Date());
                this.updateZookeeperNodeInfo(key, zkNodeInfo);
                this.saveLocalNodeInfo(zkNodeInfo);
                this.executeUploadNodeInfoTask(key, zkNodeInfo);
                long l = zkNodeInfo.getWorkerId().intValue();
                return l;
            }
            int workerId = 0;
            while ((long)workerId < 1024L) {
                String workerIdStr = String.valueOf(workerId);
                if (!children.contains(workerIdStr)) {
                    NodeInfo applyNodeInfo = this.createNodeInfo(this.nodePath.getGroupName(), workerId);
                    this.nodePath.setWorkerId(applyNodeInfo.getWorkerId().intValue());
                    this.saveZookeeperNodeInfo(this.nodePath.getWorkerIdPath(), applyNodeInfo);
                    this.saveLocalNodeInfo(applyNodeInfo);
                    this.executeUploadNodeInfoTask(this.nodePath.getWorkerIdPath(), applyNodeInfo);
                    long l = applyNodeInfo.getWorkerId().intValue();
                    return l;
                }
                ++workerId;
            }
            throw new RegException("max worker num reached. register failed", new Object[0]);
        }
        catch (RegException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (Exception ignored) {
                logger.error("", (Throwable)ignored);
            }
        }
    }

    public void addConnectionListener(ConnectionStateListener listener) {
        CuratorFramework client = (CuratorFramework)this.regCenter.getRawClient();
        client.getConnectionStateListenable().addListener((Object)listener);
    }

    @Override
    public synchronized void logout() {
        CuratorFramework client = (CuratorFramework)this.regCenter.getRawClient();
        if (client == null) {
            return;
        }
        if (client.getState() == CuratorFrameworkState.STARTED) {
            this.regCenter.close();
        }
    }

    private boolean checkNodeInfo(NodeInfo localNodeInfo, NodeInfo zkNodeInfo) {
        try {
            if (!zkNodeInfo.getNodeId().equals(localNodeInfo.getNodeId())) {
                return false;
            }
            if (!zkNodeInfo.getIp().equals(localNodeInfo.getIp())) {
                return false;
            }
            if (!zkNodeInfo.getHostName().equals(localNodeInfo.getHostName())) {
                return false;
            }
            return zkNodeInfo.getGroupName().equals(localNodeInfo.getGroupName());
        }
        catch (Exception e) {
            logger.error("check node info error, {}", (Throwable)e);
            return false;
        }
    }

    private void executeUploadNodeInfoTask(final String key, final NodeInfo nodeInfo) {
        Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "upload node info task thread");
                thread.setDaemon(true);
                return thread;
            }
        }).scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ZookeeperWorkerRegister.this.updateZookeeperNodeInfo(key, nodeInfo);
            }
        }, 3L, 3L, TimeUnit.SECONDS);
    }

    private String getNodePathKey(NodePath nodePath, Integer workerId) {
        StringBuilder builder = new StringBuilder();
        builder.append(nodePath.getWorkerPath()).append("/");
        builder.append(workerId);
        return builder.toString();
    }

    private void saveZookeeperNodeInfo(String key, NodeInfo nodeInfo) {
        this.regCenter.persist(key, this.jsonizeNodeInfo(nodeInfo));
    }

    private void updateZookeeperNodeInfo(String key, NodeInfo nodeInfo) {
        try {
            nodeInfo.setUpdateTime(new Date());
            this.regCenter.persist(key, this.jsonizeNodeInfo(nodeInfo));
        }
        catch (Exception e) {
            logger.debug("update zookeeper node info error, {}", (Throwable)e);
        }
    }

    private void saveLocalNodeInfo(NodeInfo nodeInfo) {
        try {
            File nodeInfoFile = new File(this.registryFile);
            String nodeInfoJson = this.jsonizeNodeInfo(nodeInfo);
            FileUtils.writeStringToFile((File)nodeInfoFile, (String)nodeInfoJson, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            logger.error("save node info cache error, {}", (Throwable)e);
        }
    }

    private NodeInfo getLocalNodeInfo() {
        try {
            File nodeInfoFile = new File(this.registryFile);
            if (nodeInfoFile.exists()) {
                String nodeInfoJson = FileUtils.readFileToString((File)nodeInfoFile, (Charset)StandardCharsets.UTF_8);
                NodeInfo nodeInfo = this.createNodeInfoFromJsonStr(nodeInfoJson);
                return nodeInfo;
            }
        }
        catch (Exception e) {
            logger.error("read node info cache error, {}", (Throwable)e);
        }
        return null;
    }

    private NodeInfo createNodeInfo(String groupName, Integer workerId) throws UnknownHostException {
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.setNodeId(this.genNodeId());
        nodeInfo.setGroupName(groupName);
        nodeInfo.setWorkerId(workerId);
        nodeInfo.setIp(HostUtils.getLocalIP());
        nodeInfo.setHostName(HostUtils.getLocalHostName());
        nodeInfo.setCreateTime(new Date());
        nodeInfo.setUpdateTime(new Date());
        return nodeInfo;
    }

    private NodeInfo createNodeInfoFromJsonStr(String jsonStr) {
        NodeInfo nodeInfo = (NodeInfo)JSON.parseObject((String)jsonStr, NodeInfo.class);
        return nodeInfo;
    }

    private String jsonizeNodeInfo(NodeInfo nodeInfo) {
        String dateFormat = "yyyy-MM-dd HH:mm:ss";
        return JSON.toJSONStringWithDateFormat((Object)nodeInfo, (String)dateFormat, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
    }

    private String getDefaultFilePath(String groupName) {
        StringBuilder builder = new StringBuilder();
        builder.append(".").append(File.separator).append("tmp");
        builder.append(File.separator).append("idworker");
        builder.append(File.separator).append(groupName).append(".cache");
        return builder.toString();
    }

    private String genNodeId() {
        return UUID.randomUUID().toString().replace("-", "").toLowerCase();
    }
}

