/*
 * Decompiled with CFR 0.152.
 */
package com.imadcn.framework.idworker.spring.schema.parser;

import com.imadcn.framework.idworker.common.GeneratorStrategy;
import com.imadcn.framework.idworker.config.ApplicationConfiguration;
import com.imadcn.framework.idworker.generator.CompressUUIDGenerator;
import com.imadcn.framework.idworker.generator.SnowflakeGenerator;
import com.imadcn.framework.idworker.register.zookeeper.ZookeeperWorkerRegister;
import com.imadcn.framework.idworker.spring.schema.parser.BaseBeanDefinitionParser;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class GeneratorRegisteryBuilder
extends BaseBeanDefinitionParser {
    public static AbstractBeanDefinition buildWorkerNodeRegisterBeanDefinition(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder result = BeanDefinitionBuilder.rootBeanDefinition(ZookeeperWorkerRegister.class);
        String registryCenterRef = element.getAttribute("registry-center-ref");
        if (registryCenterRef == null || registryCenterRef.isEmpty()) {
            throw new IllegalArgumentException("no attribute [registry-center-ref] found");
        }
        result.addConstructorArgReference(registryCenterRef);
        result.addConstructorArgValue((Object)GeneratorRegisteryBuilder.buildApplicationConfigurationBeanDefinition(element, parserContext));
        return result.getBeanDefinition();
    }

    public static AbstractBeanDefinition buildApplicationConfigurationBeanDefinition(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder configuration = BeanDefinitionBuilder.rootBeanDefinition(ApplicationConfiguration.class);
        GeneratorRegisteryBuilder.addPropertyValueIfNotEmpty("group", "group", element, configuration);
        GeneratorRegisteryBuilder.addPropertyValueIfNotEmpty("strategy", "strategy", element, configuration);
        GeneratorRegisteryBuilder.addPropertyValueIfNotEmpty("registry-file", "registryFile", element, configuration);
        return configuration.getBeanDefinition();
    }

    public static Class<?> getGeneratorClass(Element element) {
        String strategyCode = GeneratorRegisteryBuilder.getAttributeValue(element, "strategy");
        GeneratorStrategy strategy = GeneratorStrategy.getByCode(strategyCode);
        if (strategy == null) {
            throw new IllegalArgumentException("unsupported generator strategy.");
        }
        switch (strategy) {
            case SNOWFLAKE: {
                return SnowflakeGenerator.class;
            }
            case COMPRESS_UUID: {
                return CompressUUIDGenerator.class;
            }
        }
        return SnowflakeGenerator.class;
    }
}

