/*
 * Decompiled with CFR 0.152.
 */
package com.imadcn.framework.idworker.registry.zookeeper;

import com.google.common.base.Preconditions;
import com.imadcn.framework.idworker.config.ZookeeperConfiguration;
import com.imadcn.framework.idworker.exception.RegExceptionHandler;
import com.imadcn.framework.idworker.registry.CoordinatorRegistryCenter;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperRegistryCenter
implements CoordinatorRegistryCenter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, TreeCache> caches = new HashMap<String, TreeCache>();
    private ZookeeperConfiguration zkConfig;
    private CuratorFramework client;

    public ZookeeperRegistryCenter(ZookeeperConfiguration zookeeperConfigurarion) {
        this.zkConfig = zookeeperConfigurarion;
    }

    @Override
    public synchronized void init() {
        if (this.client != null) {
            return;
        }
        this.logger.debug("init zookeeper registry, connect to servers : {}", (Object)this.zkConfig.getServerLists());
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(this.zkConfig.getServerLists()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(this.zkConfig.getBaseSleepTimeMilliseconds(), this.zkConfig.getMaxRetries(), this.zkConfig.getMaxSleepTimeMilliseconds())).namespace(this.zkConfig.getNamespace());
        if (0 != this.zkConfig.getSessionTimeoutMilliseconds()) {
            builder.sessionTimeoutMs(this.zkConfig.getSessionTimeoutMilliseconds());
        }
        if (0 != this.zkConfig.getConnectionTimeoutMilliseconds()) {
            builder.connectionTimeoutMs(this.zkConfig.getConnectionTimeoutMilliseconds());
        }
        if (this.zkConfig.getDigest() != null && !this.zkConfig.getDigest().isEmpty()) {
            builder.authorization("digest", this.zkConfig.getDigest().getBytes(StandardCharsets.UTF_8)).aclProvider(new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }

                public List<ACL> getAclForPath(String path) {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }
            });
        }
        this.client = builder.build();
        this.client.start();
        try {
            if (!this.client.blockUntilConnected(this.zkConfig.getMaxSleepTimeMilliseconds() * this.zkConfig.getMaxRetries(), TimeUnit.MILLISECONDS)) {
                this.client.close();
                throw new KeeperException.OperationTimeoutException();
            }
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
    }

    @Override
    public void close() {
        if (this.client == null) {
            return;
        }
        for (Map.Entry<String, TreeCache> each : this.caches.entrySet()) {
            each.getValue().close();
        }
        this.waitForCacheClose();
        CloseableUtils.closeQuietly((Closeable)this.client);
        this.client = null;
    }

    private void waitForCacheClose() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public String get(String key) {
        TreeCache cache = this.findTreeCache(key);
        if (null == cache) {
            return this.getDirectly(key);
        }
        ChildData resultInCache = cache.getCurrentData(key);
        if (null != resultInCache) {
            return null == resultInCache.getData() ? null : new String(resultInCache.getData(), StandardCharsets.UTF_8);
        }
        return this.getDirectly(key);
    }

    private TreeCache findTreeCache(String key) {
        for (Map.Entry<String, TreeCache> entry : this.caches.entrySet()) {
            if (!key.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public String getDirectly(String key) {
        try {
            return new String((byte[])this.client.getData().forPath(key), StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
            return null;
        }
    }

    @Override
    public List<String> getChildrenKeys(String key) {
        try {
            List result = (List)this.client.getChildren().forPath(key);
            Collections.sort(result, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o2.compareTo(o1);
                }
            });
            return result;
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
            return Collections.emptyList();
        }
    }

    @Override
    public int getNumChildren(String key) {
        try {
            Stat stat = (Stat)this.client.checkExists().forPath(key);
            if (null != stat) {
                return stat.getNumChildren();
            }
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
        return 0;
    }

    @Override
    public boolean isExisted(String key) {
        try {
            return null != this.client.checkExists().forPath(key);
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
            return false;
        }
    }

    @Override
    public void persist(String key, String value) {
        try {
            if (!this.isExisted(key)) {
                ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
            } else {
                this.update(key, value);
            }
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
    }

    @Override
    public void update(String key, String value) {
        try {
            ((CuratorTransactionBridge)((CuratorTransactionBridge)this.client.inTransaction().check().forPath(key)).and().setData().forPath(key, value.getBytes(StandardCharsets.UTF_8))).and().commit();
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
    }

    @Override
    public void persistEphemeral(String key, String value) {
        try {
            if (this.isExisted(key)) {
                this.client.delete().deletingChildrenIfNeeded().forPath(key);
            }
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
    }

    @Override
    public String persistSequential(String key, String value) {
        try {
            return (String)((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
            return null;
        }
    }

    @Override
    public void persistEphemeralSequential(String key) {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(key);
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
    }

    @Override
    public void remove(String key) {
        try {
            this.client.delete().deletingChildrenIfNeeded().forPath(key);
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
    }

    @Override
    public long getRegistryCenterTime(String key) {
        long result = 0L;
        try {
            this.persist(key, "");
            result = ((Stat)this.client.checkExists().forPath(key)).getMtime();
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
        Preconditions.checkState((0L != result ? 1 : 0) != 0, (Object)"Cannot get registry center time.");
        return result;
    }

    @Override
    public Object getRawClient() {
        if (this.client == null) {
            this.init();
        }
        return this.client;
    }

    @Override
    public void addCacheData(String cachePath) {
        TreeCache cache = new TreeCache(this.client, cachePath);
        try {
            cache.start();
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
        this.caches.put(cachePath + "/", cache);
    }

    @Override
    public void evictCacheData(String cachePath) {
        TreeCache cache = this.caches.remove(cachePath + "/");
        if (null != cache) {
            cache.close();
        }
    }

    @Override
    public Object getRawCache(String cachePath) {
        return this.caches.get(cachePath + "/");
    }
}

