/*
 * Decompiled with CFR 0.152.
 */
package com.imadcn.framework.idworker.register.zookeeper;

import com.imadcn.framework.idworker.config.ApplicationConfiguration;
import com.imadcn.framework.idworker.exception.ConfigException;
import com.imadcn.framework.idworker.exception.RegException;
import com.imadcn.framework.idworker.register.AbstractWorkerRegister;
import com.imadcn.framework.idworker.register.zookeeper.NodeInfo;
import com.imadcn.framework.idworker.register.zookeeper.NodePath;
import com.imadcn.framework.idworker.registry.CoordinatorRegistryCenter;
import com.imadcn.framework.idworker.serialize.json.FastJsonSerializer;
import com.imadcn.framework.idworker.serialize.json.JacksonSerializer;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.springframework.util.StringUtils;

public class ZookeeperWorkerRegister
extends AbstractWorkerRegister {
    public ZookeeperWorkerRegister(CoordinatorRegistryCenter regCenter, ApplicationConfiguration applicationConfiguration) {
        this.setRegCenter(regCenter);
        this.setNodePath(new NodePath(applicationConfiguration.getGroup()));
        this.setDurable(applicationConfiguration.isDurable());
        this.setCachable(applicationConfiguration.isCacheable());
        if (!this.isCachable() && this.isDurable()) {
            this.logger.warn("\u300cdurable\u300d&& \u300cNONE cachable\u300d may become a waste");
        }
        if ("fastjson".equals(applicationConfiguration.getSerialize())) {
            this.setJsonSerializer(new FastJsonSerializer<NodeInfo>());
        } else if ("jackson".equals(applicationConfiguration.getSerialize())) {
            this.setJsonSerializer(new JacksonSerializer<NodeInfo>());
        } else {
            throw new ConfigException("unsupported serialize strategy: %s, use: [fastjson / jackson]", applicationConfiguration.getSerialize());
        }
        if (StringUtils.isEmpty((Object)applicationConfiguration.getRegistryFile())) {
            this.setRegistryFile(this.getDefaultFilePath(this.getNodePath().getGroupName()));
        } else {
            this.setRegistryFile(applicationConfiguration.getRegistryFile());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long register() {
        InterProcessMutex lock = null;
        try {
            CuratorFramework client = (CuratorFramework)this.getRegCenter().getRawClient();
            lock = new InterProcessMutex(client, this.getNodePath().getGroupPath());
            int numOfChildren = this.getRegCenter().getNumChildren(this.getNodePath().getWorkerPath());
            if ((long)numOfChildren >= 1024L) throw new RegException("max worker num reached. register failed", new Object[0]);
            if (!lock.acquire(30000L, TimeUnit.MILLISECONDS)) {
                String message = String.format("acquire lock failed after %s ms.", 30000);
                throw new TimeoutException(message);
            }
            NodeInfo localNodeInfo = this.getLocalNodeInfo();
            List<String> children = this.getRegCenter().getChildrenKeys(this.getNodePath().getWorkerPath());
            if (this.isCachable() && localNodeInfo != null && children.contains(String.valueOf(localNodeInfo.getWorkerId()))) {
                String key = this.getNodePathKey(this.getNodePath(), localNodeInfo.getWorkerId());
                String zkNodeInfoJson = this.getRegCenter().get(key);
                NodeInfo zkNodeInfo = this.createNodeInfoFromJsonStr(zkNodeInfoJson);
                if (this.checkNodeInfo(localNodeInfo, zkNodeInfo)) {
                    this.getNodePath().setWorkerId(zkNodeInfo.getWorkerId().intValue());
                    zkNodeInfo.setUpdateTime(new Date());
                    this.updateZookeeperNodeInfo(key, zkNodeInfo);
                    this.saveLocalNodeInfo(zkNodeInfo);
                    this.executeUploadNodeInfoTask(key, zkNodeInfo);
                    long l = zkNodeInfo.getWorkerId().intValue();
                    return l;
                }
            }
            int workerId = 0;
            while ((long)workerId < 1024L) {
                String workerIdStr = String.valueOf(workerId);
                if (!children.contains(workerIdStr)) {
                    NodeInfo applyNodeInfo = this.createNodeInfo(this.getNodePath().getGroupName(), workerId);
                    this.getNodePath().setWorkerId(applyNodeInfo.getWorkerId().intValue());
                    this.saveZookeeperNodeInfo(this.getNodePath().getWorkerIdPath(), applyNodeInfo);
                    this.saveLocalNodeInfo(applyNodeInfo);
                    this.executeUploadNodeInfoTask(this.getNodePath().getWorkerIdPath(), applyNodeInfo);
                    long l = applyNodeInfo.getWorkerId().intValue();
                    return l;
                }
                ++workerId;
            }
            throw new RegException("max worker num reached. register failed", new Object[0]);
        }
        catch (RegException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (Exception ignored) {
                this.logger.error("", (Throwable)ignored);
            }
        }
    }

    @Override
    public synchronized void logout() {
        CuratorFramework client = (CuratorFramework)this.getRegCenter().getRawClient();
        if (client != null && client.getState() == CuratorFrameworkState.STARTED) {
            this.getRegCenter().remove(this.getNodePath().getWorkerIdPath());
            this.getRegCenter().close();
        }
    }

    private void executeUploadNodeInfoTask(final String key, final NodeInfo nodeInfo) {
        Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "upload node info task thread");
                thread.setDaemon(true);
                return thread;
            }
        }).scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ZookeeperWorkerRegister.this.updateZookeeperNodeInfo(key, nodeInfo);
            }
        }, 3L, 3L, TimeUnit.SECONDS);
    }

    private void saveZookeeperNodeInfo(String key, NodeInfo nodeInfo) throws Exception {
        if (this.isDurable()) {
            this.getRegCenter().persist(key, this.jsonizeNodeInfo(nodeInfo));
        } else {
            this.getRegCenter().persistEphemeral(key, this.jsonizeNodeInfo(nodeInfo));
        }
    }

    private void updateZookeeperNodeInfo(String key, NodeInfo nodeInfo) {
        try {
            nodeInfo.setUpdateTime(new Date());
            if (this.isDurable()) {
                this.getRegCenter().persist(key, this.jsonizeNodeInfo(nodeInfo));
            } else {
                this.getRegCenter().persistEphemeral(key, this.jsonizeNodeInfo(nodeInfo));
            }
        }
        catch (Exception e) {
            this.logger.debug("update zookeeper node info error, {}", (Throwable)e);
        }
    }
}

