/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.jdbc.spy;

import com.impossibl.jdbc.spy.ConnectionListener;
import com.impossibl.jdbc.spy.ConnectionTracer;
import com.impossibl.jdbc.spy.Trace;
import com.impossibl.jdbc.spy.TraceOutput;
import com.impossibl.jdbc.spy.XAConnectionListener;
import java.sql.Connection;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.transaction.xa.XAResource;

public class XAConnectionTracer
implements XAConnectionListener {
    TraceOutput out;

    public XAConnectionTracer(TraceOutput out) {
        this.out = out;
    }

    public void trace(Trace trace) {
        this.out.trace(trace);
    }

    @Override
    public void close() {
        this.trace(new Trace.Builder("XAConnection", "close").returned().build());
    }

    @Override
    public void close(Throwable cause) {
        this.trace(new Trace.Builder("XAConnection", "close").threw(cause).build());
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.trace(new Trace.Builder("XAConnection", "addConnectionEventListener").withParameter("listener", listener).returned().build());
    }

    @Override
    public void addConnectionEventListener(Throwable cause, ConnectionEventListener listener) {
        this.trace(new Trace.Builder("XAConnection", "addConnectionEventListener").withParameter("listener", listener).threw(cause).build());
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.trace(new Trace.Builder("XAConnection", "removeConnectionEventListener").withParameter("listener", listener).returned().build());
    }

    @Override
    public void removeConnectionEventListener(Throwable cause, ConnectionEventListener listener) {
        this.trace(new Trace.Builder("XAConnection", "removeConnectionEventListener").withParameter("listener", listener).threw(cause).build());
    }

    @Override
    public void getXAResource(XAResource result) {
        this.trace(new Trace.Builder("XAConnection", "getXAResource").returned(result).build());
    }

    @Override
    public void getXAResource(Throwable cause) {
        this.trace(new Trace.Builder("XAConnection", "getXAResource").threw(cause).build());
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        this.trace(new Trace.Builder("XAConnection", "addStatementEventListener").withParameter("listener", listener).returned().build());
    }

    @Override
    public void addStatementEventListener(Throwable cause, StatementEventListener listener) {
        this.trace(new Trace.Builder("XAConnection", "addStatementEventListener").withParameter("listener", listener).threw(cause).build());
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.trace(new Trace.Builder("XAConnection", "removeStatementEventListener").withParameter("listener", listener).returned().build());
    }

    @Override
    public void removeStatementEventListener(Throwable cause, StatementEventListener listener) {
        this.trace(new Trace.Builder("XAConnection", "removeStatementEventListener").withParameter("listener", listener).threw(cause).build());
    }

    @Override
    public void getConnection(Connection result) {
        this.trace(new Trace.Builder("XAConnection", "getConnection").returned(result).build());
    }

    @Override
    public void getConnection(Throwable cause) {
        this.trace(new Trace.Builder("XAConnection", "getConnection").threw(cause).build());
    }

    @Override
    public ConnectionListener newConnectionListener() {
        return new ConnectionTracer(this.out);
    }
}

