/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.jdbc.spy;

import java.util.LinkedHashMap;
import java.util.stream.Collectors;

public class Trace {
    private String type;
    private String method;
    private LinkedHashMap<String, Object> parameters;
    private boolean isVoid;
    private Object result;
    private Throwable cause;

    public Trace(String type, String method, LinkedHashMap<String, Object> parameters, boolean isVoid, Object result, Throwable cause) {
        this.type = type;
        this.method = method;
        this.parameters = parameters;
        this.isVoid = isVoid;
        this.result = result;
        this.cause = cause;
    }

    public String toString() {
        String res = this.type + "." + this.method + "(" + this.parameters.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(", ")) + ")";
        res = this.cause == null ? res + " returned(" + (this.isVoid ? "" : this.result) + ")" : res + " threw " + this.cause.getClass().getSimpleName() + "(" + this.cause.getMessage() + ")";
        return res;
    }

    public static class Builder {
        private String type;
        private String method;
        private LinkedHashMap<String, Object> parameters;
        private Object result;
        private boolean isVoid;
        private Throwable cause;

        public Builder(String type, String name) {
            this.type = type;
            this.method = name;
            this.parameters = new LinkedHashMap();
        }

        public Builder withParameter(String name, Object value) {
            this.parameters.put(name, value);
            return this;
        }

        public Builder returned(Object value) {
            this.result = value;
            this.isVoid = false;
            return this;
        }

        public Builder returned() {
            this.result = null;
            this.isVoid = true;
            return this;
        }

        public Builder threw(Throwable value) {
            this.cause = value;
            return this;
        }

        public Trace build() {
            return new Trace(this.type, this.method, this.parameters, this.isVoid, this.result, this.cause);
        }
    }
}

