/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.hl7.rule;

import com.imsweb.datagenerator.hl7.NaaccrHl7DataGeneratorOptions;
import com.imsweb.datagenerator.hl7.NaaccrHl7DataGeneratorRule;
import com.imsweb.datagenerator.utils.DistributionUtils;
import com.imsweb.datagenerator.utils.RandomUtils;
import com.imsweb.datagenerator.utils.dto.CityFrequencyDto;
import com.imsweb.layout.hl7.Hl7MessageBuilder;
import com.imsweb.layout.hl7.entity.Hl7Message;
import java.util.Map;

public class CommonOrderSegmentRule
extends NaaccrHl7DataGeneratorRule {
    public CommonOrderSegmentRule() {
        super("common-order-segment", "Common Order Segment (ORC)");
    }

    @Override
    public void execute(Hl7Message message, NaaccrHl7DataGeneratorOptions options, Map<String, Object> context) {
        String facilityStreet = DistributionUtils.getStreetName();
        String[] facilityAddress = null;
        String[] orderingAddress = null;
        if (options != null && options.getState() != null) {
            CityFrequencyDto dto1 = DistributionUtils.getCity(options.getState());
            facilityAddress = new String[]{facilityStreet, null, dto1.getCity(), dto1.getState(), dto1.getZip()};
            CityFrequencyDto dto2 = DistributionUtils.getCity(options.getState());
            orderingAddress = new String[]{DistributionUtils.getStreetName(), null, dto2.getCity(), dto2.getState(), dto2.getZip()};
        }
        new Hl7MessageBuilder(message).withSegment("ORC").withField(Integer.valueOf(1), new String[]{"1"}).withField(Integer.valueOf(21), new String[]{facilityStreet + " Health Center"}).withField(Integer.valueOf(22), facilityAddress).withField(Integer.valueOf(23), new String[0]).withComponent(Integer.valueOf(6), new String[]{RandomUtils.getRandomStringOfDigits(3)}).withComponent(Integer.valueOf(7), new String[]{RandomUtils.getRandomStringOfDigits(7)}).withField(Integer.valueOf(24), orderingAddress);
    }
}

