/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.hl7.rule;

import com.imsweb.datagenerator.hl7.NaaccrHl7DataGeneratorOptions;
import com.imsweb.datagenerator.hl7.NaaccrHl7DataGeneratorRule;
import com.imsweb.datagenerator.utils.DistributionUtils;
import com.imsweb.datagenerator.utils.RandomUtils;
import com.imsweb.datagenerator.utils.dto.CityFrequencyDto;
import com.imsweb.layout.hl7.Hl7MessageBuilder;
import com.imsweb.layout.hl7.entity.Hl7Message;
import java.util.Map;

public class NextOfKinSegmentRule
extends NaaccrHl7DataGeneratorRule {
    public NextOfKinSegmentRule() {
        super("next-of-kin-segment", "Next of Kin Segment (NK1)");
    }

    @Override
    public void execute(Hl7Message message, NaaccrHl7DataGeneratorOptions options, Map<String, Object> context) {
        String hispanicOrigin = (String)context.get("hispanicOrigin");
        String race = (String)context.get("race");
        String[] address = null;
        if (options != null && options.getState() != null) {
            CityFrequencyDto dto = DistributionUtils.getCity(options.getState());
            address = new String[]{DistributionUtils.getStreetName(), null, dto.getCity(), dto.getState(), dto.getZip()};
        }
        new Hl7MessageBuilder(message).withSegment("NK1").withField(Integer.valueOf(1), new String[]{"1"}).withField(Integer.valueOf(2), new String[]{DistributionUtils.getNameLast(hispanicOrigin, race), DistributionUtils.getNameFirst(), RandomUtils.getRandomStringOfLetters(1)}).withField(Integer.valueOf(3), new String[]{"SPO", "spouse", "HL70063"}).withField(Integer.valueOf(4), address).withField(Integer.valueOf(5), new String[0]).withComponent(Integer.valueOf(6), new String[]{RandomUtils.getRandomStringOfDigits(3)}).withComponent(Integer.valueOf(7), new String[]{RandomUtils.getRandomStringOfDigits(7)});
    }
}

