/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.hl7.rule;

import com.imsweb.datagenerator.hl7.NaaccrHl7DataGeneratorOptions;
import com.imsweb.datagenerator.hl7.NaaccrHl7DataGeneratorRule;
import com.imsweb.datagenerator.utils.DistributionUtils;
import com.imsweb.datagenerator.utils.RandomUtils;
import com.imsweb.datagenerator.utils.dto.CityFrequencyDto;
import com.imsweb.layout.hl7.Hl7MessageBuilder;
import com.imsweb.layout.hl7.entity.Hl7Message;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;

public class PatientIdentifierSegmentRule
extends NaaccrHl7DataGeneratorRule {
    private static final Map<String, String> _RACE_MAPPING = new HashMap<String, String>();

    public PatientIdentifierSegmentRule() {
        super("patient-identifier-segment", "Patient Identifier Segment (PID)");
    }

    @Override
    public void execute(Hl7Message message, NaaccrHl7DataGeneratorOptions options, Map<String, Object> context) {
        String sex = DistributionUtils.getSex();
        context.put("sex", sex);
        String race = DistributionUtils.getRace();
        context.put("race", race);
        String hispanicOrigin = DistributionUtils.getHispanicOrigin();
        context.put("hispanicOrigin", hispanicOrigin);
        LocalDate dob = RandomUtils.getRandomDateBetween(LocalDate.of(1925, 1, 1), LocalDate.now().minusYears(1L));
        String[] address = null;
        if (options != null && options.getState() != null) {
            CityFrequencyDto dto = DistributionUtils.getCity(options.getState());
            address = new String[]{DistributionUtils.getStreetName(), null, dto.getCity(), dto.getState(), dto.getZip()};
        }
        context.put("site", DistributionUtils.getSite(sex));
        new Hl7MessageBuilder(message).withSegment("PID").withField(Integer.valueOf(1), new String[]{"1"}).withField(Integer.valueOf(3), new String[0]).withRepeatedField().withComponent(Integer.valueOf(1), new String[]{"MR" + RandomUtils.getRandomStringOfDigits(6)}).withComponent(Integer.valueOf(5), new String[]{"MR"}).withRepeatedField().withComponent(Integer.valueOf(1), new String[]{RandomUtils.getRandomStringOfDigits(9)}).withComponent(Integer.valueOf(5), new String[]{"SS"}).withField(Integer.valueOf(5), new String[]{DistributionUtils.getNameLast(hispanicOrigin, race), DistributionUtils.getNameFirst(sex), RandomUtils.getRandomStringOfLetters(1)}).withField(Integer.valueOf(6), new String[0]).withField(Integer.valueOf(7), new String[]{DateTimeFormatter.ofPattern("yyyyMMdd").format(dob)}).withField(Integer.valueOf(8), new String[]{this.getSex(sex)}).withField(Integer.valueOf(10), new String[]{_RACE_MAPPING.get(race), null, "HL70005"}).withField(Integer.valueOf(11), address).withField(Integer.valueOf(12), new String[]{"999"}).withField(Integer.valueOf(13), new String[0]).withComponent(Integer.valueOf(6), new String[]{RandomUtils.getRandomStringOfDigits(3)}).withComponent(Integer.valueOf(7), new String[]{RandomUtils.getRandomStringOfDigits(7)}).withField(Integer.valueOf(16), new String[]{"M"}).withField(Integer.valueOf(22), new String[]{DistributionUtils.getHispanicOrigin()});
    }

    private String getSex(String num) {
        String sex = "1".equals(num) ? "M" : ("2".equals(num) ? "F" : "U");
        return sex;
    }

    static {
        _RACE_MAPPING.put("03", "1002-5");
        _RACE_MAPPING.put("16", "2029-7");
        _RACE_MAPPING.put("13", "2033-9");
        _RACE_MAPPING.put("06", "2036-2");
        _RACE_MAPPING.put("12", "2037-0");
        _RACE_MAPPING.put("05", "2039-6");
        _RACE_MAPPING.put("08", "2040-4");
        _RACE_MAPPING.put("11", "2041-2");
        _RACE_MAPPING.put("17", "2044-6");
        _RACE_MAPPING.put("14", "2046-1");
        _RACE_MAPPING.put("10", "2047-9");
        _RACE_MAPPING.put("02", "2054-5");
        _RACE_MAPPING.put("25", "2078-4");
        _RACE_MAPPING.put("07", "2079-2");
        _RACE_MAPPING.put("27", "2080-0");
        _RACE_MAPPING.put("26", "2081-8");
        _RACE_MAPPING.put("28", "2082-6");
        _RACE_MAPPING.put("20", "2085-9");
        _RACE_MAPPING.put("22", "2087-5");
        _RACE_MAPPING.put("21", "2088-3");
        _RACE_MAPPING.put("30", "2100-6");
        _RACE_MAPPING.put("31", "2101-4");
        _RACE_MAPPING.put("32", "2102-2");
        _RACE_MAPPING.put("01", "2106-3");
        _RACE_MAPPING.put("98", "2131-1");
        _RACE_MAPPING.put("97", "2500-7");
    }
}

