/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.naaccr;

import com.imsweb.datagenerator.DataGenerator;
import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorOptions;
import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorPatientRule;
import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorTumorRule;
import com.imsweb.datagenerator.naaccr.rule.patient.AddressCurrentRule;
import com.imsweb.datagenerator.naaccr.rule.patient.BirthRule;
import com.imsweb.datagenerator.naaccr.rule.patient.ComputedEthnicityRule;
import com.imsweb.datagenerator.naaccr.rule.patient.DeathRule;
import com.imsweb.datagenerator.naaccr.rule.patient.HispanicOriginRule;
import com.imsweb.datagenerator.naaccr.rule.patient.NameRule;
import com.imsweb.datagenerator.naaccr.rule.patient.PatientIdRule;
import com.imsweb.datagenerator.naaccr.rule.patient.RaceRule;
import com.imsweb.datagenerator.naaccr.rule.patient.SexRule;
import com.imsweb.datagenerator.naaccr.rule.patient.SsnRule;
import com.imsweb.datagenerator.naaccr.rule.patient.TelephoneRule;
import com.imsweb.datagenerator.naaccr.rule.patient.VitalStatusRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.AddressAtDxRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.AgeRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.CensusRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.DateOfConclusiveDxRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.DateOfDiagnosisRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.DateOfInitialRxRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.DateOfLastContactRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.DxConfirmationRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.DxProcTextRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.FacilityRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.MaritalStatusRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.MultiTumorsRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.PhysicianRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.PrimaryPayerRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.ReportingSourceRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.RxSummaryRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.RxTextRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.SeerCodingSystemRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.SeerRecordNumberRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.SeerTypeOfFollowUpRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.SequenceNumberCentralRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.SiteRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.StagingInputRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.TumorMarkerRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.TumorRecordNumberRule;
import com.imsweb.datagenerator.naaccr.rule.tumor.TumorTextRule;
import com.imsweb.datagenerator.utils.Distribution;
import com.imsweb.datagenerator.utils.DistributionUtils;
import com.imsweb.datagenerator.utils.dto.SiteFrequencyDto;
import com.imsweb.naaccrxml.entity.AbstractEntity;
import com.imsweb.naaccrxml.entity.Item;
import com.imsweb.naaccrxml.entity.Patient;
import com.imsweb.naaccrxml.entity.Tumor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class NaaccrDataGenerator
implements DataGenerator {
    public static final String CONTEXT_FLAG_SEX = "sex";
    public static final String CONTEXT_FLAG_CURRENT_TUMOR_INDEX = "currentTumorIndex";
    public static final String CONTEXT_FLAG_SITE_FREQ_MAP = "siteFreqMap";
    public static final String CONTEXT_FLAG_AGE_GROUP_MAP = "ageGroupMap";
    public static final String CONTEXT_FLAG_MAX_AGE_GROUP = "maxAgeGroup";
    private final List<NaaccrDataGeneratorPatientRule> _patientRules = new ArrayList<NaaccrDataGeneratorPatientRule>();
    private final List<NaaccrDataGeneratorTumorRule> _tumorRules;

    protected NaaccrDataGenerator(boolean useMaidenNameField) {
        this._patientRules.add(new PatientIdRule());
        this._patientRules.add(new SexRule());
        this._patientRules.add(new RaceRule());
        this._patientRules.add(new HispanicOriginRule());
        this._patientRules.add(new SsnRule());
        this._patientRules.add(new NameRule(useMaidenNameField));
        this._patientRules.add(new VitalStatusRule());
        this._patientRules.add(new DeathRule());
        this._patientRules.add(new BirthRule());
        this._patientRules.add(new AddressCurrentRule());
        this._patientRules.add(new ComputedEthnicityRule());
        this._patientRules.add(new TelephoneRule());
        this._tumorRules = new ArrayList<NaaccrDataGeneratorTumorRule>();
        this._tumorRules.add(new TumorRecordNumberRule());
        this._tumorRules.add(new SeerRecordNumberRule());
        this._tumorRules.add(new SequenceNumberCentralRule());
        this._tumorRules.add(new DateOfDiagnosisRule());
        this._tumorRules.add(new SiteRule());
        this._tumorRules.add(new AgeRule());
        this._tumorRules.add(new DateOfInitialRxRule());
        this._tumorRules.add(new DateOfLastContactRule());
        this._tumorRules.add(new AddressAtDxRule());
        this._tumorRules.add(new MaritalStatusRule());
        this._tumorRules.add(new DxConfirmationRule());
        this._tumorRules.add(new ReportingSourceRule());
        this._tumorRules.add(new CensusRule());
        this._tumorRules.add(new RxSummaryRule());
        this._tumorRules.add(new SeerTypeOfFollowUpRule());
        this._tumorRules.add(new PrimaryPayerRule());
        this._tumorRules.add(new TumorMarkerRule());
        this._tumorRules.add(new SeerCodingSystemRule());
        this._tumorRules.add(new MultiTumorsRule());
        this._tumorRules.add(new DateOfConclusiveDxRule());
        this._tumorRules.add(new StagingInputRule());
        this._tumorRules.add(new FacilityRule());
        this._tumorRules.add(new PhysicianRule());
        this._tumorRules.add(new TumorTextRule());
        this._tumorRules.add(new DxProcTextRule());
        this._tumorRules.add(new RxTextRule());
    }

    public void addPatientRule(NaaccrDataGeneratorPatientRule rule) {
        this._patientRules.add(rule);
    }

    public boolean removePatientRule(String ruleId) {
        return this._patientRules.remove(this.getPatientRule(ruleId));
    }

    public boolean replacePatientRule(NaaccrDataGeneratorPatientRule newRule) {
        int idx = this._patientRules.indexOf(newRule);
        if (idx != -1) {
            this._patientRules.set(idx, newRule);
            return true;
        }
        return false;
    }

    public NaaccrDataGeneratorPatientRule getPatientRule(String ruleId) {
        for (NaaccrDataGeneratorPatientRule rule : this._patientRules) {
            if (!ruleId.equals(rule.getId())) continue;
            return rule;
        }
        return null;
    }

    public List<NaaccrDataGeneratorPatientRule> getPatientRules() {
        return this._patientRules;
    }

    public void addTumorRule(NaaccrDataGeneratorTumorRule rule) {
        this._tumorRules.add(rule);
    }

    public boolean removeTumorRule(String ruleId) {
        return this._tumorRules.remove(this.getTumorRule(ruleId));
    }

    public boolean replaceTumorRule(NaaccrDataGeneratorTumorRule newRule) {
        int idx = this._tumorRules.indexOf(newRule);
        if (idx != -1) {
            this._tumorRules.set(idx, newRule);
            return true;
        }
        return false;
    }

    public NaaccrDataGeneratorTumorRule getTumorRule(String ruleId) {
        for (NaaccrDataGeneratorTumorRule rule : this._tumorRules) {
            if (!ruleId.equals(rule.getId())) continue;
            return rule;
        }
        return null;
    }

    public List<NaaccrDataGeneratorTumorRule> getTumorRules() {
        return this._tumorRules;
    }

    protected Patient internalGeneratePatient(int numTumors, NaaccrDataGeneratorOptions options, boolean useFullDates) {
        if (numTumors < 1) {
            throw new IllegalArgumentException("Number of tumors must be greater than 0");
        }
        if (options == null) {
            options = new NaaccrDataGeneratorOptions();
        }
        Map<String, Object> context = this.generateInitialPatientContext(numTumors);
        Patient patient = new Patient();
        if (options.getConstantPatientValuesPreProcessing() != null) {
            for (Map.Entry entry : options.getConstantPatientValuesPreProcessing().entrySet()) {
                this.setValue((AbstractEntity)patient, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        for (NaaccrDataGeneratorPatientRule naaccrDataGeneratorPatientRule : this._patientRules) {
            if (!this.allPropertiesHaveValue(patient, null, naaccrDataGeneratorPatientRule.getRequiredProperties())) continue;
            naaccrDataGeneratorPatientRule.execute(patient, options, context);
        }
        if (options.getConstantPatientValuesPostProcessing() != null) {
            for (Map.Entry entry : options.getConstantPatientValuesPostProcessing().entrySet()) {
                this.setValue((AbstractEntity)patient, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        for (Item item2 : patient.getItems().stream().filter(item -> this.isInvalidValidField(item.getNaaccrId())).collect(Collectors.toList())) {
            patient.removeItem(item2);
        }
        for (int i = 0; i < numTumors; ++i) {
            context.put(CONTEXT_FLAG_CURRENT_TUMOR_INDEX, i);
            Tumor tumor = new Tumor();
            if (options.getConstantTumorValuesPreProcessing() != null) {
                for (Map.Entry entry : options.getConstantTumorValuesPreProcessing().entrySet()) {
                    this.setValue((AbstractEntity)tumor, (String)entry.getKey(), (String)entry.getValue());
                }
            }
            for (NaaccrDataGeneratorTumorRule naaccrDataGeneratorTumorRule : this._tumorRules) {
                if (!this.allPropertiesHaveValue(patient, tumor, naaccrDataGeneratorTumorRule.getRequiredProperties())) continue;
                naaccrDataGeneratorTumorRule.execute(tumor, patient, options, context);
            }
            for (Item item3 : tumor.getItems().stream().filter(item -> this.isInvalidValidField(item.getNaaccrId())).collect(Collectors.toList())) {
                tumor.removeItem(item3);
            }
            if (options.getConstantTumorValuesPostProcessing() != null) {
                for (Map.Entry entry : options.getConstantTumorValuesPostProcessing().entrySet()) {
                    this.setValue((AbstractEntity)tumor, (String)entry.getKey(), (String)entry.getValue());
                }
            }
            patient.addTumor(tumor);
        }
        if (useFullDates) {
            this.addFullDates((AbstractEntity)patient);
            for (Tumor tumor : patient.getTumors()) {
                this.addFullDates((AbstractEntity)tumor);
            }
        }
        return patient;
    }

    protected void setValue(AbstractEntity entity, String property, String value) {
        Item item = entity.getItem(property);
        if (item != null) {
            item.setValue(value);
        } else {
            entity.addItem(new Item(property, value));
        }
    }

    protected abstract boolean isInvalidValidField(String var1);

    private Map<String, Object> generateInitialPatientContext(int numTumors) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(CONTEXT_FLAG_SEX, DistributionUtils.getSex());
        context.put(CONTEXT_FLAG_CURRENT_TUMOR_INDEX, -1);
        HashMap<Integer, SiteFrequencyDto> siteFreqMap = new HashMap<Integer, SiteFrequencyDto>();
        HashMap<Integer, Integer> ageGroupMap = new HashMap<Integer, Integer>();
        int maxAgeGroup = -1;
        for (int i = 0; i < numTumors; ++i) {
            SiteFrequencyDto dto = DistributionUtils.getSite((String)context.get(CONTEXT_FLAG_SEX));
            siteFreqMap.put(i, dto);
            int iAgeGroup = DistributionUtils.getAgeGroup(dto.getSite());
            ageGroupMap.put(i, iAgeGroup);
            maxAgeGroup = Integer.max(maxAgeGroup, iAgeGroup);
        }
        context.put(CONTEXT_FLAG_SITE_FREQ_MAP, siteFreqMap);
        context.put(CONTEXT_FLAG_AGE_GROUP_MAP, ageGroupMap);
        context.put(CONTEXT_FLAG_MAX_AGE_GROUP, maxAgeGroup);
        return context;
    }

    public Distribution<Integer> getNumTumorsPerPatientDistribution() {
        HashMap<Integer, Double> frequencies = new HashMap<Integer, Double>();
        frequencies.put(1, 95.0);
        frequencies.put(2, 4.0);
        frequencies.put(3, 1.0);
        return Distribution.of(frequencies);
    }

    protected boolean allPropertiesHaveValue(Patient patient, Tumor tumor, List<String> properties) {
        for (String property : properties) {
            String val = patient.getItemValue(property);
            if (StringUtils.isBlank((CharSequence)val) && tumor != null) {
                val = tumor.getItemValue(property);
            }
            if (!StringUtils.isBlank((CharSequence)val)) continue;
            return false;
        }
        return true;
    }

    protected void addFullDates(AbstractEntity entity) {
        for (String yearProp : entity.getItems().stream().map(Item::getNaaccrId).filter(i -> i.endsWith("Year")).collect(Collectors.toList())) {
            String prop = yearProp.replace("Year", "");
            String yearVal = entity.getItemValue(prop + "Year");
            String monthVal = entity.getItemValue(prop + "Month");
            String dayVal = entity.getItemValue(prop + "Day");
            StringBuilder val = new StringBuilder(StringUtils.leftPad((String)yearVal, (int)4, (char)'0'));
            if (!StringUtils.isBlank((CharSequence)monthVal)) {
                val.append(StringUtils.leftPad((String)monthVal, (int)2, (char)'0'));
            }
            if (!StringUtils.isBlank((CharSequence)dayVal)) {
                val.append(StringUtils.leftPad((String)dayVal, (int)2, (char)'0'));
            }
            this.setValue(entity, prop, val.toString());
            entity.removeItem(prop + "Year");
            entity.removeItem(prop + "Month");
            entity.removeItem(prop + "Day");
        }
    }
}

