/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.naaccr;

import com.imsweb.naaccrxml.entity.AbstractEntity;
import com.imsweb.naaccrxml.entity.Item;
import com.imsweb.naaccrxml.entity.Tumor;
import java.util.Collections;
import java.util.List;

public abstract class NaaccrDataGeneratorRule {
    private final String _id;
    private final String _name;

    protected NaaccrDataGeneratorRule(String id, String name) {
        this._id = id;
        this._name = name;
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public List<String> getRequiredProperties() {
        return Collections.emptyList();
    }

    protected void setValue(AbstractEntity entity, String property, String value) {
        Item item = entity.getItem(property);
        if (item != null) {
            item.setValue(value);
        } else {
            entity.addItem(new Item(property, value));
        }
    }

    protected boolean hasValue(AbstractEntity entity, String ... properties) {
        for (String property : properties) {
            String val = entity.getItemValue(property);
            if (val != null && !val.trim().isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected boolean inDxYearRange(Tumor tumor, Integer fromYear, Integer toYear) {
        String dxYear = tumor.getItemValue("dateOfDiagnosisYear");
        if (dxYear == null) {
            return false;
        }
        int dxYearVal = Integer.parseInt(dxYear);
        return !(fromYear != null && dxYearVal < fromYear || toYear != null && dxYearVal > toYear);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NaaccrDataGeneratorRule)) {
            return false;
        }
        NaaccrDataGeneratorRule that = (NaaccrDataGeneratorRule)o;
        return this._id.equals(that._id);
    }

    public final int hashCode() {
        return this._id.hashCode();
    }
}

