/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.naaccr;

import com.imsweb.datagenerator.naaccr.NaaccrDataGenerator;
import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorOptions;
import com.imsweb.datagenerator.utils.Distribution;
import com.imsweb.layout.LayoutFactory;
import com.imsweb.layout.naaccrxml.NaaccrXmlLayout;
import com.imsweb.naaccrxml.NaaccrOptions;
import com.imsweb.naaccrxml.NaaccrXmlDictionaryUtils;
import com.imsweb.naaccrxml.PatientXmlWriter;
import com.imsweb.naaccrxml.entity.Item;
import com.imsweb.naaccrxml.entity.NaaccrData;
import com.imsweb.naaccrxml.entity.Patient;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionary;
import com.imsweb.seerutils.SeerUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;

public class NaaccrXmlDataGenerator
extends NaaccrDataGenerator {
    private final NaaccrXmlLayout _xmlLayout;

    public NaaccrXmlDataGenerator(String layoutId) {
        this(LayoutFactory.getNaaccrXmlLayout((String)layoutId));
    }

    public NaaccrXmlDataGenerator(NaaccrXmlLayout layout) {
        super(layout == null || "180".compareTo(layout.getNaaccrVersion()) <= 0);
        if (layout == null) {
            throw new IllegalStateException("A layout is required for creating a NAACCR XML data generator!");
        }
        this._xmlLayout = layout;
    }

    @Override
    public String getId() {
        return this._xmlLayout.getLayoutId();
    }

    @Override
    protected boolean isInvalidValidField(String name) {
        return this._xmlLayout.getFieldByName(name) == null;
    }

    public Patient generatePatient(int numTumors) {
        return this.generatePatient(numTumors, null);
    }

    public Patient generatePatient(int numTumors, NaaccrDataGeneratorOptions options) {
        return this.internalGeneratePatient(numTumors, options, true);
    }

    public void generateFile(File file, int numTumors) throws IOException {
        this.generateFile(file, numTumors, null);
    }

    public void generateFile(File file, int numTumors, NaaccrDataGeneratorOptions options) throws IOException {
        this.generateFile(file, numTumors, options, null);
    }

    public void generateFile(File file, int numTumors, NaaccrDataGeneratorOptions options, NaaccrOptions writerOptions) throws IOException {
        if (numTumors < 1) {
            throw new IllegalArgumentException("Number of tumors must be greater than 0");
        }
        if (options == null) {
            options = new NaaccrDataGeneratorOptions();
        }
        Distribution<Integer> numTumGen = options.getNumTumorsPerPatient() == null ? this.getNumTumorsPerPatientDistribution() : null;
        NaaccrData rootData = new NaaccrData();
        rootData.setBaseDictionaryUri(NaaccrXmlDictionaryUtils.getBaseDictionaryByVersion((String)this._xmlLayout.getLayoutVersion()).getDictionaryUri());
        rootData.setRecordType(this._xmlLayout.getRecordType());
        if (options.getRegistryId() != null) {
            rootData.addItem(new Item("registryId", options.getRegistryId()));
        }
        List userDictionaries = this._xmlLayout.getUserDictionaries().stream().filter(d -> !NaaccrXmlDictionaryUtils.isDefaultUserDictionary((NaaccrDictionary)d)).collect(Collectors.toList());
        try (OutputStream os = SeerUtils.createOutputStream((File)file);
             PatientXmlWriter writer = new PatientXmlWriter((Writer)new OutputStreamWriter(os, StandardCharsets.UTF_8), rootData, writerOptions, userDictionaries);){
            int numTumorForThisPatient;
            for (int numCreatedTumors = 0; numCreatedTumors < numTumors; numCreatedTumors += numTumorForThisPatient) {
                numTumorForThisPatient = Math.min(numTumGen == null ? options.getNumTumorsPerPatient() : numTumGen.getValue(), numTumors - numCreatedTumors);
                this._xmlLayout.writeNextPatient(writer, this.generatePatient(numTumorForThisPatient, options));
            }
        }
    }
}

