/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.naaccr.rule.patient;

import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorOptions;
import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorPatientRule;
import com.imsweb.datagenerator.utils.DistributionUtils;
import com.imsweb.datagenerator.utils.RandomUtils;
import com.imsweb.datagenerator.utils.dto.CityFrequencyDto;
import com.imsweb.naaccrxml.entity.AbstractEntity;
import com.imsweb.naaccrxml.entity.Patient;
import java.util.Map;

public class AddressCurrentRule
extends NaaccrDataGeneratorPatientRule {
    public static final String ID = "address-current";

    public AddressCurrentRule() {
        super(ID, "Current address");
    }

    @Override
    public void execute(Patient patient, NaaccrDataGeneratorOptions options, Map<String, Object> context) {
        if (options == null || options.getState() == null) {
            return;
        }
        CityFrequencyDto dto = DistributionUtils.getCity(options.getState());
        this.setValue((AbstractEntity)patient, "addrCurrentCity", dto.getCity());
        this.setValue((AbstractEntity)patient, "addrCurrentPostalCode", dto.getZip());
        this.setValue((AbstractEntity)patient, "addrCurrentState", dto.getState());
        this.setValue((AbstractEntity)patient, "countyCurrent", "999");
        this.setValue((AbstractEntity)patient, "addrCurrentCountry", "USA");
        String name = DistributionUtils.getStreetName();
        String suffix = DistributionUtils.getStreetSuffix();
        this.setValue((AbstractEntity)patient, "addrCurrentNoStreet", RandomUtils.nextInt(9998) + 1 + " " + name + " " + suffix);
    }
}

