/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.naaccr.rule.patient;

import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorOptions;
import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorPatientRule;
import com.imsweb.naaccrxml.entity.AbstractEntity;
import com.imsweb.naaccrxml.entity.Patient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ComputedEthnicityRule
extends NaaccrDataGeneratorPatientRule {
    public static final String ID = "computed-ethnicity";
    protected static final String _FILE_SPANISH_SURNAMES = "frequencies/spanish_surnames.csv";
    protected List<String> _surnames = this.loadSurnamesFromResources();

    public ComputedEthnicityRule() {
        super(ID, "Computed Ethnicity");
    }

    @Override
    public List<String> getRequiredProperties() {
        return Arrays.asList("sex", "nameLast");
    }

    @Override
    public void execute(Patient patient, NaaccrDataGeneratorOptions options, Map<String, Object> context) {
        boolean birthSurnameEmpty;
        boolean lastNameMatch = this._surnames.contains(patient.getItemValue("nameLast").toUpperCase());
        String birthSurname = patient.getItemValue("nameBirthSurname");
        if (StringUtils.isBlank((CharSequence)birthSurname)) {
            birthSurname = patient.getItemValue("nameMaiden");
        }
        boolean birthSurnameMatch = !(birthSurnameEmpty = StringUtils.isBlank((CharSequence)birthSurname)) && this._surnames.contains(birthSurname.toUpperCase());
        boolean isFemale = patient.getItemValue("sex").equals("2");
        String computedEthnicity = birthSurnameMatch && isFemale ? "7" : (!lastNameMatch ? (isFemale ? (birthSurnameEmpty ? "3" : "1") : "2") : (isFemale ? (birthSurnameEmpty ? "6" : "4") : "5"));
        this.setValue((AbstractEntity)patient, "computedEthnicity", computedEthnicity);
        this.setValue((AbstractEntity)patient, "computedEthnicitySource", "2");
    }

    protected List<String> loadSurnamesFromResources() {
        ArrayList<String> spanishSurnames = new ArrayList<String>();
        URL url = Thread.currentThread().getContextClassLoader().getResource(_FILE_SPANISH_SURNAMES);
        if (url == null) {
            throw new IllegalStateException("Resource at 'frequencies/spanish_surnames.csv' could not be found");
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                spanishSurnames.add(line);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
        return spanishSurnames;
    }
}

