/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.naaccr.rule.tumor;

import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorOptions;
import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorTumorRule;
import com.imsweb.datagenerator.utils.DistributionUtils;
import com.imsweb.datagenerator.utils.RandomUtils;
import com.imsweb.datagenerator.utils.dto.CityFrequencyDto;
import com.imsweb.naaccrxml.entity.AbstractEntity;
import com.imsweb.naaccrxml.entity.Patient;
import com.imsweb.naaccrxml.entity.Tumor;
import java.util.Map;

public class AddressAtDxRule
extends NaaccrDataGeneratorTumorRule {
    public static final String ID = "address-dx";

    public AddressAtDxRule() {
        super(ID, "Address at DX");
    }

    @Override
    public void execute(Tumor tumor, Patient patient, NaaccrDataGeneratorOptions options, Map<String, Object> context) {
        if (options == null || options.getState() == null) {
            return;
        }
        if (patient != null && !patient.getTumors().isEmpty() && RandomUtils.nextInt(10) < 8) {
            Tumor otherTumor = patient.getTumor(patient.getTumors().size() - 1);
            this.setValue((AbstractEntity)tumor, "addrAtDxCity", otherTumor.getItemValue("addrAtDxCity"));
            this.setValue((AbstractEntity)tumor, "addrAtDxPostalCode", otherTumor.getItemValue("addrAtDxPostalCode"));
            this.setValue((AbstractEntity)tumor, "addrAtDxState", otherTumor.getItemValue("addrAtDxState"));
            this.setValue((AbstractEntity)tumor, "countyAtDx", otherTumor.getItemValue("countyAtDx"));
            this.setValue((AbstractEntity)tumor, "addrAtDxCountry", otherTumor.getItemValue("addrAtDxCountry"));
            this.setValue((AbstractEntity)tumor, "addrAtDxNoStreet", otherTumor.getItemValue("addrAtDxNoStreet"));
        } else {
            CityFrequencyDto dto = DistributionUtils.getCity(options.getState());
            this.setValue((AbstractEntity)tumor, "addrAtDxCity", dto.getCity());
            this.setValue((AbstractEntity)tumor, "addrAtDxPostalCode", dto.getZip());
            this.setValue((AbstractEntity)tumor, "addrAtDxState", dto.getState());
            this.setValue((AbstractEntity)tumor, "countyAtDx", "999");
            this.setValue((AbstractEntity)tumor, "addrAtDxCountry", "USA");
            String name = DistributionUtils.getStreetName();
            String suffix = DistributionUtils.getStreetSuffix();
            this.setValue((AbstractEntity)tumor, "addrAtDxNoStreet", RandomUtils.nextInt(9998) + 1 + " " + name + " " + suffix);
        }
    }
}

