/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.naaccr.rule.tumor;

import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorOptions;
import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorTumorRule;
import com.imsweb.datagenerator.utils.RandomUtils;
import com.imsweb.datagenerator.utils.dto.PhysicianFrequencyDto;
import com.imsweb.naaccrxml.entity.AbstractEntity;
import com.imsweb.naaccrxml.entity.Patient;
import com.imsweb.naaccrxml.entity.Tumor;
import java.util.Map;

public class PhysicianRule
extends NaaccrDataGeneratorTumorRule {
    public static final String ID = "physician";

    public PhysicianRule() {
        super(ID, "Physician fields");
    }

    @Override
    public void execute(Tumor tumor, Patient patient, NaaccrDataGeneratorOptions options, Map<String, Object> context) {
        if (options != null && options.getPhysicians() != null && !options.getPhysicians().isEmpty()) {
            PhysicianFrequencyDto physicianManaging = options.getPhysicians().get(RandomUtils.nextInt(options.getPhysicians().size()));
            this.setValue((AbstractEntity)tumor, "npiPhysicianManaging", physicianManaging.getNpi());
            this.setValue((AbstractEntity)tumor, "physicianManaging", physicianManaging.getLastName() + ", " + physicianManaging.getFirstName());
            PhysicianFrequencyDto physicianFollowup = options.getPhysicians().get(RandomUtils.nextInt(options.getPhysicians().size()));
            this.setValue((AbstractEntity)tumor, "npiPhysicianFollowUp", physicianFollowup.getNpi());
            this.setValue((AbstractEntity)tumor, "physicianFollowUp", physicianFollowup.getLastName() + ", " + physicianFollowup.getFirstName());
            PhysicianFrequencyDto physicianPrimary = options.getPhysicians().get(RandomUtils.nextInt(options.getPhysicians().size()));
            this.setValue((AbstractEntity)tumor, "npiPhysicianPrimarySurg", physicianPrimary.getNpi());
            this.setValue((AbstractEntity)tumor, "physicianPrimarySurg", physicianPrimary.getLastName() + ", " + physicianPrimary.getFirstName());
        }
    }
}

