/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.naaccr.rule.tumor;

import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorOptions;
import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorTumorRule;
import com.imsweb.naaccrxml.entity.AbstractEntity;
import com.imsweb.naaccrxml.entity.Patient;
import com.imsweb.naaccrxml.entity.Tumor;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RxSummaryRule
extends NaaccrDataGeneratorTumorRule {
    public static final String ID = "rx-summary";

    public RxSummaryRule() {
        super(ID, "RX Summary fields");
    }

    @Override
    public List<String> getRequiredProperties() {
        return Collections.singletonList("dateOfDiagnosisYear");
    }

    @Override
    public void execute(Tumor tumor, Patient patient, NaaccrDataGeneratorOptions options, Map<String, Object> context) {
        this.setValue((AbstractEntity)tumor, "rxSummTreatmentStatus", "9");
        if (this.inDxYearRange(tumor, 1998, null)) {
            this.setValue((AbstractEntity)tumor, "rxSummSurgPrimSite", "99");
        }
        if (this.inDxYearRange(tumor, 2003, null)) {
            this.setValue((AbstractEntity)tumor, "rxSummScopeRegLnSur", "9");
            this.setValue((AbstractEntity)tumor, "rxSummSurgOthRegDis", "9");
        }
        if (this.inDxYearRange(tumor, 1997, 2003)) {
            this.setValue((AbstractEntity)tumor, "rxSummRegLnExamined", "99");
        }
        this.setValue((AbstractEntity)tumor, "rxSummSurgicalMargins", "9");
        this.setValue((AbstractEntity)tumor, "rxSummDxStgProc", "09");
        this.setValue((AbstractEntity)tumor, "rxSummPalliativeProc", "9");
        this.setValue((AbstractEntity)tumor, "rxSummRadiation", "9");
        this.setValue((AbstractEntity)tumor, "rxSummRadToCns", "9");
        this.setValue((AbstractEntity)tumor, "rxSummSurgRadSeq", "9");
        this.setValue((AbstractEntity)tumor, "rxSummTransplntEndocr", "99");
        this.setValue((AbstractEntity)tumor, "rxSummChemo", "99");
        this.setValue((AbstractEntity)tumor, "rxSummHormone", "99");
        this.setValue((AbstractEntity)tumor, "rxSummBrm", "99");
        this.setValue((AbstractEntity)tumor, "rxSummOther", "9");
        if (this.inDxYearRange(tumor, 2006, null)) {
            this.setValue((AbstractEntity)tumor, "rxSummSystemicSurSeq", "9");
        }
        if (this.inDxYearRange(tumor, 1998, 2002)) {
            this.setValue((AbstractEntity)tumor, "rxSummSurgSite9802", "99");
            this.setValue((AbstractEntity)tumor, "rxSummScopeReg9802", "9");
            this.setValue((AbstractEntity)tumor, "rxSummSurgOth9802", "9");
        }
        this.setValue((AbstractEntity)tumor, "reasonForNoSurgery", "8");
    }
}

