/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.naaccr.rule.tumor;

import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorOptions;
import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorTumorRule;
import com.imsweb.datagenerator.utils.RandomUtils;
import com.imsweb.naaccrxml.entity.AbstractEntity;
import com.imsweb.naaccrxml.entity.Patient;
import com.imsweb.naaccrxml.entity.Tumor;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SeerCodingSystemRule
extends NaaccrDataGeneratorTumorRule {
    public static final String ID = "seer-coding-system";

    public SeerCodingSystemRule() {
        super(ID, "SEER Coding System");
    }

    @Override
    public List<String> getRequiredProperties() {
        return Collections.singletonList("dateOfDiagnosisYear");
    }

    @Override
    public void execute(Tumor tumor, Patient patient, NaaccrDataGeneratorOptions options, Map<String, Object> context) {
        if (!this.inDxYearRange(tumor, 2004, null)) {
            return;
        }
        int yearDx = Integer.parseInt(tumor.getItemValue("dateOfDiagnosisYear"));
        String code = yearDx > 2003 && yearDx < 2007 ? "7" : (yearDx == 2007 ? Integer.toString(RandomUtils.nextInt(2) + 8) : (yearDx > 2007 && yearDx < 2010 ? "9" : (yearDx == 2010 ? "A" : (yearDx == 2011 ? "B" : (yearDx == 2012 ? "C" : (yearDx == 2013 ? "D" : (yearDx == 2014 ? "E" : (yearDx == 2015 ? "F" : (yearDx == 2016 || yearDx == 2017 ? "G" : "H")))))))));
        this.setValue((AbstractEntity)tumor, "seerCodingSysCurrent", code);
    }
}

