/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.naaccr.rule.tumor;

import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorOptions;
import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorTumorRule;
import com.imsweb.datagenerator.utils.StagingUtils;
import com.imsweb.datagenerator.utils.dto.SiteFrequencyDto;
import com.imsweb.naaccrxml.entity.AbstractEntity;
import com.imsweb.naaccrxml.entity.Patient;
import com.imsweb.naaccrxml.entity.Tumor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class StagingInputRule
extends NaaccrDataGeneratorTumorRule {
    public static final String ID = "staging-input";

    public StagingInputRule() {
        super(ID, "Staging input fields");
    }

    @Override
    public List<String> getRequiredProperties() {
        return Arrays.asList("primarySite", "histologicTypeIcdO3", "dateOfDiagnosisYear");
    }

    @Override
    public void execute(Tumor tumor, Patient patient, NaaccrDataGeneratorOptions options, Map<String, Object> context) {
        SiteFrequencyDto siteFrequency;
        Map siteFreqMap = (Map)context.get("siteFreqMap");
        if (siteFreqMap != null && (siteFrequency = (SiteFrequencyDto)siteFreqMap.get((Integer)context.get("currentTumorIndex"))) != null) {
            Map<String, String> randomValidValues = null;
            int dxYear = Integer.parseInt(tumor.getItemValue("dateOfDiagnosisYear"));
            if (dxYear >= 2004 && dxYear <= 2015) {
                randomValidValues = StagingUtils.getCsValues(siteFrequency.getCsSchemaId());
            } else if (dxYear >= 2016 && dxYear <= 2017) {
                randomValidValues = StagingUtils.getTnmValues(siteFrequency.getTnmSchemaId());
            } else if (dxYear >= 2018) {
                randomValidValues = StagingUtils.getEodValues(siteFrequency.getEodSchemaId());
            }
            if (randomValidValues != null) {
                for (Map.Entry<String, String> entry : randomValidValues.entrySet()) {
                    this.setValue((AbstractEntity)tumor, entry.getKey(), entry.getValue().trim());
                }
            }
        }
    }

    public String getDescription() {
        return "This rule assigns a value to the staging input field.\n\nWhich staging framework is used is based on the DX year:\n - 2004-2015: CS\n - 2016-2017: TNM\n - 2018+: EOD\n\nThe schema is determined based on the assgned site/histology.\n\nSome combinations of site/histolgy correspond to more than one schema; a discriminator should be used to \nuniquely identify the schema but this framework doesn't use discriminators, it just takes the \"first\" schema found.\n\nOnce a schema has been identified, every input field is assigned wiht one of its \"valid\" value.\nAny of the valid values for a given input has the same probability to be picked.";
    }
}

