/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.record;

import com.imsweb.datagenerator.DataGenerator;
import com.imsweb.datagenerator.record.RecordDataGeneratorRule;
import com.imsweb.layout.record.RecordLayout;
import com.imsweb.seerutils.SeerUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecordDataGenerator
implements DataGenerator {
    private final RecordLayout _layout;
    private final List<RecordDataGeneratorRule> _rules;

    public RecordDataGenerator(RecordLayout layout) {
        if (layout == null) {
            throw new IllegalArgumentException("A layout is required for creating a record-based data generator!");
        }
        this._layout = layout;
        this._rules = new ArrayList<RecordDataGeneratorRule>();
    }

    @Override
    public String getId() {
        return this._layout.getLayoutId();
    }

    public void addRule(RecordDataGeneratorRule rule) {
        this._rules.add(rule);
    }

    public List<RecordDataGeneratorRule> getRules() {
        return this._rules;
    }

    public Map<String, String> generateRecord(Map<String, Object> options) {
        HashMap<String, String> rec = new HashMap<String, String>();
        for (RecordDataGeneratorRule rule : this._rules) {
            rule.execute(rec, options);
        }
        return rec;
    }

    public void generateFile(File file, int numRecords, Map<String, Object> options) throws IOException {
        if (numRecords < 1) {
            throw new IllegalArgumentException("Number of records must be greater than 0.");
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(SeerUtils.createOutputStream((File)file), StandardCharsets.UTF_8));){
            for (int i = 0; i < numRecords; ++i) {
                this._layout.writeRecord((Writer)writer, this.generateRecord(options));
            }
        }
    }
}

