/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.utils;

import com.imsweb.datagenerator.utils.DistributionElement;
import com.imsweb.datagenerator.utils.RandomUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.StringUtils;

public class Distribution<T> {
    private List<DistributionElement<T>> _frequencies;
    private final double _frequenciesTotal;

    public static <D> Distribution<D> of(Map<D, Double> frequencies) {
        return new Distribution(frequencies.entrySet().stream().map(e -> new DistributionElement((Double)e.getValue(), e.getKey())).collect(Collectors.toList()));
    }

    public static <D> Distribution<D> of(List<D> values) {
        return new Distribution(values.stream().map(e -> new DistributionElement<Object>(1.0, e)).collect(Collectors.toList()));
    }

    public static Distribution<String> of(URL url) {
        return Distribution.of(url, String.class, null);
    }

    public static <D> Distribution<D> of(URL url, Class<D> valueType, Map<Integer, String> columnsMapping) {
        try {
            InputStream is = url.openStream();
            if (url.getPath().toLowerCase().endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            ArrayList elements = new ArrayList();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line = reader.readLine();
                while (line != null) {
                    DistributionElement<String> element = new DistributionElement<String>();
                    String[] values = StringUtils.splitPreserveAllTokens((String)line, (char)',');
                    if (values.length == 1) {
                        element.setValue(values[0]);
                        element.setFrequency(1.0);
                    } else if (values.length == 2) {
                        element.setValue(values[1]);
                        element.setFrequency(Double.parseDouble(values[0]));
                    } else {
                        D obj = valueType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        for (Map.Entry<Integer, String> entry : columnsMapping.entrySet()) {
                            int idx = entry.getKey();
                            if (idx >= values.length) {
                                throw new IllegalStateException("Invalid column index " + idx + " for line " + line);
                            }
                            valueType.getMethod("set" + StringUtils.capitalize((String)entry.getValue()), String.class).invoke(obj, values[entry.getKey()]);
                        }
                        element.setValue((String)obj);
                        element.setFrequency(Double.parseDouble(values[0]));
                    }
                    elements.add(element);
                    line = reader.readLine();
                }
            }
            return new Distribution(elements);
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to process provided distribution URL", e);
        }
    }

    public Distribution(List<DistributionElement<T>> frequencies) {
        this._frequencies = frequencies;
        this._frequencies.sort(Comparator.comparing(DistributionElement::getFrequency));
        this._frequenciesTotal = this._frequencies.stream().mapToDouble(DistributionElement::getFrequency).sum();
    }

    public List<DistributionElement<T>> getFrequencies() {
        return this._frequencies;
    }

    public void setFrequencies(List<DistributionElement<T>> frequencies) {
        this._frequencies = frequencies;
    }

    public T getValue() {
        double rand = RandomUtils.nextDouble();
        double ratio = 1.0 / this._frequenciesTotal;
        double tempDist = 0.0;
        for (DistributionElement<T> element : this._frequencies) {
            if (!(rand / ratio <= (tempDist += element.getFrequency().doubleValue()))) continue;
            return element.getValue();
        }
        return this._frequencies.isEmpty() ? null : (T)this._frequencies.get(0).getValue();
    }
}

