/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.utils;

import com.imsweb.datagenerator.utils.Distribution;
import com.imsweb.datagenerator.utils.RandomUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class StagingUtils {
    private static Map<String, String> _KEYS;
    private static Map<String, Map<String, Distribution<String>>> _CS_DATA;
    private static Map<String, Map<String, Distribution<String>>> _TNM_DATA;
    private static Map<String, Map<String, Distribution<String>>> _EOD_DATA;
    private static final Pattern _STARTS_WITH_LETTER_PATTERN;

    private StagingUtils() {
    }

    public static void clearCache() {
        _KEYS = null;
        _CS_DATA = null;
        _TNM_DATA = null;
        _EOD_DATA = null;
    }

    public static synchronized String unformatKey(String key) {
        if (_KEYS == null) {
            _KEYS = new HashMap<String, String>();
            try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("frequencies/staging_keys.csv");
                 BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.US_ASCII));){
                String line = reader.readLine();
                while (line != null) {
                    String[] parts = StringUtils.split((String)line, (char)',');
                    _KEYS.put(parts[1], parts[0]);
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to read staging keys", e);
            }
        }
        return _KEYS.get(key);
    }

    public static synchronized Map<String, String> getCsValues(String csSchemaKey) {
        Map<String, Distribution<String>> data;
        if (StringUtils.isBlank((CharSequence)csSchemaKey)) {
            return new HashMap<String, String>();
        }
        if (_CS_DATA == null) {
            _CS_DATA = StagingUtils.loadFile("staging_cs.csv");
        }
        if ((data = _CS_DATA.get(csSchemaKey)) == null) {
            return new HashMap<String, String>();
        }
        return StagingUtils.getStagingValues(data);
    }

    public static synchronized Map<String, String> getTnmValues(String tnmSchemaKey) {
        Map<String, Distribution<String>> data;
        if (StringUtils.isBlank((CharSequence)tnmSchemaKey)) {
            return new HashMap<String, String>();
        }
        if (_TNM_DATA == null) {
            _TNM_DATA = StagingUtils.loadFile("staging_tnm.csv");
        }
        if ((data = _TNM_DATA.get(tnmSchemaKey)) == null) {
            return new HashMap<String, String>();
        }
        return StagingUtils.getStagingValues(data);
    }

    public static synchronized Map<String, String> getEodValues(String eodSchemaKey) {
        Map<String, Distribution<String>> data;
        if (StringUtils.isBlank((CharSequence)eodSchemaKey)) {
            return new HashMap<String, String>();
        }
        if (_EOD_DATA == null) {
            _EOD_DATA = StagingUtils.loadFile("staging_eod.csv");
        }
        if ((data = _EOD_DATA.get(eodSchemaKey)) == null) {
            return new HashMap<String, String>();
        }
        return StagingUtils.getStagingValues(data);
    }

    private static Map<String, String> getStagingValues(Map<String, Distribution<String>> data) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, Distribution<String>> entry : data.entrySet()) {
            String val = entry.getValue().getValue();
            int idx = val.indexOf(45);
            if (idx != -1 && idx != val.length() - 1) {
                int high;
                int low;
                Matcher highMather;
                String lowVal = val.substring(0, idx);
                String highVal = val.substring(idx + 1);
                String firstLetter = "";
                Matcher lowMather = _STARTS_WITH_LETTER_PATTERN.matcher(lowVal);
                if (lowMather.matches()) {
                    firstLetter = lowMather.group(1);
                    lowVal = lowVal.substring(1);
                }
                if ((highMather = _STARTS_WITH_LETTER_PATTERN.matcher(highVal)).matches()) {
                    highVal = highVal.substring(1);
                }
                int idxLow = lowVal.indexOf(46);
                int idxHigh = highVal.indexOf(46);
                if (idxLow != -1 && idxHigh != -1) {
                    low = Integer.parseInt(lowVal.replace(".", ""));
                    high = Integer.parseInt(highVal.replace(".", ""));
                    result.put(StagingUtils.unformatKey(entry.getKey()), firstLetter + StagingUtils.reformatValueWithPeriod(StringUtils.leftPad((String)String.valueOf(RandomUtils.nextIntInRange(low, high)), (int)2, (char)'0')));
                    continue;
                }
                low = Integer.parseInt(lowVal);
                high = Integer.parseInt(highVal);
                result.put(StagingUtils.unformatKey(entry.getKey()), firstLetter + StringUtils.leftPad((String)String.valueOf(RandomUtils.nextIntInRange(low, high)), (int)((val.length() - 1) / 2), (char)'0'));
                continue;
            }
            result.put(StagingUtils.unformatKey(entry.getKey()), val);
        }
        return result;
    }

    static String reformatValueWithPeriod(String value) {
        return value.substring(0, value.length() - 1) + "." + value.substring(value.length() - 1);
    }

    private static Map<String, Map<String, Distribution<String>>> loadFile(String filename) {
        HashMap<String, Map<String, Distribution<String>>> result = new HashMap<String, Map<String, Distribution<String>>>();
        String line = null;
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("frequencies/" + filename);
             BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.US_ASCII));){
            line = reader.readLine();
            while (line != null) {
                String[] parts = StringUtils.split((String)line, (char)',');
                String schemaKey = parts[0];
                String fieldKey = parts[1];
                String[] values = StringUtils.split((String)parts[2], (char)';');
                result.computeIfAbsent(schemaKey, k -> new HashMap()).put(fieldKey, StagingUtils.createDistribution(values));
                line = reader.readLine();
            }
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Unable to read staging data: " + line, e);
        }
        return result;
    }

    static Distribution<String> createDistribution(String[] values) {
        HashMap<String, Double> frequencies = new HashMap<String, Double>(values.length);
        for (String val : values) {
            int idx = val.indexOf(45);
            if (idx != -1 && idx != val.length() - 1) {
                String highVal;
                String lowVal = val.substring(0, idx);
                if (_STARTS_WITH_LETTER_PATTERN.matcher(lowVal).matches()) {
                    lowVal = lowVal.substring(1);
                }
                if (_STARTS_WITH_LETTER_PATTERN.matcher(highVal = val.substring(idx + 1)).matches()) {
                    highVal = highVal.substring(1);
                }
                int idxLow = lowVal.indexOf(46);
                int idxHigh = highVal.indexOf(46);
                if (idxLow != -1 && idxHigh != -1) {
                    frequencies.put(val, (double)Integer.parseInt(highVal.replace(".", "")) - (double)Integer.parseInt(lowVal.replace(".", "")) + 1.0);
                    continue;
                }
                frequencies.put(val, (double)Integer.parseInt(highVal) - (double)Integer.parseInt(lowVal) + 1.0);
                continue;
            }
            frequencies.put(val, 1.0);
        }
        return Distribution.of(frequencies);
    }

    static {
        _STARTS_WITH_LETTER_PATTERN = Pattern.compile("^([A-Z]).+");
    }
}

