/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.hl7;

import com.imsweb.datagenerator.DataGenerator;
import com.imsweb.datagenerator.hl7.NaaccrHl7DataGeneratorOptions;
import com.imsweb.datagenerator.hl7.NaaccrHl7DataGeneratorRule;
import com.imsweb.datagenerator.hl7.rule.CommonOrderSegmentRule;
import com.imsweb.datagenerator.hl7.rule.ControlSegmentRule;
import com.imsweb.datagenerator.hl7.rule.NextOfKinSegmentRule;
import com.imsweb.datagenerator.hl7.rule.ObservationRequestSegmentRule;
import com.imsweb.datagenerator.hl7.rule.ObservationSegmentRule;
import com.imsweb.datagenerator.hl7.rule.PatientIdentifierSegmentRule;
import com.imsweb.datagenerator.hl7.rule.PatientVisitSegmentRule;
import com.imsweb.datagenerator.hl7.rule.SpecimenSegmentRule;
import com.imsweb.layout.LayoutFactory;
import com.imsweb.layout.hl7.NaaccrHl7Layout;
import com.imsweb.layout.hl7.entity.Hl7Message;
import com.imsweb.seerutils.SeerUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NaaccrHl7DataGenerator
implements DataGenerator {
    protected NaaccrHl7Layout _layout;
    protected List<NaaccrHl7DataGeneratorRule> _rules;

    public NaaccrHl7DataGenerator(String layoutId) {
        this(LayoutFactory.getNaaccrHl7Layout((String)layoutId));
    }

    public NaaccrHl7DataGenerator(NaaccrHl7Layout layout) {
        if (layout == null) {
            throw new IllegalStateException("A layout is required for creating a NAACCR HL7 data generator!");
        }
        this._layout = layout;
        this._rules = new ArrayList<NaaccrHl7DataGeneratorRule>();
        this._rules.add(new ControlSegmentRule());
        this._rules.add(new PatientIdentifierSegmentRule());
        this._rules.add(new NextOfKinSegmentRule());
        this._rules.add(new PatientVisitSegmentRule());
        this._rules.add(new CommonOrderSegmentRule());
        this._rules.add(new ObservationRequestSegmentRule());
        this._rules.add(new SpecimenSegmentRule());
        this._rules.add(new ObservationSegmentRule());
    }

    @Override
    public String getId() {
        return this._layout.getLayoutId();
    }

    public void addRule(NaaccrHl7DataGeneratorRule rule) {
        this._rules.add(rule);
    }

    public boolean removeRule(String ruleId) {
        return this._rules.remove(this.getRule(ruleId));
    }

    public boolean replaceRule(NaaccrHl7DataGeneratorRule newRule) {
        int idx = this._rules.indexOf(newRule);
        if (idx != -1) {
            this._rules.set(idx, newRule);
            return true;
        }
        return false;
    }

    public NaaccrHl7DataGeneratorRule getRule(String ruleId) {
        for (NaaccrHl7DataGeneratorRule rule : this._rules) {
            if (!ruleId.equals(rule.getId())) continue;
            return rule;
        }
        return null;
    }

    public List<NaaccrHl7DataGeneratorRule> getRules() {
        return this._rules;
    }

    public Hl7Message generateMessage() {
        return this.generateMessage(null);
    }

    public Hl7Message generateMessage(NaaccrHl7DataGeneratorOptions options) {
        Hl7Message message = new Hl7Message();
        HashMap<String, Object> context = new HashMap<String, Object>();
        for (NaaccrHl7DataGeneratorRule rule : this._rules) {
            rule.execute(message, options, context);
        }
        return message;
    }

    public void generateFile(File file, int numMessages) throws IOException {
        this.generateFile(file, numMessages, null);
    }

    public void generateFile(File file, int numMessages, NaaccrHl7DataGeneratorOptions options) throws IOException {
        if (numMessages < 1) {
            throw new IllegalStateException("Number of messages must be greater than 0.");
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(SeerUtils.createOutputStream((File)file), StandardCharsets.UTF_8));){
            for (int i = 0; i < numMessages; ++i) {
                this._layout.writeMessage((Writer)writer, this.generateMessage(options));
                writer.newLine();
            }
        }
    }
}

