/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.naaccr;

import com.imsweb.datagenerator.utils.DistributionUtils;
import com.imsweb.datagenerator.utils.dto.FacilityFrequencyDto;
import com.imsweb.datagenerator.utils.dto.PhysicianFrequencyDto;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

public class NaaccrDataGeneratorOptions {
    protected Integer _numTumorsPerPatient;
    protected String _state;
    protected Map<String, String> _constantPatientValuesPreProcessing;
    protected Map<String, String> _constantPatientValuesPostProcessing;
    protected Map<String, String> _constantTumorValuesPreProcessing;
    protected Map<String, String> _constantTumorValuesPostProcessing;
    protected Integer _maxDxYear;
    protected Integer _minDxYear;
    protected String _vitalStatusDeadValue;
    protected String _registryId;
    protected List<FacilityFrequencyDto> _facilityList;
    protected List<PhysicianFrequencyDto> _physicianList;

    public Integer getNumTumorsPerPatient() {
        return this._numTumorsPerPatient;
    }

    public void setNumTumorsPerPatient(Integer numTumorsPerPatient) {
        if (numTumorsPerPatient < 1 || numTumorsPerPatient > 10) {
            throw new IllegalArgumentException("Number of tumors per patient must be between 1 and 10");
        }
        this._numTumorsPerPatient = numTumorsPerPatient;
    }

    public String getState() {
        return this._state;
    }

    public void setState(String state) {
        if (state != null && !DistributionUtils.getAllStates().contains(state.toUpperCase())) {
            throw new IllegalArgumentException("State '" + state + "' is not a valid US state");
        }
        this._state = state;
    }

    public Map<String, String> getConstantPatientValuesPreProcessing() {
        return this._constantPatientValuesPreProcessing;
    }

    public void setConstantPatientValuesPreProcessing(Map<String, String> constantPatientValuesPreProcessing) {
        this._constantPatientValuesPreProcessing = constantPatientValuesPreProcessing;
    }

    public Map<String, String> getConstantPatientValuesPostProcessing() {
        return this._constantPatientValuesPostProcessing;
    }

    public void setConstantPatientValuesPostProcessing(Map<String, String> constantPatientValuesPostProcessing) {
        this._constantPatientValuesPostProcessing = constantPatientValuesPostProcessing;
    }

    public Map<String, String> getConstantTumorValuesPreProcessing() {
        return this._constantTumorValuesPreProcessing;
    }

    public void setConstantTumorValuesPreProcessing(Map<String, String> constantTumorValuesPreProcessing) {
        this._constantTumorValuesPreProcessing = constantTumorValuesPreProcessing;
    }

    public Map<String, String> getConstantTumorValuesPostProcessing() {
        return this._constantTumorValuesPostProcessing;
    }

    public void setConstantTumorValuesPostProcessing(Map<String, String> constantTumorValuesPostProcessing) {
        this._constantTumorValuesPostProcessing = constantTumorValuesPostProcessing;
    }

    public void setMaxDxYear(Integer maxDxYear) {
        if (maxDxYear < 1900 || maxDxYear > 2100) {
            throw new IllegalArgumentException("Max DX Year must be between 1900 and 2100");
        }
        if (this._minDxYear != null && this._minDxYear > maxDxYear) {
            throw new IllegalArgumentException("Max DX Year must be greater than or equal to Min DX Year (" + this._minDxYear + ")");
        }
        this._maxDxYear = maxDxYear;
    }

    public void setMinDxYear(Integer minDxYear) {
        if (minDxYear < 1900 || minDxYear > 2100) {
            throw new IllegalArgumentException("Min DX Year must be between 1900 and 2100");
        }
        if (this._maxDxYear != null && this._maxDxYear < minDxYear) {
            throw new IllegalArgumentException("Min DX Year must be less than or equal to Max DX Year (" + this._maxDxYear + ")");
        }
        this._minDxYear = minDxYear;
    }

    public String getVitalStatusDeadValue() {
        return this._vitalStatusDeadValue;
    }

    public void setVitalStatusDeadValue(String vitalStatusDeadValue) {
        this._vitalStatusDeadValue = vitalStatusDeadValue;
    }

    public LocalDate getMinDxDate() {
        return this._minDxYear == null ? LocalDate.now().minusYears(10L) : LocalDate.of((int)this._minDxYear, 1, 1);
    }

    public LocalDate getMaxDxDate() {
        if (this._maxDxYear == null || this._maxDxYear.intValue() == LocalDate.now().getYear()) {
            return LocalDate.now();
        }
        return LocalDate.of((int)this._maxDxYear, 12, 31);
    }

    public void setRegistryId(String registryId) {
        this._registryId = registryId;
    }

    public String getRegistryId() {
        return this._registryId;
    }

    public void setFacilities(List<FacilityFrequencyDto> facilityList) {
        this._facilityList = facilityList;
    }

    public void setPhysicians(List<PhysicianFrequencyDto> physicianList) {
        this._physicianList = physicianList;
    }

    public List<FacilityFrequencyDto> getFacilities() {
        return this._facilityList;
    }

    public List<PhysicianFrequencyDto> getPhysicians() {
        return this._physicianList;
    }
}

