/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.naaccr.rule.tumor;

import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorOptions;
import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorTumorRule;
import com.imsweb.naaccrxml.entity.AbstractEntity;
import com.imsweb.naaccrxml.entity.Patient;
import com.imsweb.naaccrxml.entity.Tumor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MultiTumorsRule
extends NaaccrDataGeneratorTumorRule {
    public static final String ID = "multi-tumors";

    public MultiTumorsRule() {
        super(ID, "Multiple Tumors fields");
    }

    @Override
    public List<String> getRequiredProperties() {
        return Arrays.asList("dateOfDiagnosisYear", "dateOfDiagnosisMonth", "dateOfDiagnosisDay");
    }

    @Override
    public void execute(Tumor tumor, Patient patient, NaaccrDataGeneratorOptions options, Map<String, Object> context) {
        if (!this.inDxYearRange(tumor, 2007, null)) {
            return;
        }
        this.setValue((AbstractEntity)tumor, "dateOfMultTumorsYear", tumor.getItemValue("dateOfDiagnosisYear"));
        this.setValue((AbstractEntity)tumor, "dateOfMultTumorsMonth", tumor.getItemValue("dateOfDiagnosisMonth"));
        this.setValue((AbstractEntity)tumor, "dateOfMultTumorsDay", tumor.getItemValue("dateOfDiagnosisDay"));
        this.setValue((AbstractEntity)tumor, "multiTumorRptAsOnePrim", "99");
        this.setValue((AbstractEntity)tumor, "multiplicityCounter", "99");
    }
}

