/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.naaccr;

import com.imsweb.datagenerator.naaccr.NaaccrDataGenerator;
import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorOptions;
import com.imsweb.datagenerator.utils.Distribution;
import com.imsweb.layout.LayoutFactory;
import com.imsweb.layout.record.RecordLayoutOptions;
import com.imsweb.layout.record.fixed.naaccr.NaaccrLayout;
import com.imsweb.naaccrxml.entity.Patient;
import com.imsweb.naaccrxml.entity.Tumor;
import com.imsweb.seerutils.SeerUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NaaccrFixedColumnsDataGenerator
extends NaaccrDataGenerator {
    private final NaaccrLayout _layout;

    public NaaccrFixedColumnsDataGenerator(String layoutId) {
        this(LayoutFactory.getNaaccrFixedColumnsLayout((String)layoutId));
    }

    public NaaccrFixedColumnsDataGenerator(NaaccrLayout layout) {
        super(true);
        if (layout == null) {
            throw new IllegalStateException("A layout is required for creating a NAACCR data generator!");
        }
        this._layout = layout;
    }

    @Override
    public String getId() {
        return this._layout.getLayoutId();
    }

    @Override
    protected boolean isInvalidValidField(String name) {
        return this._layout.getFieldByName(name) == null;
    }

    public List<Map<String, String>> generatePatient(int numTumors) {
        return this.generatePatient(numTumors, null);
    }

    public List<Map<String, String>> generatePatient(int numTumors, NaaccrDataGeneratorOptions options) {
        Patient patient = this.internalGeneratePatient(numTumors, options, false);
        ArrayList<Map<String, String>> records = new ArrayList<Map<String, String>>();
        for (Tumor tumor : patient.getTumors()) {
            HashMap<String, String> rec = new HashMap<String, String>();
            if (options != null && options.getRegistryId() != null) {
                rec.put("registryId", options.getRegistryId());
            }
            patient.getItems().forEach(i -> rec.put(i.getNaaccrId(), i.getValue()));
            tumor.getItems().forEach(i -> rec.put(i.getNaaccrId(), i.getValue()));
            records.add(rec);
        }
        return records;
    }

    public void generateFile(File file, int numTumors) throws IOException {
        this.generateFile(file, numTumors, null);
    }

    public void generateFile(File file, int numTumors, NaaccrDataGeneratorOptions options) throws IOException {
        if (numTumors < 1) {
            throw new IllegalArgumentException("Number of tumors must be greater than 0");
        }
        if (options == null) {
            options = new NaaccrDataGeneratorOptions();
        }
        Distribution<Integer> numTumGen = options.getNumTumorsPerPatient() == null ? this.getNumTumorsPerPatientDistribution() : null;
        try (OutputStream os = SeerUtils.createOutputStream((File)file);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));){
            RecordLayoutOptions layoutOptions = new RecordLayoutOptions();
            layoutOptions.setValueTooLongHandling("nullify");
            int numCreatedTumors = 0;
            while (numCreatedTumors < numTumors) {
                int numTumorForThisPatient = numTumGen == null ? options.getNumTumorsPerPatient() : numTumGen.getValue();
                for (Map<String, String> tumor : this.generatePatient(Math.min(numTumorForThisPatient, numTumors - numCreatedTumors), options)) {
                    this._layout.writeRecord((Writer)writer, tumor, layoutOptions);
                    ++numCreatedTumors;
                }
            }
        }
    }
}

