/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.naaccr.rule.patient;

import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorOptions;
import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorPatientRule;
import com.imsweb.datagenerator.utils.DistributionUtils;
import com.imsweb.datagenerator.utils.RandomUtils;
import com.imsweb.naaccrxml.entity.AbstractEntity;
import com.imsweb.naaccrxml.entity.Patient;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class NameRule
extends NaaccrDataGeneratorPatientRule {
    public static final String ID = "name";
    private static final String[] _VALUES_PREFIXES_MALE = new String[]{"Dr", "Rev", "Mr"};
    private static final String[] _VALUES_PREFIXES_FEMALE = new String[]{"Dr", "Rev", "Ms", "Mrs"};
    private static final String[] _VALUES_SUFFIXES = new String[]{"CPA", "LLD", "MD", "PhD", "Ret", "RN"};
    private static final String[] _VALUES_SUFFIXES_MALE = new String[]{"Jr.", "Sr.", "III", "IV"};
    private final boolean _useMaidenNameField;

    public NameRule(boolean useMaidenNameField) {
        super(ID, "Name (Last, First, Middle, Prefix, Suffix and Maiden if needed)");
        this._useMaidenNameField = useMaidenNameField;
    }

    @Override
    public List<String> getRequiredProperties() {
        return Arrays.asList("spanishHispanicOrigin", "race1", "sex");
    }

    @Override
    public void execute(Patient patient, NaaccrDataGeneratorOptions options, Map<String, Object> context) {
        this.setValue((AbstractEntity)patient, "nameLast", this.getLastNameByRace(patient));
        this.setValue((AbstractEntity)patient, "nameMiddle", this.getMiddleName(patient));
        this.setValue((AbstractEntity)patient, "nameFirst", this.getFirstName(patient));
        this.setValue((AbstractEntity)patient, "namePrefix", this.getPrefix(patient));
        this.setValue((AbstractEntity)patient, "nameSuffix", this.getSuffix(patient));
        String surnameKey = this._useMaidenNameField ? "nameMaiden" : "nameBirthSurname";
        this.setValue((AbstractEntity)patient, surnameKey, this.getBirthSurnameName(patient));
        if (!StringUtils.isBlank((CharSequence)patient.getItemValue(surnameKey))) {
            this.setValue((AbstractEntity)patient, "nameLast", this.getSpouseLastName(patient));
        }
    }

    protected String getLastNameByRace(Patient patient) {
        return DistributionUtils.getNameLast(patient.getItemValue("spanishHispanicOrigin"), patient.getItemValue("race1"));
    }

    protected String getFirstName(Patient patient) {
        return DistributionUtils.getNameFirst(patient.getItemValue("sex"));
    }

    protected String getMiddleName(Patient patient) {
        String name = DistributionUtils.getNameFirst(patient.getItemValue("sex"));
        return RandomUtils.nextInt(20) == 0 ? name.charAt(0) + "." : name;
    }

    protected String getPrefix(Patient patient) {
        if (RandomUtils.nextInt(100) > 1) {
            return "";
        }
        if ("1".equals(patient.getItemValue("sex"))) {
            return _VALUES_PREFIXES_MALE[RandomUtils.nextInt(_VALUES_PREFIXES_MALE.length)];
        }
        return _VALUES_PREFIXES_FEMALE[RandomUtils.nextInt(_VALUES_PREFIXES_FEMALE.length)];
    }

    protected String getSuffix(Patient patient) {
        if (RandomUtils.nextInt(100) > 2) {
            return "";
        }
        String suffix = "";
        if ("1".equals(patient.getItemValue("sex"))) {
            suffix = _VALUES_SUFFIXES_MALE[RandomUtils.nextInt(_VALUES_SUFFIXES_MALE.length)];
        }
        if (RandomUtils.nextInt(1) == 0) {
            suffix = _VALUES_SUFFIXES[RandomUtils.nextInt(_VALUES_SUFFIXES.length)];
        }
        return suffix;
    }

    protected String getBirthSurnameName(Patient patient) {
        String birthSurname = "";
        if ("2".equals(patient.getItemValue("sex")) && RandomUtils.nextInt(100) < 60) {
            birthSurname = patient.getItemValue("nameLast");
        }
        return birthSurname;
    }

    protected String getSpouseLastName(Patient patient) {
        return DistributionUtils.getNameLast(patient.getItemValue("spanishHispanicOrigin"), patient.getItemValue("race1"));
    }
}

