/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.hl7.rule;

import com.imsweb.datagenerator.hl7.NaaccrHl7DataGeneratorOptions;
import com.imsweb.datagenerator.hl7.NaaccrHl7DataGeneratorRule;
import com.imsweb.datagenerator.utils.DistributionUtils;
import com.imsweb.datagenerator.utils.RandomUtils;
import com.imsweb.layout.hl7.Hl7MessageBuilder;
import com.imsweb.layout.hl7.entity.Hl7Message;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public class ObservationRequestSegmentRule
extends NaaccrHl7DataGeneratorRule {
    public ObservationRequestSegmentRule() {
        super("observation-request-segment", "Observation Request Segment (OBR)");
    }

    @Override
    public void execute(Hl7Message message, NaaccrHl7DataGeneratorOptions options, Map<String, Object> context) {
        LocalDate observationDate = RandomUtils.getRandomDateBetween(LocalDate.now().minusYears(1L), LocalDate.now()).minusMonths(1L);
        new Hl7MessageBuilder(message).withSegment("OBR").withField(Integer.valueOf(1), new String[]{"1"}).withField(Integer.valueOf(3), new String[]{RandomUtils.getRandomStringOfDigits(6)}).withField(Integer.valueOf(4), new String[]{"11529-5", "SURGICAL PATH REPORT", "LN"}).withField(Integer.valueOf(7), new String[]{DateTimeFormatter.ofPattern("yyyyMMdd").format(observationDate)}).withField(Integer.valueOf(10), new String[]{RandomUtils.getRandomStringOfDigits(5), DistributionUtils.getNameLast(), DistributionUtils.getNameFirst()}).withField(Integer.valueOf(14), new String[]{DateTimeFormatter.ofPattern("yyyyMMdd").format(observationDate.plusDays(2L))}).withField(Integer.valueOf(16), new String[0]).withComponent(Integer.valueOf(2), new String[]{DistributionUtils.getNameLast()}).withComponent(Integer.valueOf(3), new String[]{DistributionUtils.getNameFirst()}).withComponent(Integer.valueOf(4), new String[]{RandomUtils.getRandomStringOfLetters(1)}).withField(Integer.valueOf(17), new String[0]).withComponent(Integer.valueOf(6), new String[]{RandomUtils.getRandomStringOfDigits(3)}).withComponent(Integer.valueOf(7), new String[]{RandomUtils.getRandomStringOfDigits(7)}).withField(Integer.valueOf(32), new String[0]).withComponent(Integer.valueOf(1), new String[]{null, DistributionUtils.getNameLast(), DistributionUtils.getNameFirst(), RandomUtils.getRandomStringOfLetters(1)});
    }
}

