/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.naaccr.rule.patient;

import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorOptions;
import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorPatientRule;
import com.imsweb.datagenerator.utils.DistributionUtils;
import com.imsweb.datagenerator.utils.RandomUtils;
import com.imsweb.naaccrxml.entity.AbstractEntity;
import com.imsweb.naaccrxml.entity.Patient;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Map;

public class BirthRule
extends NaaccrDataGeneratorPatientRule {
    public static final String ID = "birth";

    public BirthRule() {
        super(ID, "Date of Birth, Birthplace Country and State");
    }

    @Override
    public void execute(Patient patient, NaaccrDataGeneratorOptions options, Map<String, Object> context) {
        LocalDate maxBirthDate = options == null ? LocalDate.now() : options.getMinDxDate().minusYears(5L);
        LocalDate minBirthDate = maxBirthDate.minusYears(100L);
        Integer maxAgeGroup = (Integer)context.get("maxAgeGroup");
        if (maxAgeGroup != null && maxAgeGroup >= 0) {
            maxBirthDate = minBirthDate.plusYears(100L - (long)(maxAgeGroup * 10));
            if (options != null) {
                LocalDate maxDxDate;
                LocalDate minDxDate = options.getMinDxDate();
                long daysBetween = minDxDate.until(maxDxDate = options.getMaxDxDate(), ChronoUnit.DAYS) - 1L;
                if (daysBetween > 3650L) {
                    daysBetween = 3650L;
                }
                minBirthDate = minDxDate.minusYears((long)maxAgeGroup.intValue() * 10L);
                maxBirthDate = minBirthDate.plusDays(daysBetween);
            }
        }
        LocalDate randomDate = RandomUtils.getRandomDateBetween(minBirthDate, maxBirthDate);
        this.setValue((AbstractEntity)patient, "dateOfBirthYear", Integer.toString(randomDate.getYear()));
        this.setValue((AbstractEntity)patient, "dateOfBirthMonth", Integer.toString(randomDate.getMonthValue()));
        this.setValue((AbstractEntity)patient, "dateOfBirthDay", Integer.toString(randomDate.getDayOfMonth()));
        this.setValue((AbstractEntity)patient, "birthplaceState", DistributionUtils.getState());
        this.setValue((AbstractEntity)patient, "birthplaceCountry", "USA");
    }
}

