/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.datagenerator.naaccr.rule.tumor;

import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorOptions;
import com.imsweb.datagenerator.naaccr.NaaccrDataGeneratorTumorRule;
import com.imsweb.datagenerator.utils.RandomUtils;
import com.imsweb.naaccrxml.entity.AbstractEntity;
import com.imsweb.naaccrxml.entity.Patient;
import com.imsweb.naaccrxml.entity.Tumor;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Map;

public class DateOfDiagnosisRule
extends NaaccrDataGeneratorTumorRule {
    public static final String ID = "date-of-diagnosis";

    public DateOfDiagnosisRule() {
        super(ID, "Date of Diagnosis");
    }

    @Override
    public void execute(Tumor tumor, Patient patient, NaaccrDataGeneratorOptions options, Map<String, Object> context) {
        HashSet<LocalDate> maxDxDates = new HashSet<LocalDate>();
        LocalDate maxDate = options == null ? LocalDate.now() : options.getMaxDxDate();
        maxDxDates.add(maxDate);
        HashSet<LocalDate> minDxDates = new HashSet<LocalDate>();
        minDxDates.add(options == null ? LocalDate.now().minusYears(10L) : options.getMinDxDate());
        if (this.hasValue((AbstractEntity)patient, "dateOfBirthYear")) {
            minDxDates.add(LocalDate.of(Integer.parseInt(patient.getItemValue("dateOfBirthYear")) + 1, 1, 1));
        }
        if (!patient.getTumors().isEmpty()) {
            Tumor lastTumor = patient.getTumor(patient.getTumors().size() - 1);
            minDxDates.add(LocalDate.of(Integer.parseInt(lastTumor.getItemValue("dateOfDiagnosisYear")), Integer.parseInt(lastTumor.getItemValue("dateOfDiagnosisMonth")), Integer.parseInt(lastTumor.getItemValue("dateOfDiagnosisDay"))));
        }
        if (context.get("currentTumorIndex") != null) {
            int birthYear = Integer.parseInt(patient.getItemValue("dateOfBirthYear"));
            int birthMonth = Integer.parseInt(patient.getItemValue("dateOfBirthMonth"));
            int birthDay = Integer.parseInt(patient.getItemValue("dateOfBirthDay"));
            LocalDate dateOfBirth = LocalDate.of(birthYear, birthMonth, birthDay);
            minDxDates.clear();
            maxDxDates.clear();
            int currentTumorIndex = (Integer)context.get("currentTumorIndex");
            Map ageGroupMap = (Map)context.get("ageGroupMap");
            minDxDates.add(dateOfBirth.plusYears((Integer)ageGroupMap.get(currentTumorIndex) * 10));
            maxDxDates.add(maxDate);
        }
        LocalDate randomDate = RandomUtils.getRandomDateBetween(minDxDates, maxDxDates);
        this.setValue((AbstractEntity)tumor, "dateOfDiagnosisYear", Integer.toString(randomDate.getYear()));
        this.setValue((AbstractEntity)tumor, "dateOfDiagnosisMonth", Integer.toString(randomDate.getMonthValue()));
        this.setValue((AbstractEntity)tumor, "dateOfDiagnosisDay", Integer.toString(randomDate.getDayOfMonth()));
    }
}

