/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.layout.hl7.entity;

import com.imsweb.layout.hl7.Hl7Utils;
import com.imsweb.layout.hl7.entity.Hl7Component;
import com.imsweb.layout.hl7.entity.Hl7RepeatedField;
import com.imsweb.layout.hl7.entity.Hl7Segment;
import java.util.ArrayList;
import java.util.List;

public class Hl7Field {
    private Hl7Segment _segment;
    private Integer _index;
    private List<Hl7RepeatedField> _repeatedFields;

    public Hl7Field(Hl7Segment segment, Integer index, String ... values) {
        if (index == null) {
            throw new IllegalStateException("Index is required");
        }
        if (index < 1 || index > 9999) {
            throw new IllegalStateException("Index must be between 1 and 9999");
        }
        this._segment = segment;
        this._index = index;
        this._repeatedFields = new ArrayList<Hl7RepeatedField>();
        if (segment != null) {
            segment.addField(this);
        }
        if (values != null && values.length != 0) {
            Hl7RepeatedField repeatedField = new Hl7RepeatedField(this, new String[0]);
            for (int i = 0; i < values.length; ++i) {
                new Hl7Component(repeatedField, i + 1, values[i]);
            }
        }
    }

    public Hl7Segment getSegment() {
        return this._segment;
    }

    public void setSegment(Hl7Segment segment) {
        if (segment == null) {
            throw new IllegalStateException("Parent segment cannot be null");
        }
        this._segment = segment;
    }

    public Integer getIndex() {
        return this._index;
    }

    public void setIndex(Integer index) {
        if (index == null) {
            throw new IllegalStateException("Index is required");
        }
        if (index < 1 || index > 9999) {
            throw new IllegalStateException("Index must be between 1 and 9999");
        }
        this._index = index;
    }

    public List<Hl7RepeatedField> getRepeatedFields() {
        return this._repeatedFields;
    }

    public void setRepeatedFields(List<Hl7RepeatedField> repeatedFields) {
        this._repeatedFields = repeatedFields == null ? new ArrayList() : repeatedFields;
    }

    public void addRepeatedField(Hl7RepeatedField repeatedField) {
        this._repeatedFields.add(repeatedField);
    }

    public Hl7RepeatedField getRepeatedField(int repeatedFieldIdx) {
        if (--repeatedFieldIdx < 0 || repeatedFieldIdx >= this._repeatedFields.size()) {
            return new Hl7RepeatedField(null, new String[0]);
        }
        Hl7RepeatedField result = this._repeatedFields.get(repeatedFieldIdx);
        return result == null ? new Hl7RepeatedField(null, new String[0]) : result;
    }

    public Hl7Component getComponent(int componentIdx) {
        if (this._repeatedFields.isEmpty()) {
            return new Hl7Component(null, componentIdx, new String[0]);
        }
        return this._repeatedFields.get(0).getComponent(componentIdx);
    }

    public String getValue() {
        String value = Hl7Utils.fieldToString(this, false);
        return value.isEmpty() ? null : value;
    }

    public String getValue(int repeatedFieldIdx) {
        return this.getRepeatedField(repeatedFieldIdx).getValue();
    }

    public String getValue(int repeatedFieldIdx, int componentIdx, int subComponentIdx) {
        return this.getRepeatedField(repeatedFieldIdx).getComponent(componentIdx).getSubComponent(subComponentIdx).getValue();
    }
}

