/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.layout.hl7.entity;

import com.imsweb.layout.hl7.Hl7Utils;
import com.imsweb.layout.hl7.entity.Hl7Component;
import com.imsweb.layout.hl7.entity.Hl7Field;
import java.util.HashMap;
import java.util.Map;

public class Hl7RepeatedField {
    private Hl7Field _field;
    private Map<Integer, Hl7Component> _components;

    public Hl7RepeatedField(Hl7Field field, String ... values) {
        this._field = field;
        this._components = new HashMap<Integer, Hl7Component>();
        if (field != null) {
            field.addRepeatedField(this);
        }
        if (values != null && values.length != 0) {
            for (String value : values) {
                new Hl7Component(this, 1, value);
            }
        }
    }

    public Hl7Field getField() {
        return this._field;
    }

    public void setField(Hl7Field field) {
        if (field == null) {
            throw new IllegalStateException("Parent field cannot be null");
        }
        this._field = field;
    }

    public Map<Integer, Hl7Component> getComponents() {
        return this._components;
    }

    public void setComponents(Map<Integer, Hl7Component> components) {
        this._components = components == null ? new HashMap() : components;
    }

    public void addComponent(Hl7Component component) {
        this._components.put(component.getIndex(), component);
    }

    public Hl7Component getComponent(int componentIdx) {
        Hl7Component result = this._components.get(componentIdx);
        return result == null ? new Hl7Component(null, componentIdx, new String[0]) : result;
    }

    public String getValue() {
        String value = Hl7Utils.repeatedFieldToString(this, false);
        return value.isEmpty() ? null : value;
    }

    public String getValue(int componentIdx) {
        return this.getComponent(componentIdx).getValue();
    }

    public String getValue(int componentIdx, int subComponentIdx) {
        return this.getComponent(componentIdx).getSubComponent(subComponentIdx).getValue();
    }
}

