/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.layout.hl7.entity;

import com.imsweb.layout.hl7.Hl7Utils;
import com.imsweb.layout.hl7.entity.Hl7Field;
import com.imsweb.layout.hl7.entity.Hl7Message;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;

public class Hl7Segment {
    private Hl7Message _message;
    private String _id;
    private Map<Integer, Hl7Field> _fields;

    public Hl7Segment(Hl7Message message, String id) {
        if (id == null) {
            throw new IllegalStateException("ID is required");
        }
        this._message = message;
        this._id = id;
        this._fields = new HashMap<Integer, Hl7Field>();
        if ("MSH".equals(id)) {
            new Hl7Field(this, 1, "|");
            new Hl7Field(this, 2, "^~\\&");
            new Hl7Field(this, 7, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss.SSS")));
            new Hl7Field(this, 9, "ORU", "R01", "ORU_R01");
            new Hl7Field(this, 11, "P");
            new Hl7Field(this, 12, "2.5.1");
            new Hl7Field(this, 21, "VOL_V_50_ORU_R01", "NAACCR_CP");
        }
        if (message != null) {
            message.addSegment(this);
        }
    }

    public Hl7Message getMessage() {
        return this._message;
    }

    public void setMessage(Hl7Message message) {
        if (message == null) {
            throw new IllegalStateException("Parent message cannot be null");
        }
        this._message = message;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        if (id == null) {
            throw new IllegalStateException("ID is required");
        }
        this._id = id;
    }

    public Map<Integer, Hl7Field> getFields() {
        return this._fields;
    }

    public void setFields(Map<Integer, Hl7Field> fields) {
        this._fields = fields == null ? new HashMap() : fields;
    }

    public void addField(Hl7Field field) {
        this._fields.put(field.getIndex(), field);
    }

    public Hl7Field getField(int fieldIdx) {
        Hl7Field result = this._fields.get(fieldIdx);
        return result == null ? new Hl7Field(null, fieldIdx, new String[0]) : result;
    }

    public String getValue() {
        return Hl7Utils.segmentToString(this, false);
    }

    public String getValue(int fieldIdx) {
        return this.getField(fieldIdx).getValue();
    }

    public String getValue(int fieldIdx, int repeatedFieldIdx, int componentIdx, int subComponentIdx) {
        return this.getField(fieldIdx).getRepeatedField(repeatedFieldIdx).getComponent(componentIdx).getSubComponent(subComponentIdx).getValue();
    }
}

