/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.layout.record.fixed;

import com.imsweb.layout.Field;
import com.imsweb.layout.LayoutFactory;
import com.imsweb.layout.LayoutInfo;
import com.imsweb.layout.LayoutInfoDiscoveryOptions;
import com.imsweb.layout.LayoutUtils;
import com.imsweb.layout.record.RecordLayout;
import com.imsweb.layout.record.RecordLayoutOptions;
import com.imsweb.layout.record.fixed.FixedColumnsField;
import com.imsweb.layout.record.fixed.xml.FixedColumnLayoutFieldXmlDto;
import com.imsweb.layout.record.fixed.xml.FixedColumnLayoutXmlDto;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FixedColumnsLayout
extends RecordLayout {
    protected Integer _layoutLineLength;
    protected List<FixedColumnsField> _fields = new ArrayList<FixedColumnsField>();
    protected Map<String, FixedColumnsField> _cachedByName = new HashMap<String, FixedColumnsField>();
    protected Map<Integer, FixedColumnsField> _cachedByNaaccrItemNumber = new HashMap<Integer, FixedColumnsField>();

    public FixedColumnsLayout() {
    }

    public FixedColumnsLayout(URL layoutUrl) throws IOException {
        this();
        if (layoutUrl == null) {
            throw new NullPointerException("Unable to create layout from null URL");
        }
        try (InputStream is = layoutUrl.openStream();){
            this.init(LayoutUtils.readFixedColumnsLayout(is), false);
        }
    }

    public FixedColumnsLayout(File layoutFile) throws IOException {
        this();
        if (layoutFile == null) {
            throw new NullPointerException("Unable to create layout from null file");
        }
        if (!layoutFile.exists()) {
            throw new IOException("Unable to read from " + layoutFile.getPath());
        }
        try (InputStream is = Files.newInputStream(layoutFile.toPath(), new OpenOption[0]);){
            this.init(LayoutUtils.readFixedColumnsLayout(is), false);
        }
    }

    public FixedColumnsLayout(FixedColumnLayoutXmlDto layoutXmlDto) throws IOException {
        this();
        if (layoutXmlDto == null) {
            throw new NullPointerException("Unable to create layout from null XML object");
        }
        this.init(layoutXmlDto, false);
    }

    protected void init(FixedColumnLayoutXmlDto layoutXmlDto, boolean useDeprecatedFieldNames) throws IOException {
        this._layoutId = layoutXmlDto.getId();
        this._layoutName = layoutXmlDto.getName();
        this._layoutVersion = layoutXmlDto.getVersion();
        this._layoutDesc = layoutXmlDto.getDescription();
        this._layoutLineLength = layoutXmlDto.getLength();
        FixedColumnsLayout parentLayout = null;
        if (layoutXmlDto.getExtendLayout() != null) {
            if (!LayoutFactory.getAvailableLayouts().containsKey(layoutXmlDto.getExtendLayout())) {
                throw new IOException("Unable to find referenced layout ID '" + layoutXmlDto.getExtendLayout() + "'");
            }
            try {
                parentLayout = (FixedColumnsLayout)LayoutFactory.getLayout(layoutXmlDto.getExtendLayout());
            }
            catch (ClassCastException e) {
                throw new IOException("A fixed-columns layout must extend another fixed-columns layout");
            }
            this._parentLayoutId = parentLayout.getLayoutId();
        }
        this._fields.clear();
        if (layoutXmlDto.getField() != null) {
            for (FixedColumnLayoutFieldXmlDto fieldXmlDto : layoutXmlDto.getField()) {
                this.addField(this.createFieldFromXmlField(fieldXmlDto, useDeprecatedFieldNames));
            }
        }
        if (parentLayout != null) {
            for (FixedColumnsField field : parentLayout.getAllFields()) {
                if (this._cachedByName.containsKey(field.getName())) continue;
                this.addField(field);
            }
        }
        this._fields.sort(Comparator.comparing(FixedColumnsField::getStart));
        try {
            this.verify();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    protected String getDeprecatedFieldName(String name) {
        return name;
    }

    protected FixedColumnsField createFieldFromXmlField(FixedColumnLayoutFieldXmlDto dto, boolean useDeprecatedFieldNames) throws IOException {
        FixedColumnsField field = new FixedColumnsField();
        field.setName(useDeprecatedFieldNames ? this.getDeprecatedFieldName(dto.getName()) : dto.getName());
        field.setLongLabel(dto.getLongLabel());
        field.setShortLabel(dto.getShortLabel() != null ? dto.getShortLabel() : dto.getLongLabel());
        field.setNaaccrItemNum(dto.getNaaccrItemNum());
        if (dto.getStart() == null) {
            throw new IOException("Start column is required");
        }
        field.setStart(dto.getStart());
        if (dto.getEnd() == null) {
            throw new IOException("End column is required");
        }
        field.setEnd(dto.getEnd());
        field.setLength(dto.getEnd() - dto.getStart() + 1);
        if (dto.getStart() > dto.getEnd()) {
            throw new IOException("Field " + field.getName() + " defines a end column that is greater than its start column");
        }
        if (dto.getAlign() != null) {
            try {
                field.setAlign(Field.FieldAlignment.fromValue(dto.getAlign()));
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Field " + field.getName() + " defines an invalid align option: " + dto.getAlign());
            }
        } else {
            field.setAlign(Field.FieldAlignment.LEFT);
        }
        field.setPadChar(dto.getPadChar() == null ? " " : dto.getPadChar());
        field.setDefaultValue(dto.getDefaultValue());
        field.setTrim(dto.getTrim() == null ? Boolean.TRUE : dto.getTrim());
        if (dto.getField() != null && !dto.getField().isEmpty()) {
            ArrayList<FixedColumnsField> subFields = new ArrayList<FixedColumnsField>();
            for (FixedColumnLayoutFieldXmlDto childDto : dto.getField()) {
                subFields.add(this.createFieldFromXmlField(childDto, useDeprecatedFieldNames));
            }
            field.setSubFields(subFields);
        }
        field.setSection(dto.getSection());
        return field;
    }

    private void addField(FixedColumnsField field) {
        this._fields.add(field);
        this._cachedByName.put(field.getName(), field);
        if (field.getSubFields() != null) {
            for (FixedColumnsField f : field.getSubFields()) {
                this._cachedByName.put(f.getName(), f);
            }
        }
        if (field.getNaaccrItemNum() != null) {
            this._cachedByNaaccrItemNumber.put(field.getNaaccrItemNum(), field);
        }
        if (field.getSubFields() != null) {
            for (FixedColumnsField f : field.getSubFields()) {
                if (f.getNaaccrItemNum() == null) continue;
                this._cachedByNaaccrItemNumber.put(f.getNaaccrItemNum(), f);
            }
        }
    }

    public void setFields(Collection<FixedColumnsField> fields) {
        this._fields.clear();
        fields.forEach(this::addField);
        this._fields.sort(Comparator.comparing(FixedColumnsField::getStart));
        this.verify();
    }

    public Integer getLayoutLineLength() {
        return this._layoutLineLength;
    }

    public void setLayoutLineLength(Integer lineLength) {
        this._layoutLineLength = lineLength;
    }

    @Override
    public FixedColumnsField getFieldByName(String name) {
        return this._cachedByName.get(name);
    }

    @Override
    public FixedColumnsField getFieldByNaaccrItemNumber(Integer num) {
        return this._cachedByNaaccrItemNumber.get(num);
    }

    public List<FixedColumnsField> getAllFields() {
        return Collections.unmodifiableList(this._fields);
    }

    @Override
    public String validateLine(String line, Integer lineNumber) {
        if (this._parentLayoutId != null) {
            return ((FixedColumnsLayout)LayoutFactory.getLayout(this._parentLayoutId)).validateLine(line, lineNumber);
        }
        StringBuilder msg = new StringBuilder();
        if (line == null || line.isEmpty()) {
            msg.append("line ").append(lineNumber).append(": line is empty");
        } else if (line.length() != this._layoutLineLength.intValue()) {
            msg.append("line ").append(lineNumber).append(": wrong length, expected ").append(this._layoutLineLength).append(" but got ").append(line.length());
        }
        return msg.length() == 0 ? null : msg.toString();
    }

    @Override
    public String createLineFromRecord(Map<String, String> record, RecordLayoutOptions options) throws IOException {
        StringBuilder result = new StringBuilder();
        if (record == null) {
            record = new HashMap<String, String>();
        }
        int currentIndex = 1;
        for (FixedColumnsField field : this._fields) {
            int start = field.getStart();
            int end = field.getEnd();
            if (start > currentIndex) {
                for (int i = 0; i < start - currentIndex; ++i) {
                    result.append(' ');
                }
            }
            currentIndex = start;
            if (field.getSubFields() != null && !field.getSubFields().isEmpty()) {
                for (FixedColumnsField child : field.getSubFields()) {
                    int subStart = child.getStart();
                    int subEnd = child.getEnd();
                    if (subStart > currentIndex) {
                        for (int i = 0; i < subStart - currentIndex; ++i) {
                            result.append(' ');
                        }
                    }
                    currentIndex = subStart;
                    if (subEnd > end) continue;
                    String value = record.get(child.getName());
                    if (value == null) {
                        value = child.getDefaultValue() != null ? child.getDefaultValue() : "";
                    }
                    int length = subEnd - subStart + 1;
                    if (value.length() > length) {
                        if (options != null && "nullify".equals(options.getValueTooLongHandling())) {
                            value = "";
                        } else if (options != null && "cutoff".equals(options.getValueTooLongHandling())) {
                            value = value.substring(0, length);
                        } else {
                            throw new IOException("value too long for field '" + field.getName() + "'");
                        }
                    }
                    String paddingChar = !value.isEmpty() && this.applyPadding(options) ? child.getPadChar() : " ";
                    value = this.applyAlignment(options) && child.getAlign() == Field.FieldAlignment.RIGHT ? LayoutUtils.pad(value, length, paddingChar, true) : LayoutUtils.pad(value, length, paddingChar, false);
                    result.append(this.cleanValue(value, child));
                    currentIndex = subEnd + 1;
                }
                if (currentIndex <= end) {
                    for (int i = 0; i < end - currentIndex + 1; ++i) {
                        result.append(' ');
                    }
                }
                currentIndex = end + 1;
                continue;
            }
            if (end > this._layoutLineLength) continue;
            String value = record.get(field.getName());
            if (value == null) {
                value = field.getDefaultValue() != null ? field.getDefaultValue() : "";
            }
            int length = end - start + 1;
            if (value.length() > length) {
                if (options != null && "nullify".equals(options.getValueTooLongHandling())) {
                    value = "";
                } else if (options != null && "cutoff".equals(options.getValueTooLongHandling())) {
                    value = value.substring(0, length);
                } else {
                    throw new IOException("value too long for field '" + field.getName() + "'");
                }
            }
            String paddingChar = !value.isEmpty() && this.applyPadding(options) ? field.getPadChar() : " ";
            value = this.applyAlignment(options) && field.getAlign() == Field.FieldAlignment.RIGHT ? LayoutUtils.pad(value, length, paddingChar, true) : LayoutUtils.pad(value, length, paddingChar, false);
            result.append(this.cleanValue(value, field));
            currentIndex = end + 1;
        }
        if (currentIndex <= this._layoutLineLength) {
            for (int i = 0; i < this._layoutLineLength - currentIndex + 1; ++i) {
                result.append(' ');
            }
        }
        return result.toString();
    }

    protected String cleanValue(String value, Field field) {
        if (this._parentLayoutId != null) {
            return ((FixedColumnsLayout)LayoutFactory.getLayout(this._parentLayoutId)).cleanValue(value, field);
        }
        return value;
    }

    @Override
    public Map<String, String> createRecordFromLine(String line, Integer lineNumber, RecordLayoutOptions options) throws IOException {
        String validationMsg;
        Integer lineNumberSafe;
        HashMap<String, String> result = new HashMap<String, String>();
        Integer n = lineNumberSafe = lineNumber == null ? Integer.valueOf(1) : lineNumber;
        if (line == null || line.isEmpty()) {
            if (this.enforceStrictFormat(options)) {
                throw new IOException("line " + lineNumberSafe + ": got en empty line");
            }
            return result;
        }
        if (this.enforceStrictFormat(options) && (validationMsg = this.validateLine(line, lineNumberSafe)) != null) {
            throw new IOException(validationMsg);
        }
        for (FixedColumnsField field : this._fields) {
            int start = field.getStart();
            int end = field.getEnd();
            if (end > line.length()) break;
            String value = new String(line.substring(start - 1, end));
            boolean childPreventsTrimming = false;
            if (field.getSubFields() != null) {
                childPreventsTrimming = field.getSubFields().stream().anyMatch(subField -> subField.getTrim() == false);
            }
            String trimmedValue = value.trim();
            if (this.trimValues(options) && (field.getTrim().booleanValue() || trimmedValue.isEmpty() && !childPreventsTrimming) && (field.getSubFields() == null || trimmedValue.isEmpty())) {
                value = trimmedValue;
            }
            if (value.isEmpty()) continue;
            result.put(field.getName(), value);
            if (field.getSubFields() == null) continue;
            for (FixedColumnsField child : field.getSubFields()) {
                start = child.getStart();
                end = child.getEnd();
                value = new String(line.substring(start - 1, end));
                if (this.trimValues(options) && Boolean.TRUE.equals(child.getTrim())) {
                    value = value.trim();
                }
                if (value.isEmpty()) continue;
                result.put(child.getName(), value);
            }
        }
        return result;
    }

    @Override
    public LayoutInfo buildFileInfo(String firstRecord, LayoutInfoDiscoveryOptions options) {
        LayoutInfo result = null;
        if (firstRecord != null && options.isFixedColumnAllowDiscoveryFromLineLength() && firstRecord.length() == this._layoutLineLength.intValue()) {
            result = new LayoutInfo();
            result.setLayoutId(this.getLayoutId());
            result.setLayoutName(this.getLayoutName());
            result.setLineLength(this._layoutLineLength);
        }
        return result;
    }

    public void verify() {
        if (this._layoutId == null) {
            throw new IllegalStateException("Layout ID is required");
        }
        if (this._layoutName == null) {
            throw new IllegalStateException("Layout name is required");
        }
        if (this._layoutLineLength == null) {
            throw new IllegalStateException("Line length is required");
        }
        if (!this._fields.isEmpty()) {
            if (this._fields.get(0).getStart() <= 0) {
                throw new IllegalStateException("First field start column must be greater or equals to 1");
            }
            if (this._fields.get(this._fields.size() - 1).getEnd() > this._layoutLineLength) {
                throw new IllegalStateException("Last field end column must be smaller or equals to defined line length");
            }
            for (int i = 0; i < this._fields.size() - 1; ++i) {
                FixedColumnsField f1 = this._fields.get(i);
                if (f1.getStart() <= 0 || f1.getStart() > this._layoutLineLength) {
                    throw new IllegalStateException("Field " + f1.getName() + " start value is invalid, must be within 1-" + this._layoutLineLength + " but got " + f1.getStart());
                }
                if (f1.getEnd() <= 0 || f1.getEnd() > this._layoutLineLength) {
                    throw new IllegalStateException("Field " + f1.getName() + " end value is invalid, must be within 1-" + this._layoutLineLength + " but got " + f1.getStart());
                }
                FixedColumnsField f2 = this._fields.get(i + 1);
                if (f1.getEnd() >= f2.getStart()) {
                    throw new IllegalStateException("Fields " + f1.getName() + " and " + f2.getName() + " are overlapping");
                }
                if (f1.getSubFields() == null) continue;
                List<FixedColumnsField> list = f1.getSubFields();
                int size = list.size();
                for (int j = 0; j < size; ++j) {
                    FixedColumnsField ff = list.get(j);
                    if (j == 0 && ff.getStart() < f1.getStart()) {
                        throw new IllegalStateException("Field " + f1.getName() + " defines a sub-field that starts before it");
                    }
                    if (j == size - 1 && ff.getEnd() > f1.getEnd()) {
                        throw new IllegalStateException("Field " + f1.getName() + " defines a sub-field that ends after it");
                    }
                    if (j >= size - 1 || ff.getEnd() < list.get(j + 1).getStart()) continue;
                    throw new IllegalStateException("Field " + f1.getName() + " defines overlapping subfields");
                }
            }
            HashSet<String> names = new HashSet<String>();
            HashSet<String> naaccrItemNums = new HashSet<String>();
            for (FixedColumnsField field : this._fields) {
                if (field.getName() == null) {
                    throw new IllegalStateException("Field name is required");
                }
                if (names.contains(field.getName())) {
                    throw new IllegalStateException("Field name must be unique, found duplicate name for '" + field.getName() + "'");
                }
                names.add(field.getName());
                if (field.getNaaccrItemNum() != null) {
                    if (naaccrItemNums.contains(field.getNaaccrItemNum().toString())) {
                        throw new IllegalStateException("Field NAACCR item number must be unique, found duplicate number for '" + field.getNaaccrItemNum() + "'");
                    }
                    naaccrItemNums.add(field.getNaaccrItemNum().toString());
                }
                if (field.getSubFields() == null) continue;
                for (Field field2 : field.getSubFields()) {
                    if (field2.getName() == null) {
                        throw new IllegalStateException("Field name is required");
                    }
                    if (names.contains(field2.getName())) {
                        throw new IllegalStateException("Field name must be unique, found duplicate name for '" + field2.getName() + "'");
                    }
                    names.add(field2.getName());
                    if (field2.getNaaccrItemNum() == null) continue;
                    if (naaccrItemNums.contains(field2.getNaaccrItemNum().toString())) {
                        throw new IllegalStateException("Field NAACCR item number must be unique, found duplicate number for '" + field2.getNaaccrItemNum() + "'");
                    }
                    naaccrItemNums.add(field2.getNaaccrItemNum().toString());
                }
            }
        }
    }
}

