/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.layout.record;

import com.imsweb.layout.Layout;
import com.imsweb.layout.LayoutFactory;
import com.imsweb.layout.LayoutInfo;
import com.imsweb.layout.LayoutInfoDiscoveryOptions;
import com.imsweb.layout.LayoutUtils;
import com.imsweb.layout.record.RecordLayoutOptions;
import com.imsweb.layout.record.csv.CommaSeparatedLayout;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class RecordLayout
implements Layout {
    protected String _layoutId;
    protected String _layoutName;
    protected String _layoutVersion;
    protected String _layoutDesc;
    protected String _parentLayoutId;

    @Override
    public String getLayoutId() {
        return this._layoutId;
    }

    public void setLayoutId(String id) {
        this._layoutId = id;
    }

    @Override
    public String getLayoutName() {
        return this._layoutName;
    }

    public void setLayoutName(String name) {
        this._layoutName = name;
    }

    @Override
    public String getLayoutVersion() {
        return this._layoutVersion;
    }

    public void setLayoutVersion(String version) {
        this._layoutVersion = version;
    }

    @Override
    public String getLayoutDescription() {
        return this._layoutDesc;
    }

    public void setLayoutDescription(String description) {
        this._layoutDesc = description;
    }

    public void setLayoutNumberOfFields(Integer numFields) {
        throw new IllegalStateException("Number of fields is not supported for this layout");
    }

    public String getParentLayoutId() {
        return this._parentLayoutId;
    }

    public void setParentLayoutId(String parentLayoutId) {
        this._parentLayoutId = parentLayoutId;
    }

    @Override
    public String getFieldDocByName(String name) {
        if (this._parentLayoutId != null) {
            return LayoutFactory.getLayout(this._parentLayoutId).getFieldDocByName(name);
        }
        return null;
    }

    @Override
    public String getFieldDocByNaaccrItemNumber(Integer num) {
        if (this._parentLayoutId != null) {
            return LayoutFactory.getLayout(this._parentLayoutId).getFieldDocByNaaccrItemNumber(num);
        }
        return null;
    }

    @Override
    public String getFieldDocDefaultCssStyle() {
        if (this._parentLayoutId != null) {
            return LayoutFactory.getLayout(this._parentLayoutId).getFieldDocDefaultCssStyle();
        }
        return "";
    }

    protected boolean trimValues(RecordLayoutOptions options) {
        return options == null || options.trimValues();
    }

    protected boolean enforceStrictFormat(RecordLayoutOptions options) {
        return options != null && options.enforceStrictFormat();
    }

    protected boolean applyAlignment(RecordLayoutOptions options) {
        return options == null || options.applyAlignment();
    }

    protected boolean applyPadding(RecordLayoutOptions options) {
        return options == null || options.applyPadding();
    }

    protected String getLineSeparator(RecordLayoutOptions options) {
        return options == null ? System.lineSeparator() : options.getLineSeparator();
    }

    protected Charset getEncoding(RecordLayoutOptions options) {
        return options == null ? StandardCharsets.UTF_8 : options.getEncoding();
    }

    public void writeRecord(OutputStream outputStream, Map<String, String> rec) throws IOException {
        this.writeRecord(outputStream, rec, null);
    }

    public void writeRecord(OutputStream outputStream, Map<String, String> rec, RecordLayoutOptions options) throws IOException {
        outputStream.write(this.createLineFromRecord(rec, options).getBytes(this.getEncoding(options)));
        outputStream.write(this.getLineSeparator(options).getBytes(this.getEncoding(options)));
    }

    public void writeRecords(OutputStream outputStream, List<Map<String, String>> records) throws IOException {
        this.writeRecords(outputStream, records, null);
    }

    public void writeRecords(OutputStream outputStream, List<Map<String, String>> records, RecordLayoutOptions options) throws IOException {
        for (Map<String, String> rec : records) {
            outputStream.write(this.createLineFromRecord(rec, options).getBytes(this.getEncoding(options)));
            outputStream.write(this.getLineSeparator(options).getBytes(this.getEncoding(options)));
        }
    }

    public void writeRecord(Writer writer, Map<String, String> rec) throws IOException {
        this.writeRecord(writer, rec, null);
    }

    public void writeRecord(Writer writer, Map<String, String> rec, RecordLayoutOptions options) throws IOException {
        writer.write(this.createLineFromRecord(rec, options));
        writer.write(this.getLineSeparator(options));
    }

    public void writeRecords(Writer writer, List<Map<String, String>> records) throws IOException {
        this.writeRecords(writer, records, null);
    }

    public void writeRecords(Writer writer, List<Map<String, String>> records, RecordLayoutOptions options) throws IOException {
        for (Map<String, String> rec : records) {
            writer.write(this.createLineFromRecord(rec, options));
            writer.write(this.getLineSeparator(options));
        }
    }

    public void writeRecord(File file, Map<String, String> rec) throws IOException {
        this.writeRecords(file, Collections.singletonList(rec));
    }

    public void writeRecord(File file, Map<String, String> rec, RecordLayoutOptions options) throws IOException {
        this.writeRecords(file, Collections.singletonList(rec), options);
    }

    public void writeRecords(File file, List<Map<String, String>> records) throws IOException {
        this.writeRecords(file, records, null);
    }

    public void writeRecords(File file, List<Map<String, String>> records, RecordLayoutOptions options) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(LayoutUtils.createOutputStream(file));){
            for (Map<String, String> rec : records) {
                out.write(this.createLineFromRecord(rec, options).getBytes(this.getEncoding(options)));
                out.write(this.getLineSeparator(options).getBytes(this.getEncoding(options)));
            }
        }
    }

    public Map<String, String> readNextRecord(LineNumberReader lineReader) throws IOException {
        return this.readNextRecord(lineReader, null);
    }

    public Map<String, String> readNextRecord(LineNumberReader lineReader, RecordLayoutOptions options) throws IOException {
        String line = lineReader.readLine();
        if (line == null) {
            return null;
        }
        return this.createRecordFromLine(line, lineReader.getLineNumber(), options);
    }

    public List<Map<String, String>> readAllRecords(InputStream inputStream, RecordLayoutOptions options) throws IOException {
        String line;
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        LineNumberReader r = new LineNumberReader(new InputStreamReader(inputStream, this.getEncoding(options)));
        while ((line = r.readLine()) != null) {
            result.add(this.createRecordFromLine(line, r.getLineNumber(), options));
        }
        return result;
    }

    public List<Map<String, String>> readAllRecords(Reader reader) throws IOException {
        return this.readAllRecords(reader, null);
    }

    public List<Map<String, String>> readAllRecords(Reader reader, RecordLayoutOptions options) throws IOException {
        String line;
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        LineNumberReader r = new LineNumberReader(reader);
        while ((line = r.readLine()) != null) {
            result.add(this.createRecordFromLine(line, r.getLineNumber(), options));
        }
        return result;
    }

    public List<Map<String, String>> readAllRecords(File file) throws IOException {
        return this.readAllRecords(file, null, null);
    }

    public List<Map<String, String>> readAllRecords(File file, RecordLayoutOptions options) throws IOException {
        return this.readAllRecords(file, null, options);
    }

    public List<Map<String, String>> readAllRecords(File file, String zipEntry, RecordLayoutOptions options) throws IOException {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        try (LineNumberReader r = new LineNumberReader(new InputStreamReader(LayoutUtils.createInputStream(file, zipEntry), this.getEncoding(options)));){
            String line;
            if (this instanceof CommaSeparatedLayout && ((CommaSeparatedLayout)this).ignoreFirstLine()) {
                r.readLine();
            }
            while ((line = r.readLine()) != null) {
                result.add(this.createRecordFromLine(line, r.getLineNumber(), options));
            }
        }
        return result;
    }

    public abstract String validateLine(String var1, Integer var2);

    public abstract Map<String, String> createRecordFromLine(String var1, Integer var2, RecordLayoutOptions var3) throws IOException;

    public abstract String createLineFromRecord(Map<String, String> var1, RecordLayoutOptions var2) throws IOException;

    public abstract LayoutInfo buildFileInfo(String var1, LayoutInfoDiscoveryOptions var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LayoutInfo buildFileInfo(File file, String zipEntryName, LayoutInfoDiscoveryOptions options) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(LayoutUtils.createInputStream(file, zipEntryName), this.getEncoding(null)));){
            String firstLine = reader.readLine();
            if (firstLine == null) {
                LayoutInfo layoutInfo = null;
                return layoutInfo;
            }
            LayoutInfo layoutInfo = this.buildFileInfo(firstLine, options);
            return layoutInfo;
        }
        catch (IOException e) {
            return null;
        }
    }
}

