/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.layout.record.csv;

import com.imsweb.layout.LayoutFactory;
import com.imsweb.layout.LayoutInfo;
import com.imsweb.layout.LayoutInfoDiscoveryOptions;
import com.imsweb.layout.LayoutUtils;
import com.imsweb.layout.record.RecordLayout;
import com.imsweb.layout.record.RecordLayoutOptions;
import com.imsweb.layout.record.csv.CommaSeparatedField;
import com.imsweb.layout.record.csv.xml.CommaSeparatedLayoutFieldXmlDto;
import com.imsweb.layout.record.csv.xml.CommaSeparatedLayoutXmlDto;
import com.opencsv.AbstractCSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.RFC4180ParserBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CommaSeparatedLayout
extends RecordLayout {
    protected Integer _numFields;
    protected char _separator = (char)44;
    protected boolean _ignoreFirstLine = true;
    protected boolean _useLegacyCsvParser = false;
    protected List<CommaSeparatedField> _fields = new ArrayList<CommaSeparatedField>();
    protected Map<String, CommaSeparatedField> _cachedByName = new HashMap<String, CommaSeparatedField>();
    protected Map<Integer, CommaSeparatedField> _cachedByNaaccrItemNumber = new HashMap<Integer, CommaSeparatedField>();

    public CommaSeparatedLayout() {
    }

    public CommaSeparatedLayout(URL layoutUrl) throws IOException {
        this();
        if (layoutUrl == null) {
            throw new NullPointerException("Unable to create layout from null URL");
        }
        try (InputStream is = layoutUrl.openStream();){
            this.init(LayoutUtils.readCommaSeparatedLayout(is));
        }
    }

    public CommaSeparatedLayout(File layoutFile) throws IOException {
        this();
        if (layoutFile == null) {
            throw new NullPointerException("Unable to create layout from null file");
        }
        if (!layoutFile.exists()) {
            throw new IOException("Unable to read from " + layoutFile.getPath());
        }
        try (InputStream is = Files.newInputStream(layoutFile.toPath(), new OpenOption[0]);){
            this.init(LayoutUtils.readCommaSeparatedLayout(is));
        }
    }

    public CommaSeparatedLayout(CommaSeparatedLayoutXmlDto layoutXmlDto) throws IOException {
        this();
        if (layoutXmlDto == null) {
            throw new NullPointerException("Unable to create layout from null XML object");
        }
        this.init(layoutXmlDto);
    }

    protected void init(CommaSeparatedLayoutXmlDto layoutXmlDto) throws IOException {
        this._layoutId = layoutXmlDto.getId();
        this._layoutName = layoutXmlDto.getName();
        this._layoutVersion = layoutXmlDto.getVersion();
        this._layoutDesc = layoutXmlDto.getDescription();
        this._numFields = layoutXmlDto.getNumFields();
        this._separator = (char)(layoutXmlDto.getSeparator() == null ? 44 : (int)layoutXmlDto.getSeparator().charAt(0));
        this._ignoreFirstLine = layoutXmlDto.getIgnoreFirstLine() == null || layoutXmlDto.getIgnoreFirstLine() != false;
        CommaSeparatedLayout parentLayout = null;
        if (layoutXmlDto.getExtendLayout() != null) {
            if (!LayoutFactory.getAvailableLayouts().containsKey(layoutXmlDto.getExtendLayout())) {
                throw new IOException("Unable to find referenced layout ID '" + layoutXmlDto.getExtendLayout() + "'");
            }
            try {
                parentLayout = (CommaSeparatedLayout)LayoutFactory.getLayout(layoutXmlDto.getExtendLayout());
            }
            catch (ClassCastException e) {
                throw new IOException("A CSV layout must extend another CSV layout");
            }
            this._parentLayoutId = parentLayout.getLayoutId();
        }
        this._fields.clear();
        if (layoutXmlDto.getField() != null) {
            for (CommaSeparatedLayoutFieldXmlDto fieldXmlDto : layoutXmlDto.getField()) {
                this.addField(this.createFieldFromXmlField(fieldXmlDto));
            }
        }
        if (parentLayout != null) {
            parentLayout.getAllFields().stream().filter(field -> !this._cachedByName.containsKey(field.getName())).forEach(this::addField);
        }
        this._fields.sort(Comparator.comparing(CommaSeparatedField::getIndex));
        try {
            this.verify();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    protected CommaSeparatedField createFieldFromXmlField(CommaSeparatedLayoutFieldXmlDto dto) {
        CommaSeparatedField field = new CommaSeparatedField();
        field.setName(dto.getName());
        field.setLongLabel(dto.getLongLabel());
        field.setShortLabel(dto.getShortLabel() != null ? dto.getShortLabel() : dto.getLongLabel());
        field.setNaaccrItemNum(dto.getNaaccrItemNum());
        field.setIndex(dto.getIndex());
        field.setLength(dto.getMaxLength());
        field.setDefaultValue(dto.getDefaultValue());
        field.setTrim(dto.getTrim() == null ? Boolean.TRUE : dto.getTrim());
        return field;
    }

    private void addField(CommaSeparatedField field) {
        this._fields.add(field);
        this._cachedByName.put(field.getName(), field);
        if (field.getNaaccrItemNum() != null) {
            this._cachedByNaaccrItemNumber.put(field.getNaaccrItemNum(), field);
        }
    }

    public void setFields(Collection<CommaSeparatedField> fields) {
        this._fields.clear();
        fields.forEach(this::addField);
        this._fields.sort(Comparator.comparing(CommaSeparatedField::getIndex));
        this.verify();
    }

    public Integer getLayoutNumberOfFields() {
        return this._numFields;
    }

    @Override
    public void setLayoutNumberOfFields(Integer numFields) {
        this._numFields = numFields;
    }

    public char getSeparator() {
        return this._separator;
    }

    public void setSeparator(char separator) {
        this._separator = separator;
    }

    public boolean ignoreFirstLine() {
        return this._ignoreFirstLine;
    }

    public void setIgnoreFirstLine(boolean ignoreFirstLine) {
        this._ignoreFirstLine = ignoreFirstLine;
    }

    public void setUseLegacyCsvParser(boolean useLegacyCsvParser) {
        this._useLegacyCsvParser = useLegacyCsvParser;
    }

    @Override
    public CommaSeparatedField getFieldByName(String name) {
        return this._cachedByName.get(name);
    }

    @Override
    public CommaSeparatedField getFieldByNaaccrItemNumber(Integer num) {
        return this._cachedByNaaccrItemNumber.get(num);
    }

    public List<CommaSeparatedField> getAllFields() {
        return Collections.unmodifiableList(this._fields);
    }

    @Override
    public String validateLine(String line, Integer lineNumber) {
        StringBuilder msg = new StringBuilder();
        if (line == null || line.isEmpty()) {
            msg.append("line ").append(lineNumber).append(": line is empty");
        } else {
            try {
                int numFields = this.createParser().parseLine(line).length;
                if (numFields != this._numFields) {
                    msg.append("line ").append(lineNumber).append(": wrong number of fields, expected ").append(this._numFields).append(" but got ").append(numFields);
                }
            }
            catch (IOException e) {
                msg.append("line ").append(lineNumber).append(": unable to parse line");
            }
        }
        return msg.length() == 0 ? null : msg.toString();
    }

    @Override
    public String createLineFromRecord(Map<String, String> rec, RecordLayoutOptions options) throws IOException {
        StringBuilder result = new StringBuilder();
        if (rec == null) {
            rec = new HashMap<String, String>();
        }
        String[] values = new String[this._numFields.intValue()];
        for (CommaSeparatedField field : this._fields) {
            String val = rec.get(field.getName());
            if (val == null && field.getDefaultValue() != null) {
                val = field.getDefaultValue();
            }
            values[field.getIndex().intValue() - 1] = val;
        }
        boolean forceQuotes = options != null && options.quoteAllValues();
        for (String val : values) {
            if (val != null) {
                if (forceQuotes || val.indexOf(this._separator) > -1 || val.indexOf(10) > -1 || val.indexOf(34) > -1) {
                    result.append("\"").append(StringUtils.replace((String)val, (String)"\"", (String)"\"\"")).append("\"");
                } else {
                    result.append(val);
                }
            }
            result.append(this._separator);
        }
        if (result.length() > 1) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    @Override
    public Map<String, String> createRecordFromLine(String line, Integer lineNumber, RecordLayoutOptions options) throws IOException {
        String validationMsg;
        Integer lineNumberSafe;
        HashMap<String, String> result = new HashMap<String, String>();
        Integer n = lineNumberSafe = lineNumber == null ? Integer.valueOf(1) : lineNumber;
        if (line == null || line.isEmpty()) {
            if (this.enforceStrictFormat(options)) {
                throw new IOException("line " + lineNumberSafe + ": got en empty line");
            }
            return result;
        }
        if (this.enforceStrictFormat(options) && (validationMsg = this.validateLine(line, lineNumberSafe)) != null) {
            throw new IOException(validationMsg);
        }
        try {
            CommaSeparatedField field;
            int index;
            String[] values = this.createParser().parseLine(line);
            Iterator<CommaSeparatedField> iterator = this._fields.iterator();
            while (iterator.hasNext() && (index = (field = iterator.next()).getIndex() - 1) < values.length) {
                String value = values[index];
                String trimmedValue = value.trim();
                if (this.trimValues(options) && Boolean.TRUE.equals(field.getTrim())) {
                    value = trimmedValue;
                }
                if (value.isEmpty()) continue;
                result.put(field.getName(), value);
            }
            return result;
        }
        catch (IOException e) {
            throw new IOException("Line " + (lineNumber == null ? "?" : lineNumber) + ": " + e.getMessage());
        }
    }

    @Override
    public LayoutInfo buildFileInfo(String firstRecord, LayoutInfoDiscoveryOptions options) {
        LayoutInfo result = null;
        if (firstRecord != null && options.isCommaSeparatedAllowDiscoveryFromNumFields()) {
            try {
                if (this.createParser().parseLine(firstRecord).length == this._numFields) {
                    result = new LayoutInfo();
                    result.setLayoutId(this.getLayoutId());
                    result.setLayoutName(this.getLayoutName());
                    result.setNumFields(this.getLayoutNumberOfFields());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    protected AbstractCSVParser createParser() {
        if (this._useLegacyCsvParser) {
            return new CSVParserBuilder().withSeparator(this._separator).withEscapeChar('\u0000').build();
        }
        return new RFC4180ParserBuilder().withSeparator(this._separator).build();
    }

    public void verify() {
        if (this._layoutId == null) {
            throw new IllegalStateException("Layout ID is required");
        }
        if (this._layoutName == null) {
            throw new IllegalStateException("Layout name is required");
        }
        if (this._numFields == null) {
            throw new IllegalStateException("Number of fields is required");
        }
        if (this._separator == '\u0000') {
            throw new IllegalStateException("Separator is required");
        }
        if (!this._fields.isEmpty()) {
            HashSet<String> names = new HashSet<String>();
            HashSet<String> naaccrItemNums = new HashSet<String>();
            HashSet<Integer> indexes = new HashSet<Integer>();
            for (CommaSeparatedField field : this._fields) {
                if (field.getName() == null) {
                    throw new IllegalStateException("Field name is required");
                }
                if (names.contains(field.getName())) {
                    throw new IllegalStateException("Field name must be unique, found duplicate name for '" + field.getName() + "'");
                }
                names.add(field.getName());
                if (field.getNaaccrItemNum() != null) {
                    if (naaccrItemNums.contains(field.getNaaccrItemNum().toString())) {
                        throw new IllegalStateException("Field NAACCR item number must be unique, found duplicate number for '" + field.getNaaccrItemNum() + "'");
                    }
                    naaccrItemNums.add(field.getNaaccrItemNum().toString());
                }
                if (field.getIndex() == null) {
                    throw new IllegalStateException("Field index is required");
                }
                if (field.getIndex() <= 0) {
                    throw new IllegalStateException("Field index must be greater than zero");
                }
                if (field.getIndex() > this._numFields) {
                    throw new IllegalStateException("Field index must be smaller or equal to the defined number of fields");
                }
                if (indexes.contains(field.getIndex())) {
                    throw new IllegalStateException("Field index must be unique");
                }
                indexes.add(field.getIndex());
            }
        }
    }
}

