/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.layout;

import com.imsweb.layout.Layout;
import com.imsweb.layout.hl7.NaaccrHl7Layout;
import com.imsweb.layout.hl7.xml.Hl7LayoutXmlDto;
import com.imsweb.layout.record.csv.CommaSeparatedLayout;
import com.imsweb.layout.record.csv.xml.CommaSeparatedLayoutXmlDto;
import com.imsweb.layout.record.fixed.FixedColumnsLayout;
import com.imsweb.layout.record.fixed.xml.FixedColumnLayoutXmlDto;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.BooleanConverter;
import com.thoughtworks.xstream.converters.basic.ByteConverter;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import com.thoughtworks.xstream.converters.basic.DoubleConverter;
import com.thoughtworks.xstream.converters.basic.FloatConverter;
import com.thoughtworks.xstream.converters.basic.IntConverter;
import com.thoughtworks.xstream.converters.basic.LongConverter;
import com.thoughtworks.xstream.converters.basic.NullConverter;
import com.thoughtworks.xstream.converters.basic.ShortConverter;
import com.thoughtworks.xstream.converters.basic.StringConverter;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public final class LayoutUtils {
    private static final int _ZIP_THRESHOLD_ENTRIES = 10000;
    private static final int _ZIP_THRESHOLD_RATIO = 10;

    private LayoutUtils() {
    }

    public static Layout readLayout(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IOException("Unable to read layout, target input stream is null");
        }
        try {
            XStream xstream = LayoutUtils.createXStream();
            xstream.alias("comma-separated-layout", CommaSeparatedLayoutXmlDto.class);
            xstream.alias("fixed-column-layout", FixedColumnLayoutXmlDto.class);
            xstream.alias("hl7-layout", Hl7LayoutXmlDto.class);
            Object layoutDto = xstream.fromXML(stream);
            if (layoutDto instanceof FixedColumnLayoutXmlDto) {
                return new FixedColumnsLayout((FixedColumnLayoutXmlDto)layoutDto);
            }
            if (layoutDto instanceof CommaSeparatedLayoutXmlDto) {
                return new CommaSeparatedLayout((CommaSeparatedLayoutXmlDto)layoutDto);
            }
            if (layoutDto instanceof Hl7LayoutXmlDto) {
                return new NaaccrHl7Layout((Hl7LayoutXmlDto)layoutDto);
            }
            throw new IOException("Cannot identify layout type.");
        }
        catch (RuntimeException e) {
            throw new IOException("Unable to read XML layout: " + e.getMessage(), e);
        }
    }

    public static XStream createFixedColumnsXStream() {
        XStream xstream = LayoutUtils.createXStream();
        xstream.alias("fixed-column-layout", FixedColumnLayoutXmlDto.class);
        return xstream;
    }

    public static FixedColumnLayoutXmlDto readFixedColumnsLayout(InputStream stream) throws IOException {
        FixedColumnLayoutXmlDto fixedColumnLayoutXmlDto;
        block9: {
            if (stream == null) {
                throw new IOException("Unable to read layout, target input stream is null");
            }
            InputStream is = stream;
            try {
                fixedColumnLayoutXmlDto = (FixedColumnLayoutXmlDto)LayoutUtils.createFixedColumnsXStream().fromXML(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new IOException("Unable to read XML layout: " + e.getMessage(), e);
                }
            }
            is.close();
        }
        return fixedColumnLayoutXmlDto;
    }

    public static void writeFixedColumnsLayout(OutputStream stream, FixedColumnLayoutXmlDto layout) throws IOException {
        if (layout == null) {
            throw new IOException("Unable to write NULL layout");
        }
        if (stream == null) {
            throw new IOException("Unable to write layout for '" + layout.getId() + "', target output stream is null");
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);){
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.write(System.lineSeparator());
            LayoutUtils.createFixedColumnsXStream().toXML((Object)layout, (Writer)writer);
        }
        catch (RuntimeException e) {
            throw new IOException("Unable to write XML layout: " + e.getMessage(), e);
        }
    }

    public static XStream createCommaSeparatedXStream() {
        XStream xstream = LayoutUtils.createXStream();
        xstream.alias("comma-separated-layout", CommaSeparatedLayoutXmlDto.class);
        return xstream;
    }

    public static CommaSeparatedLayoutXmlDto readCommaSeparatedLayout(InputStream stream) throws IOException {
        CommaSeparatedLayoutXmlDto commaSeparatedLayoutXmlDto;
        block9: {
            if (stream == null) {
                throw new IOException("Unable to read layout, target input stream is null");
            }
            InputStream is = stream;
            try {
                commaSeparatedLayoutXmlDto = (CommaSeparatedLayoutXmlDto)LayoutUtils.createCommaSeparatedXStream().fromXML(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new IOException("Unable to read XML layout: " + e.getMessage(), e);
                }
            }
            is.close();
        }
        return commaSeparatedLayoutXmlDto;
    }

    public static void writeCommaSeparatedLayout(OutputStream stream, CommaSeparatedLayoutXmlDto layout) throws IOException {
        if (layout == null) {
            throw new IOException("Unable to write NULL layout");
        }
        if (stream == null) {
            throw new IOException("Unable to write layout for '" + layout.getId() + "', target output stream is null");
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);){
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.write(System.lineSeparator());
            LayoutUtils.createCommaSeparatedXStream().toXML((Object)layout, (Writer)writer);
        }
        catch (RuntimeException e) {
            throw new IOException("Unable to write XML layout: " + e.getMessage(), e);
        }
    }

    public static XStream createHl7XStream() {
        XStream xstream = LayoutUtils.createXStream();
        xstream.alias("hl7-layout", Hl7LayoutXmlDto.class);
        return xstream;
    }

    public static Hl7LayoutXmlDto readHl7Layout(InputStream stream) throws IOException {
        Hl7LayoutXmlDto hl7LayoutXmlDto;
        block9: {
            if (stream == null) {
                throw new IOException("Unable to read layout, target input stream is null");
            }
            InputStream is = stream;
            try {
                hl7LayoutXmlDto = (Hl7LayoutXmlDto)LayoutUtils.createHl7XStream().fromXML(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new IOException("Unable to read XML layout: " + e.getMessage(), e);
                }
            }
            is.close();
        }
        return hl7LayoutXmlDto;
    }

    public static void writeHl7Layout(OutputStream stream, Hl7LayoutXmlDto layout) throws IOException {
        if (layout == null) {
            throw new IOException("Unable to write NULL layout");
        }
        if (stream == null) {
            throw new IOException("Unable to write layout for '" + layout.getId() + "', target output stream is null");
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);){
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.write(System.lineSeparator());
            LayoutUtils.createHl7XStream().toXML((Object)layout, (Writer)writer);
        }
        catch (RuntimeException e) {
            throw new IOException("Unable to write XML layout: " + e.getMessage(), e);
        }
    }

    public static XStream createXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver(){

            public HierarchicalStreamWriter createWriter(Writer out) {
                return new PrettyPrintWriter(out, "    ");
            }
        }){

            protected void setupConverters() {
                this.registerConverter((Converter)new NullConverter(), 10000);
                this.registerConverter((SingleValueConverter)new IntConverter(), 0);
                this.registerConverter((SingleValueConverter)new FloatConverter(), 0);
                this.registerConverter((SingleValueConverter)new DoubleConverter(), 0);
                this.registerConverter((SingleValueConverter)new LongConverter(), 0);
                this.registerConverter((SingleValueConverter)new ShortConverter(), 0);
                this.registerConverter((SingleValueConverter)new BooleanConverter(), 0);
                this.registerConverter((SingleValueConverter)new ByteConverter(), 0);
                this.registerConverter((SingleValueConverter)new StringConverter(), 0);
                this.registerConverter((SingleValueConverter)new DateConverter(), 0);
                this.registerConverter((Converter)new CollectionConverter(this.getMapper()), 0);
                this.registerConverter((Converter)new ReflectionConverter(this.getMapper(), this.getReflectionProvider()), -20);
            }
        };
        xstream.autodetectAnnotations(true);
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission((TypePermission)new WildcardTypePermission(new String[]{"com.imsweb.layout.**"}));
        return xstream;
    }

    public static String getInternalNaaccrHl7Resource(String version) {
        return "layout/hl7/naaccr/naaccr-hl7-" + version + "-layout.xml";
    }

    public static InputStream createInputStream(File file) throws IOException {
        return LayoutUtils.createInputStream(file, null);
    }

    public static InputStream createInputStream(File file, String zipEntryToUse) throws IOException {
        InputStream is;
        if (file == null || !file.exists()) {
            throw new IOException("File does not exist.");
        }
        String name = file.getName().toLowerCase();
        if (name.endsWith(".gz") || name.endsWith(".gzip")) {
            is = new GZIPInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
        } else if (name.endsWith(".zip")) {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            ArrayList<String> list = new ArrayList<String>();
            while (entries.hasMoreElements()) {
                list.add(entries.nextElement().getName());
                if (list.size() <= 10000) continue;
                throw new IllegalStateException("Threshold of 10000 for maximum number of entries in ZIP file has been reached");
            }
            if (list.isEmpty()) {
                throw new IOException("Zip file is empty.");
            }
            if (list.size() == 1) {
                zipEntryToUse = (String)list.get(0);
            }
            if (!list.contains(zipEntryToUse)) {
                throw new IOException("Zip file contains more than one file.");
            }
            InputStream tmp = zipFile.getInputStream(zipFile.getEntry(zipEntryToUse));
            if (zipEntryToUse.endsWith(".gz") || zipEntryToUse.endsWith(".gzip")) {
                is = new GZIPInputStream(tmp);
            } else {
                if (zipEntryToUse.endsWith(".zip")) {
                    throw new IOException("Zip files inside zip files is not supported.");
                }
                is = tmp;
            }
        } else {
            is = Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        return is;
    }

    public static OutputStream createOutputStream(File file) throws IOException {
        String name = file.getName().toLowerCase();
        OutputStream os = name.endsWith(".gz") || name.endsWith(".gzip") ? new GZIPOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0])) : (name.endsWith(".zip") ? new ZipOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0])) : Files.newOutputStream(file.toPath(), new OpenOption[0]));
        return os;
    }

    public static String formatNumber(int num) {
        DecimalFormat format = new DecimalFormat();
        format.setDecimalSeparatorAlwaysShown(false);
        return format.format(num);
    }

    public static String formatFileSize(long size) {
        if (size < 1024L) {
            return size + " B";
        }
        if (size < 0x100000L) {
            return new DecimalFormat("#.# KB").format((double)size / 1024.0);
        }
        if (size < 0x40000000L) {
            return new DecimalFormat("#.# MB").format((double)size / 1024.0 / 1024.0);
        }
        return new DecimalFormat("#.# GB").format((double)size / 1024.0 / 1024.0 / 1024.0);
    }

    public static String formatTime(long timeInMilli) {
        long hourBasis = 60L;
        StringBuilder formattedTime = new StringBuilder();
        long secTmp = timeInMilli / 1000L;
        long sec = secTmp % hourBasis;
        long minTmp = secTmp / hourBasis;
        long min = minTmp % hourBasis;
        long hour = minTmp / hourBasis;
        if (hour > 0L) {
            formattedTime.append(hour).append(" hour");
            if (hour > 1L) {
                formattedTime.append("s");
            }
        }
        if (min > 0L) {
            if (formattedTime.length() > 0) {
                formattedTime.append(", ");
            }
            formattedTime.append(min).append(" minute");
            if (min > 1L) {
                formattedTime.append("s");
            }
        }
        if (sec > 0L) {
            if (formattedTime.length() > 0) {
                formattedTime.append(", ");
            }
            formattedTime.append(sec).append(" second");
            if (sec > 1L) {
                formattedTime.append("s");
            }
        }
        if (formattedTime.length() > 0) {
            return formattedTime.toString();
        }
        return "< 1 second";
    }

    public static String pad(String value, int length, String with, boolean leftPad) {
        if (value == null || value.length() >= length) {
            return value;
        }
        StringBuilder builder = new StringBuilder(value);
        while (builder.length() < length) {
            if (leftPad) {
                builder.insert(0, with);
                continue;
            }
            builder.append(with);
        }
        return builder.toString();
    }

    public static String readNaaccrDocumentationFromFile(String entryName, File archivedDocFile) {
        String result = null;
        if (archivedDocFile.isDirectory()) {
            File targetFile = new File(archivedDocFile, entryName);
            if (targetFile.exists()) {
                try (InputStream is2 = Files.newInputStream(targetFile.toPath(), new OpenOption[0]);){
                    StringWriter writer = new StringWriter();
                    IOUtils.copy((InputStream)is2, (Writer)writer, (Charset)StandardCharsets.UTF_8);
                    result = ((Object)writer).toString();
                }
                catch (IOException is2) {}
            }
        } else {
            try (ZipFile zf = new ZipFile(archivedDocFile);){
                ZipEntry entry = zf.getEntry(entryName);
                if (entry != null) {
                    StringWriter writer = new StringWriter();
                    IOUtils.copy((InputStream)zf.getInputStream(entry), (Writer)writer, (Charset)StandardCharsets.UTF_8);
                    result = ((Object)writer).toString();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String readNaaccrDocumentationFromZipInputStream(String entryName, ZipInputStream archivedDocStream) {
        String result;
        block9: {
            result = null;
            try {
                int entryCount = 0;
                ZipEntry entry = archivedDocStream.getNextEntry();
                while (entry != null && !entryName.equals(entry.getName())) {
                    entry = archivedDocStream.getNextEntry();
                    if (++entryCount <= 10000) continue;
                    throw new IllegalStateException("Threshold of 10000 for maximum number of entries in ZIP file has been reached");
                }
                if (entry == null) break block9;
                StringWriter writer = new StringWriter();
                try (InputStreamReader reader = new InputStreamReader((InputStream)archivedDocStream, StandardCharsets.UTF_8);){
                    int nBytes;
                    char[] buffer = new char[2048];
                    long totalSizeEntry = 0L;
                    while ((nBytes = reader.read(buffer)) > 0) {
                        ((Writer)writer).write(buffer, 0, nBytes);
                        long compressionRatio = (totalSizeEntry += (long)nBytes) / entry.getCompressedSize();
                        if (compressionRatio <= 10L) continue;
                        throw new IllegalStateException("Threshold of 10 for maximum compression ratio of ZIP entry has been reached");
                    }
                }
                result = ((Object)writer).toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }
}

