/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.layout.naaccrxml;

import com.imsweb.layout.Layout;
import com.imsweb.layout.LayoutInfo;
import com.imsweb.layout.LayoutInfoDiscoveryOptions;
import com.imsweb.layout.LayoutUtils;
import com.imsweb.layout.naaccrxml.NaaccrXmlField;
import com.imsweb.naaccrxml.NaaccrFormat;
import com.imsweb.naaccrxml.NaaccrIOException;
import com.imsweb.naaccrxml.NaaccrOptions;
import com.imsweb.naaccrxml.NaaccrXmlDictionaryUtils;
import com.imsweb.naaccrxml.NaaccrXmlUtils;
import com.imsweb.naaccrxml.PatientXmlReader;
import com.imsweb.naaccrxml.PatientXmlWriter;
import com.imsweb.naaccrxml.entity.NaaccrData;
import com.imsweb.naaccrxml.entity.Patient;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionary;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionaryItem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class NaaccrXmlLayout
implements Layout {
    private static final StringBuilder _CSS_STYLE = new StringBuilder();
    protected String _layoutId;
    protected String _layoutName;
    protected String _layoutDesc;
    protected String _naaccrVersion;
    private String _recordType;
    private NaaccrDictionary _baseDictionary;
    private List<NaaccrDictionary> _userDictionaries;
    private final List<NaaccrXmlField> _allFields = new ArrayList<NaaccrXmlField>();
    private final Map<String, NaaccrXmlField> _fieldsCachedByName = new HashMap<String, NaaccrXmlField>();
    private final Map<Integer, NaaccrXmlField> _fieldsCachedByNaaccrNumber = new HashMap<Integer, NaaccrXmlField>();

    public NaaccrXmlLayout() {
    }

    public NaaccrXmlLayout(String naaccrVersion, String recordType, String layoutId, String layoutName, String description, List<NaaccrDictionary> dictionaries, boolean loadFields) {
        this._naaccrVersion = naaccrVersion;
        this._layoutName = layoutName;
        this._layoutId = layoutId;
        this._recordType = recordType;
        this._baseDictionary = NaaccrXmlDictionaryUtils.getBaseDictionaryByVersion((String)naaccrVersion);
        this._userDictionaries = dictionaries;
        if (this._userDictionaries == null || this._userDictionaries.isEmpty()) {
            NaaccrDictionary defaultUserDictionary = NaaccrXmlDictionaryUtils.getDefaultUserDictionaryByVersion((String)naaccrVersion);
            this._userDictionaries = defaultUserDictionary != null ? Collections.singletonList(defaultUserDictionary) : Collections.emptyList();
        }
        this._layoutDesc = StringUtils.stripToNull((String)description);
        if (loadFields) {
            HashMap shortLabels = new HashMap();
            HashMap sections = new HashMap();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("layout/fixed/naaccr/items-extra-info.csv"), StandardCharsets.UTF_8));){
                in.lines().forEach(line -> {
                    String[] parts = StringUtils.split((String)line, (char)',');
                    if (parts.length == 3) {
                        shortLabels.put(parts[0], parts[1]);
                        sections.put(parts[0], parts[2]);
                    }
                });
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            for (NaaccrDictionaryItem item : NaaccrXmlDictionaryUtils.mergeDictionaries((NaaccrDictionary)this._baseDictionary, (NaaccrDictionary[])this._userDictionaries.toArray(new NaaccrDictionary[0])).getItems()) {
                if (item.getRecordTypes() != null && !item.getRecordTypes().isEmpty() && !item.getRecordTypes().contains(this._recordType)) continue;
                NaaccrXmlField field = new NaaccrXmlField(item);
                field.setShortLabel(shortLabels.getOrDefault(item.getNaaccrId(), "?"));
                field.setSection(sections.getOrDefault(item.getNaaccrId(), "?"));
                this._allFields.add(field);
                this._fieldsCachedByNaaccrNumber.put(field.getNaaccrItemNum(), field);
                this._fieldsCachedByName.put(field.getNaaccrId(), field);
                if (!"date".equals(item.getDataType())) continue;
                String shortLbl = field.getShortLabel();
                if (shortLbl.endsWith(" Dt")) {
                    shortLbl = shortLbl.substring(0, shortLbl.length() - 3);
                }
                NaaccrDictionaryItem yearItem = new NaaccrDictionaryItem();
                yearItem.setNaaccrId(item.getNaaccrId() + "Year");
                yearItem.setNaaccrName(field.getNaaccrName() + " (Year)");
                yearItem.setParentXmlElement(field.getParentXmlElement());
                yearItem.setLength(Integer.valueOf(4));
                yearItem.setDataType("digits");
                NaaccrXmlField yearFld = new NaaccrXmlField(yearItem);
                yearFld.setShortLabel(shortLbl + " Yr");
                this._fieldsCachedByName.put(yearFld.getNaaccrId(), yearFld);
                NaaccrDictionaryItem monthItem = new NaaccrDictionaryItem();
                monthItem.setNaaccrId(item.getNaaccrId() + "Month");
                monthItem.setNaaccrName(field.getNaaccrName() + " (Month)");
                monthItem.setParentXmlElement(field.getParentXmlElement());
                monthItem.setLength(Integer.valueOf(2));
                monthItem.setDataType("digits");
                NaaccrXmlField monthFld = new NaaccrXmlField(monthItem);
                monthFld.setShortLabel(shortLbl + " Mth");
                this._fieldsCachedByName.put(monthFld.getNaaccrId(), monthFld);
                NaaccrDictionaryItem dayItem = new NaaccrDictionaryItem();
                dayItem.setNaaccrId(item.getNaaccrId() + "Day");
                dayItem.setNaaccrName(field.getNaaccrName() + " (Day)");
                dayItem.setParentXmlElement(field.getParentXmlElement());
                dayItem.setLength(Integer.valueOf(2));
                dayItem.setDataType("digits");
                NaaccrXmlField dayFld = new NaaccrXmlField(dayItem);
                dayFld.setShortLabel(shortLbl + " Day");
                this._fieldsCachedByName.put(dayFld.getNaaccrId(), dayFld);
                field.setSubFields(Arrays.asList(yearFld, monthFld, dayFld));
            }
        }
        this.verify();
    }

    public void verify() {
        if (this._layoutId == null || this._layoutId.isEmpty()) {
            throw new IllegalStateException("Layout ID is required");
        }
        if (this._layoutName == null || this._layoutName.isEmpty()) {
            throw new IllegalStateException("Layout name is required");
        }
        if (this._recordType == null || this._recordType.isEmpty()) {
            throw new IllegalStateException("Record type is required");
        }
        if (!(this._recordType.equals("A") || this._recordType.equals("M") || this._recordType.equals("C") || this._recordType.equals("I"))) {
            throw new IllegalStateException("Record type not recognized: " + this._recordType);
        }
        if (this._naaccrVersion == null || !NaaccrFormat.isVersionSupported((String)this._naaccrVersion)) {
            throw new IllegalStateException("Unsupported NAACCR version: " + this._naaccrVersion);
        }
        if (this._baseDictionary == null) {
            throw new IllegalStateException("Base Dictionary is required");
        }
        for (NaaccrDictionary userDictionary : this._userDictionaries) {
            List errors = NaaccrXmlDictionaryUtils.validateUserDictionary((NaaccrDictionary)userDictionary);
            if (errors.isEmpty()) continue;
            throw new IllegalStateException("Error found on user dictionary - " + (String)errors.get(0));
        }
        if (!this._allFields.isEmpty()) {
            HashSet<String> names = new HashSet<String>();
            HashSet<String> naaccrItemNums = new HashSet<String>();
            for (NaaccrXmlField field : this._allFields) {
                if (field.getName() == null) {
                    throw new IllegalStateException("Field name (NAACCR XML ID) is required");
                }
                if (names.contains(field.getName())) {
                    throw new IllegalStateException("Field name (NAACCR XML ID) must be unique, found duplicate name for '" + field.getName() + "'");
                }
                names.add(field.getName());
                if (field.getItem() == null) {
                    throw new IllegalStateException("Field item definition is required, missing for field " + field.getName());
                }
                if (field.getNaaccrItemNum() != null) {
                    if (naaccrItemNums.contains(field.getNaaccrItemNum().toString())) {
                        throw new IllegalStateException("Field NAACCR number must be unique, found duplicate number for '" + field.getNaaccrItemNum() + "'");
                    }
                    naaccrItemNums.add(field.getNaaccrItemNum().toString());
                }
                if (field.getLength() == null) {
                    throw new IllegalStateException("Field length is required, missing for field " + field.getName());
                }
                if (field.getParentXmlElement() != null) continue;
                throw new IllegalStateException("Field parent XML element is required, missing for field " + field.getName());
            }
        }
    }

    @Override
    public String getLayoutId() {
        return this._layoutId;
    }

    public void setLayoutId(String layoutId) {
        this._layoutId = layoutId;
    }

    @Override
    public String getLayoutName() {
        return this._layoutName;
    }

    public void setLayoutName(String layoutName) {
        this._layoutName = layoutName;
    }

    @Override
    public String getLayoutVersion() {
        return this._naaccrVersion;
    }

    public void setLayoutVersion(String version) {
        this._naaccrVersion = version;
    }

    @Override
    public String getLayoutDescription() {
        return this._layoutDesc;
    }

    public void setLayoutDescription(String description) {
        this._layoutDesc = description;
    }

    public String getNaaccrVersion() {
        return this._naaccrVersion;
    }

    public void setNaaccrVersion(String naaccrVersion) {
        this._naaccrVersion = naaccrVersion;
    }

    public String getRecordType() {
        return this._recordType;
    }

    public void setRecordType(String recordType) {
        this._recordType = recordType;
    }

    public List<NaaccrXmlField> getAllFields() {
        return this._allFields;
    }

    @Override
    public NaaccrXmlField getFieldByName(String name) {
        return this._fieldsCachedByName.get(name);
    }

    @Override
    public NaaccrXmlField getFieldByNaaccrItemNumber(Integer num) {
        return this._fieldsCachedByNaaccrNumber.get(num);
    }

    @Override
    public String getFieldDocByName(String name) {
        return this.getFieldDocByNameOrNumber(name, null, null, null);
    }

    public String getFieldDocByName(String name, File archivedDocFile) {
        return this.getFieldDocByNameOrNumber(name, null, archivedDocFile, null);
    }

    public String getFieldDocByName(String name, ZipInputStream archivedDocStream) {
        return this.getFieldDocByNameOrNumber(name, null, null, archivedDocStream);
    }

    @Override
    public String getFieldDocByNaaccrItemNumber(Integer num) {
        return this.getFieldDocByNameOrNumber(null, num, null, null);
    }

    public String getFieldDocByNaaccrItemNumber(Integer num, File archivedDocFile) {
        return this.getFieldDocByNameOrNumber(null, num, archivedDocFile, null);
    }

    public String getFieldDocByNaaccrItemNumber(Integer num, ZipInputStream archivedDocStream) {
        return this.getFieldDocByNameOrNumber(null, num, null, archivedDocStream);
    }

    protected String getFieldDocByNameOrNumber(String name, Integer number, File archivedDocFile, ZipInputStream archivedDocStream) {
        NaaccrXmlField field = name != null ? this.getFieldByName(name) : this.getFieldByNaaccrItemNumber(number);
        String filename = null;
        if (field != null) {
            filename = field.getName();
        } else if (number != null) {
            filename = number.toString();
        }
        if (filename == null) {
            return null;
        }
        String result = null;
        URL docPath = Thread.currentThread().getContextClassLoader().getResource("layout/fixed/naaccr/doc/" + this.getDocFolder() + "/" + filename + ".html");
        if (docPath != null) {
            try (InputStreamReader reader = new InputStreamReader(docPath.openStream(), StandardCharsets.UTF_8);
                 StringWriter writer = new StringWriter();){
                IOUtils.copy((Reader)reader, (Writer)writer);
                result = ((Object)writer).toString();
            }
            catch (IOException iOException) {}
        } else if (archivedDocFile != null && archivedDocFile.exists()) {
            result = LayoutUtils.readNaaccrDocumentationFromFile(this.getDocFolder() + "/" + filename + ".html", archivedDocFile);
        } else if (archivedDocStream != null) {
            result = LayoutUtils.readNaaccrDocumentationFromZipInputStream(this.getDocFolder() + "/" + filename + ".html", archivedDocStream);
        }
        return result;
    }

    protected String getDocFolder() {
        if ("250".equals(this._naaccrVersion)) {
            return "naaccr24";
        }
        return "naaccr" + this._naaccrVersion.substring(0, 2);
    }

    @Override
    public String getFieldDocDefaultCssStyle() {
        return _CSS_STYLE.toString();
    }

    public void setFields(Collection<NaaccrXmlField> fields) {
        this._allFields.clear();
        this._allFields.addAll(fields);
        this.verify();
    }

    public NaaccrDictionary getBaseDictionary() {
        return this._baseDictionary;
    }

    public void setBaseDictionary(NaaccrDictionary dictionary) {
        this._baseDictionary = dictionary;
    }

    public List<NaaccrDictionary> getUserDictionaries() {
        return this._userDictionaries;
    }

    public void setUserDictionaries(List<NaaccrDictionary> dictionaries) {
        this._userDictionaries = dictionaries;
    }

    public void writeNextPatient(PatientXmlWriter writer, Patient patient) throws NaaccrIOException {
        if (patient != null) {
            writer.writePatient(patient);
        }
    }

    public void writeAllPatients(File file, List<Patient> allPatients, NaaccrData data, NaaccrOptions options) throws NaaccrIOException {
        try (FileOutputStream os = new FileOutputStream(file);){
            this.writeAllPatients(os, allPatients, data, options);
        }
        catch (IOException e) {
            throw new NaaccrIOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAllPatients(OutputStream outputStream, List<Patient> patients, NaaccrData data, NaaccrOptions options) throws NaaccrIOException {
        if (data == null) {
            return;
        }
        PatientXmlWriter writer = null;
        try {
            writer = new PatientXmlWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), data, options, this._userDictionaries);
            this.writeAllPatients(writer, patients);
        }
        finally {
            if (writer != null) {
                writer.closeAndKeepAlive();
            }
        }
    }

    public void writeAllPatients(PatientXmlWriter writer, List<Patient> patients) throws NaaccrIOException {
        if (patients != null) {
            for (Patient patient : patients) {
                writer.writePatient(patient);
            }
        }
    }

    public Patient readNextPatient(PatientXmlReader reader) throws NaaccrIOException {
        return reader.readPatient();
    }

    public List<Patient> readAllPatients(File file, String encoding, NaaccrOptions options) throws NaaccrIOException {
        List<Patient> patients;
        try (FileInputStream is = new FileInputStream(file);){
            patients = this.readAllPatients(is, encoding, options);
        }
        catch (IOException e) {
            throw new NaaccrIOException(e.getMessage());
        }
        return patients;
    }

    public List<Patient> readAllPatients(InputStream inputStream, String encoding, NaaccrOptions options) throws NaaccrIOException {
        List<Patient> patients;
        PatientXmlReader reader = null;
        try {
            reader = new PatientXmlReader((Reader)new InputStreamReader(inputStream, encoding), options, this._userDictionaries);
            patients = this.readAllPatients(reader);
        }
        catch (IOException e) {
            throw new NaaccrIOException(e.getMessage());
        }
        finally {
            if (reader != null) {
                reader.closeAndKeepAlive();
            }
        }
        return patients;
    }

    public List<Patient> readAllPatients(PatientXmlReader reader) throws NaaccrIOException {
        Patient patient;
        ArrayList<Patient> allPatients = new ArrayList<Patient>();
        while ((patient = reader.readPatient()) != null) {
            allPatients.add(patient);
        }
        return allPatients;
    }

    @Override
    public LayoutInfo buildFileInfo(File file, String zipEntryName, LayoutInfoDiscoveryOptions options) {
        Map attr;
        if (file == null) {
            return null;
        }
        try (InputStreamReader is = new InputStreamReader(LayoutUtils.createInputStream(file, zipEntryName), StandardCharsets.UTF_8);){
            attr = NaaccrXmlUtils.getAttributesFromXmlReader((Reader)is);
        }
        catch (IOException e) {
            return null;
        }
        String recordType = (String)attr.get("recordType");
        if (recordType == null || recordType.isEmpty() || !this._recordType.equals(recordType)) {
            return null;
        }
        String baseUri = NaaccrXmlDictionaryUtils.createUriFromVersion((String)this._naaccrVersion, (boolean)true);
        if (!baseUri.equals(attr.get("baseDictionaryUri"))) {
            return null;
        }
        LayoutInfo info = new LayoutInfo();
        info.setLayoutId(this._layoutId);
        info.setLayoutName(this._layoutName);
        info.setAvailableUserDictionaries(this._userDictionaries == null ? Collections.emptyList() : this._userDictionaries.stream().map(NaaccrDictionary::getDictionaryUri).collect(Collectors.toList()));
        info.setRequestedUserDictionaries(attr.get("userDictionaryUri") == null ? Collections.emptyList() : Arrays.asList(StringUtils.split((String)((String)attr.get("userDictionaryUri")), (String)" ")));
        NaaccrOptions opts = NaaccrOptions.getDefault();
        opts.setUseStrictNamespaces(Boolean.valueOf(options == null || options.isNaaccrXmlUseStrictNamespaces()));
        opts.setIgnoreExtensions(Boolean.valueOf(true));
        try (InputStreamReader is = new InputStreamReader(LayoutUtils.createInputStream(file, zipEntryName), StandardCharsets.UTF_8);
             PatientXmlReader reader = new PatientXmlReader((Reader)is, opts, this._userDictionaries);){
            info.setRootNaaccrXmlData(reader.getRootData());
        }
        catch (IOException e) {
            info.setErrorMessage(e.getMessage());
        }
        return info;
    }

    static {
        _CSS_STYLE.append(".naaccr-summary-table { width: 100%; }\n");
        _CSS_STYLE.append(".naaccr-summary-header { text-align: center; padding: 2px; background-color: #E0E0E0; }\n");
        _CSS_STYLE.append(".naaccr-summary-cell { vertical-align:top; padding: 2px; }\n");
        _CSS_STYLE.append(".naaccr-summary-centered { text-align: center; }\n");
        _CSS_STYLE.append(".naaccr-borders { border: 1px solid gray; border-collapse: collapse; }\n");
        _CSS_STYLE.append(".naaccr-underline { text-decoration:underline; }\n");
        _CSS_STYLE.append("#readerWrapper { margin-top: 20px;}\n");
        _CSS_STYLE.append("#pnlSearch { width: 100%;}\n");
        _CSS_STYLE.append("#lblSearch { margin-right: 20px;}\n");
        _CSS_STYLE.append(".wrapper { margin-bottom: 50px; width: 775px;}\n");
        _CSS_STYLE.append(".col { border-bottom: 1px solid black; border-left: 1px solid black; border-top: 1px solid black; float: left; height: 1100px; margin-bottom: 50px; padding: 0 5px; width: 180px;}\n");
        _CSS_STYLE.append(".colnoborder { border-bottom: 1px solid black; border-top: 1px solid black; float: left; height: 1100px; margin-bottom: 50px; padding: 0 5px; width: 180px;}\n");
        _CSS_STYLE.append(".tableColHead td:first-child { text-align: left;}\n");
        _CSS_STYLE.append(".tableColBody { text-align: center; vertical-align: top;}\n");
        _CSS_STYLE.append(".tableColTitle { background-color: #165185; color: #FABA44;}\n");
        _CSS_STYLE.append(".tableColDataStripe td:first-child { border-left: 0 none;}\n");
        _CSS_STYLE.append(".tableColDataStripe table tr td { padding: 0; text-align: center;}\n");
        _CSS_STYLE.append(".tableColData td:first-child { border-left: 0 none;}\n");
        _CSS_STYLE.append(".tableColData table tr td { padding: 0; text-align: center;}\n");
        _CSS_STYLE.append(".tableColData td.HighlightToolTip,\n");
        _CSS_STYLE.append(".tableColDataStripe td.HighlightToolTip { border-bottom: 1px dashed black; background-color: #a7d9f2;}\n");
        _CSS_STYLE.append(".tableAppendixBody { border-left: 0 none; display: table-row; padding-bottom: 1px; text-align: left;}\n");
        _CSS_STYLE.append(".code-nbr { padding-right: 20px; vertical-align: top;}\n");
        _CSS_STYLE.append("#stateList { padding-bottom: 30px; text-align: center; width: 720px;}\n");
        _CSS_STYLE.append("#chapter { width: 950px;}\n");
        _CSS_STYLE.append("#tiptip_holder { display: none; left: 0; position: absolute; top: 0; z-index: 99999;}\n");
        _CSS_STYLE.append("#tiptip_holder.tip_top { padding-bottom: 5px;}\n");
        _CSS_STYLE.append("#tiptip_holder.tip_bottom { padding-top: 5px;}\n");
        _CSS_STYLE.append("#tiptip_holder.tip_right { padding-left: 5px;}\n");
        _CSS_STYLE.append("#tiptip_holder.tip_left { padding-right: 5px;}\n");
        _CSS_STYLE.append("#tblSearch { margin-top: 20px;}\n");
        _CSS_STYLE.append(".dataDictionaryHeader { padding-right: 10px; text-align: right;}\n");
        _CSS_STYLE.append("#menuWrapper { height: 200px; margin-top: 20px; width: 950px;}\n");
        _CSS_STYLE.append(".chapterColumn { border-right: 2px solid white; float: left;}\n");
        _CSS_STYLE.append("a .chapter { color: #FFFFFF; padding: 0; text-decoration: none;}\n");
        _CSS_STYLE.append(".chapter:hover { background: none repeat scroll 0 0 #FF9900; color: #FFFFFF; text-decoration: none;}\n");
        _CSS_STYLE.append("#tiptip_arrow, #tiptip_arrow_inner { border-color: transparent; border-style: solid; border-width: 6px; height: 0; position: absolute; width: 0;}\n");
        _CSS_STYLE.append("#tiptip_holder.tip_top #tiptip_arrow { border-top-color: #FFFFCE;}\n");
        _CSS_STYLE.append("#tiptip_holder.tip_bottom #tiptip_arrow { border-bottom-color: #FFFFCE;}\n");
        _CSS_STYLE.append("#tiptip_holder.tip_right #tiptip_arrow { border-right-color: #FFFFCE;}\n");
        _CSS_STYLE.append("#tiptip_holder.tip_left #tiptip_arrow { border-left-color: #FFFFCE;}\n");
        _CSS_STYLE.append("#tiptip_holder.tip_top #tiptip_arrow_inner { border-top-color: #FFFFCE; margin-left: -6px; margin-top: -7px;}\n");
        _CSS_STYLE.append("#tiptip_holder.tip_bottom #tiptip_arrow_inner { border-bottom-color: #FFFFCE; margin-left: -6px; margin-top: -5px;}\n");
        _CSS_STYLE.append("#tiptip_holder.tip_right #tiptip_arrow_inner { border-right-color: #FFFFCE; margin-left: -5px; margin-top: -6px;}\n");
        _CSS_STYLE.append("#tiptip_holder.tip_left #tiptip_arrow_inner { border-left-color: #FFFFCE; margin-left: -7px; margin-top: -6px;}\n");
        _CSS_STYLE.append(".GeoCtrAlpha { float: left; width: 300px;}\n");
        _CSS_STYLE.append(".threeColSubTitle { float: left; font-style: italic; margin-bottom: 12px; width: 300px;}\n");
        _CSS_STYLE.append(".colRight { border-bottom: 1px solid black; border-left: 1px solid black; float: right; height: 1150px; padding-left: 20px; width: 454px;}\n");
        _CSS_STYLE.append(".colLeft { border-bottom: 1px solid black; float: left; height: 1150px; padding-left: 20px; width: 455px;}\n");
        _CSS_STYLE.append(".GeoCtr { float: left; width: 460px;}\n");
        _CSS_STYLE.append(".threeCol { border-bottom: 1px solid black; float: left; height: 1135px; padding-left: 10px; width: 305px;}\n");
        _CSS_STYLE.append(".threeColTitle { float: left; font-weight: bold; width: 300px;}\n");
        _CSS_STYLE.append(".CountryContinentName { float: left; font-weight: bold; margin-bottom: 15px; margin-top: 15px; width: 400px;}\n");
        _CSS_STYLE.append(".threeColMid { -moz-border-bottom-colors: none; -moz-border-image: none; -moz-border-left-colors: none; -moz-border-right-colors: none; -moz-border-top-colors: none; border-color: -moz-use-text-color black black; border-style: none solid solid; border-width: medium 1px 1px; float: left; height: 1135px; padding-left: 10px; width: 305px;}\n");
        _CSS_STYLE.append("#tiptip_content { background-color: #FFFFCE; padding: 4px 8px 5px;}\n");
        _CSS_STYLE.append("#tiptip_holder.tip_bottom #tiptip_arrow_inner { border-bottom-color: #FFFFCE;}\n");
        _CSS_STYLE.append("#tiptip_holder.tip_top #tiptip_arrow_inner { border-top-color: rgba(20, 20, 20, 0.92);}\n");
        _CSS_STYLE.append("h1 { margin: 1em 0;}\n");
        _CSS_STYLE.append("h2, h3 { margin: 0 0 1.33em 0;}\n");
        _CSS_STYLE.append("h4 { margin: 0;}\n");
        _CSS_STYLE.append("ul, ol { margin: 0 0 1.33em 35px;}\n");
        _CSS_STYLE.append("ul li, ol li { margin-bottom: 1.33em;}\n");
        _CSS_STYLE.append("table.padded td, table.padded th { padding: 5px;}\n");
        _CSS_STYLE.append("ul.nobullets { list-style: none;}\n");
        _CSS_STYLE.append("ul.notspaced li, ol.notspaced li { margin-bottom: 0;}\n");
        _CSS_STYLE.append(".c8cell1 { width: 70px;}\n");
        _CSS_STYLE.append("#pnlSearch { width: 100%;}\n");
        _CSS_STYLE.append("#lblSearch { margin-right: 20px;}\n");
        _CSS_STYLE.append(".chap10-head-table { margin-top: 15px;}\n");
        _CSS_STYLE.append(".chap10-para-head { font-weight: bold; padding-top: 10px;}\n");
        _CSS_STYLE.append(".chap10-para { padding-bottom: 10px;}\n");
        _CSS_STYLE.append(".chap10-para ul li { margin-bottom: 0;}\n");
    }
}

