/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.layout;

import com.imsweb.layout.Layout;
import com.imsweb.layout.LayoutInfo;
import com.imsweb.layout.LayoutInfoDiscoveryOptions;
import com.imsweb.layout.hl7.NaaccrHl7Layout;
import com.imsweb.layout.naaccrxml.NaaccrXmlLayout;
import com.imsweb.layout.record.csv.CommaSeparatedLayout;
import com.imsweb.layout.record.fixed.FixedColumnsLayout;
import com.imsweb.layout.record.fixed.naaccr.NaaccrLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class LayoutFactory {
    public static final String LAYOUT_ID_NAACCR_XML_25 = "naaccr-xml-25";
    public static final String LAYOUT_ID_NAACCR_XML_25_ABSTRACT = "naaccr-xml-25-abstract";
    public static final String LAYOUT_ID_NAACCR_XML_25_MODIFIED = "naaccr-xml-25-modified";
    public static final String LAYOUT_ID_NAACCR_XML_25_CONFIDENTIAL = "naaccr-xml-25-confidential";
    public static final String LAYOUT_ID_NAACCR_XML_25_INCIDENCE = "naaccr-xml-25-incidence";
    public static final String LAYOUT_ID_NAACCR_XML_24 = "naaccr-xml-24";
    public static final String LAYOUT_ID_NAACCR_XML_24_ABSTRACT = "naaccr-xml-24-abstract";
    public static final String LAYOUT_ID_NAACCR_XML_24_MODIFIED = "naaccr-xml-24-modified";
    public static final String LAYOUT_ID_NAACCR_XML_24_CONFIDENTIAL = "naaccr-xml-24-confidential";
    public static final String LAYOUT_ID_NAACCR_XML_24_INCIDENCE = "naaccr-xml-24-incidence";
    public static final String LAYOUT_ID_NAACCR_XML_23 = "naaccr-xml-23";
    public static final String LAYOUT_ID_NAACCR_XML_23_ABSTRACT = "naaccr-xml-23-abstract";
    public static final String LAYOUT_ID_NAACCR_XML_23_MODIFIED = "naaccr-xml-23-modified";
    public static final String LAYOUT_ID_NAACCR_XML_23_CONFIDENTIAL = "naaccr-xml-23-confidential";
    public static final String LAYOUT_ID_NAACCR_XML_23_INCIDENCE = "naaccr-xml-23-incidence";
    public static final String LAYOUT_ID_NAACCR_XML_22 = "naaccr-xml-22";
    public static final String LAYOUT_ID_NAACCR_XML_22_ABSTRACT = "naaccr-xml-22-abstract";
    public static final String LAYOUT_ID_NAACCR_XML_22_MODIFIED = "naaccr-xml-22-modified";
    public static final String LAYOUT_ID_NAACCR_XML_22_CONFIDENTIAL = "naaccr-xml-22-confidential";
    public static final String LAYOUT_ID_NAACCR_XML_22_INCIDENCE = "naaccr-xml-22-incidence";
    public static final String LAYOUT_ID_NAACCR_XML_21 = "naaccr-xml-21";
    public static final String LAYOUT_ID_NAACCR_XML_21_ABSTRACT = "naaccr-xml-21-abstract";
    public static final String LAYOUT_ID_NAACCR_XML_21_MODIFIED = "naaccr-xml-21-modified";
    public static final String LAYOUT_ID_NAACCR_XML_21_CONFIDENTIAL = "naaccr-xml-21-confidential";
    public static final String LAYOUT_ID_NAACCR_XML_21_INCIDENCE = "naaccr-xml-21-incidence";
    public static final String LAYOUT_ID_NAACCR_XML_18 = "naaccr-xml-18";
    public static final String LAYOUT_ID_NAACCR_XML_18_ABSTRACT = "naaccr-xml-18-abstract";
    public static final String LAYOUT_ID_NAACCR_XML_18_MODIFIED = "naaccr-xml-18-modified";
    public static final String LAYOUT_ID_NAACCR_XML_18_CONFIDENTIAL = "naaccr-xml-18-confidential";
    public static final String LAYOUT_ID_NAACCR_XML_18_INCIDENCE = "naaccr-xml-18-incidence";
    public static final String LAYOUT_ID_NAACCR_XML_16 = "naaccr-xml-16";
    public static final String LAYOUT_ID_NAACCR_XML_16_ABSTRACT = "naaccr-xml-16-abstract";
    public static final String LAYOUT_ID_NAACCR_XML_16_MODIFIED = "naaccr-xml-16-modified";
    public static final String LAYOUT_ID_NAACCR_XML_16_CONFIDENTIAL = "naaccr-xml-16-confidential";
    public static final String LAYOUT_ID_NAACCR_XML_16_INCIDENCE = "naaccr-xml-16-incidence";
    public static final String LAYOUT_ID_NAACCR_XML_15 = "naaccr-xml-15";
    public static final String LAYOUT_ID_NAACCR_XML_15_ABSTRACT = "naaccr-xml-15-abstract";
    public static final String LAYOUT_ID_NAACCR_XML_15_MODIFIED = "naaccr-xml-15-modified";
    public static final String LAYOUT_ID_NAACCR_XML_15_CONFIDENTIAL = "naaccr-xml-15-confidential";
    public static final String LAYOUT_ID_NAACCR_XML_15_INCIDENCE = "naaccr-xml-15-incidence";
    public static final String LAYOUT_ID_NAACCR_XML_14 = "naaccr-xml-14";
    public static final String LAYOUT_ID_NAACCR_XML_14_ABSTRACT = "naaccr-xml-14-abstract";
    public static final String LAYOUT_ID_NAACCR_XML_14_MODIFIED = "naaccr-xml-14-modified";
    public static final String LAYOUT_ID_NAACCR_XML_14_CONFIDENTIAL = "naaccr-xml-14-confidential";
    public static final String LAYOUT_ID_NAACCR_XML_14_INCIDENCE = "naaccr-xml-14-incidence";
    public static final String LAYOUT_ID_NAACCR_18 = "naaccr-18";
    public static final String LAYOUT_ID_NAACCR_18_ABSTRACT = "naaccr-18-abstract";
    public static final String LAYOUT_ID_NAACCR_18_MODIFIED = "naaccr-18-modified";
    public static final String LAYOUT_ID_NAACCR_18_CONFIDENTIAL = "naaccr-18-confidential";
    public static final String LAYOUT_ID_NAACCR_18_INCIDENCE = "naaccr-18-incidence";
    public static final String LAYOUT_ID_NAACCR_16 = "naaccr-16";
    public static final String LAYOUT_ID_NAACCR_16_ABSTRACT = "naaccr-16-abstract";
    public static final String LAYOUT_ID_NAACCR_16_MODIFIED = "naaccr-16-modified";
    public static final String LAYOUT_ID_NAACCR_16_CONFIDENTIAL = "naaccr-16-confidential";
    public static final String LAYOUT_ID_NAACCR_16_INCIDENCE = "naaccr-16-incidence";
    public static final String LAYOUT_ID_NAACCR_15 = "naaccr-15";
    public static final String LAYOUT_ID_NAACCR_15_ABSTRACT = "naaccr-15-abstract";
    public static final String LAYOUT_ID_NAACCR_15_MODIFIED = "naaccr-15-modified";
    public static final String LAYOUT_ID_NAACCR_15_CONFIDENTIAL = "naaccr-15-confidential";
    public static final String LAYOUT_ID_NAACCR_15_INCIDENCE = "naaccr-15-incidence";
    public static final String LAYOUT_ID_NAACCR_14 = "naaccr-14";
    public static final String LAYOUT_ID_NAACCR_14_ABSTRACT = "naaccr-14-abstract";
    public static final String LAYOUT_ID_NAACCR_14_MODIFIED = "naaccr-14-modified";
    public static final String LAYOUT_ID_NAACCR_14_CONFIDENTIAL = "naaccr-14-confidential";
    public static final String LAYOUT_ID_NAACCR_14_INCIDENCE = "naaccr-14-incidence";
    public static final String LAYOUT_ID_NAACCR_13 = "naaccr-13";
    public static final String LAYOUT_ID_NAACCR_13_ABSTRACT = "naaccr-13-abstract";
    public static final String LAYOUT_ID_NAACCR_13_MODIFIED = "naaccr-13-modified";
    public static final String LAYOUT_ID_NAACCR_13_CONFIDENTIAL = "naaccr-13-confidential";
    public static final String LAYOUT_ID_NAACCR_13_INCIDENCE = "naaccr-13-incidence";
    public static final String LAYOUT_ID_NAACCR_12 = "naaccr-12";
    public static final String LAYOUT_ID_NAACCR_12_ABSTRACT = "naaccr-12-abstract";
    public static final String LAYOUT_ID_NAACCR_12_MODIFIED = "naaccr-12-modified";
    public static final String LAYOUT_ID_NAACCR_12_CONFIDENTIAL = "naaccr-12-confidential";
    public static final String LAYOUT_ID_NAACCR_12_INCIDENCE = "naaccr-12-incidence";
    public static final String LAYOUT_ID_NAACCR_HL7_V5 = "naaccr-hl7-5.0";
    public static final String LAYOUT_ID_NAACCR_HL7_V4 = "naaccr-hl7-4.0";
    private static final Pattern _REGEX_NAACCR_XML_IDS = Pattern.compile("naaccr-xml-(\\d\\d)-(abstract|modified|confidential|incidence)");
    private static final Pattern _REGEX_NAACCR_FIXED_IDS = Pattern.compile("naaccr-(\\d\\d)-(abstract|modified|confidential|incidence)");
    private static final Map<String, String> _INTERNAL_LAYOUT_ID_ALIASES = new HashMap<String, String>();
    private static final Map<String, String> _INTERNAL_LAYOUTS;
    private static final Map<String, Layout> _LAYOUTS;

    private static Layout loadInternalLayout(String layoutId, boolean loadFields, boolean useDeprecatedFieldNames) {
        String rType;
        String type;
        String version;
        Layout layout = null;
        Matcher matcher = _REGEX_NAACCR_XML_IDS.matcher(layoutId);
        if (matcher.matches()) {
            version = matcher.group(1);
            type = StringUtils.capitalize((String)matcher.group(2));
            rType = type.substring(0, 1);
            layout = new NaaccrXmlLayout(version + "0", rType, layoutId, _INTERNAL_LAYOUTS.get(layoutId), "Standard XML NAACCR " + version + " " + type + " layout", null, loadFields);
        }
        if (layout == null && (matcher = _REGEX_NAACCR_FIXED_IDS.matcher(layoutId)).matches()) {
            int lineLength;
            version = matcher.group(1);
            type = StringUtils.capitalize((String)matcher.group(2));
            rType = type.substring(0, 1);
            if ("18".equals(version)) {
                switch (rType) {
                    case "A": 
                    case "M": {
                        lineLength = 24194;
                        break;
                    }
                    case "C": {
                        lineLength = 6154;
                        break;
                    }
                    case "I": {
                        lineLength = 4048;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid record type: " + rType);
                    }
                }
            } else {
                switch (rType) {
                    case "A": 
                    case "M": {
                        lineLength = 22824;
                        break;
                    }
                    case "C": {
                        lineLength = 5564;
                        break;
                    }
                    case "I": {
                        lineLength = 3339;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid record type: " + rType);
                    }
                }
            }
            layout = new NaaccrLayout("12".equals(version) ? "122" : version + "0", type.substring(0, 1), lineLength, layoutId, loadFields, useDeprecatedFieldNames);
        }
        if (layout == null) {
            if (LAYOUT_ID_NAACCR_HL7_V5.equals(layoutId)) {
                layout = new NaaccrHl7Layout(LAYOUT_ID_NAACCR_HL7_V5, "5.0", "2.5.1", loadFields);
            } else if (LAYOUT_ID_NAACCR_HL7_V4.equals(layoutId)) {
                layout = new NaaccrHl7Layout(LAYOUT_ID_NAACCR_HL7_V4, "4.0", "2.5.1", loadFields);
            }
        }
        if (layout == null) {
            throw new IllegalStateException("Unknown internal layout: " + layoutId);
        }
        return layout;
    }

    private LayoutFactory() {
    }

    public static NaaccrXmlLayout getNaaccrXmlLayout(String layoutId) {
        Layout layout = LayoutFactory.getLayout(layoutId);
        if (layout instanceof NaaccrXmlLayout) {
            return (NaaccrXmlLayout)layout;
        }
        throw new IllegalStateException("Requested a NaaccrXmlLayout but it was a " + layout.getClass().getSimpleName());
    }

    public static NaaccrLayout getNaaccrFixedColumnsLayout(String layoutId) {
        Layout layout = LayoutFactory.getLayout(layoutId);
        if (layout instanceof NaaccrLayout) {
            return (NaaccrLayout)layout;
        }
        throw new IllegalStateException("Requested a NaaccrLayout but it was a " + layout.getClass().getSimpleName());
    }

    public static NaaccrHl7Layout getNaaccrHl7Layout(String layoutId) {
        Layout layout = LayoutFactory.getLayout(layoutId);
        if (layout instanceof NaaccrHl7Layout) {
            return (NaaccrHl7Layout)layout;
        }
        throw new IllegalStateException("Requested a NaaccrHl7Layout but it was a " + layout.getClass().getSimpleName());
    }

    public static FixedColumnsLayout getFixedColumnsLayout(String layoutId) {
        Layout layout = LayoutFactory.getLayout(layoutId);
        if (layout instanceof FixedColumnsLayout) {
            return (FixedColumnsLayout)layout;
        }
        throw new IllegalStateException("Requested a FixedColumnsLayout but it was a " + layout.getClass().getSimpleName());
    }

    public static CommaSeparatedLayout getCommaSeparatedLayout(String layoutId) {
        Layout layout = LayoutFactory.getLayout(layoutId);
        if (layout instanceof CommaSeparatedLayout) {
            return (CommaSeparatedLayout)layout;
        }
        throw new IllegalStateException("Requested a CommaSeparatedLayout but it was a " + layout.getClass().getSimpleName());
    }

    public static Layout getLayout(String layoutId) {
        return LayoutFactory.getLayout(layoutId, false);
    }

    public static synchronized Layout getLayout(String layoutId, boolean useDeprecatedFieldNames) {
        if (_INTERNAL_LAYOUT_ID_ALIASES.containsKey(layoutId)) {
            layoutId = _INTERNAL_LAYOUT_ID_ALIASES.get(layoutId);
        }
        if (_LAYOUTS.containsKey(layoutId)) {
            return _LAYOUTS.get(layoutId);
        }
        if (_INTERNAL_LAYOUTS.containsKey(layoutId)) {
            Layout layout = LayoutFactory.loadInternalLayout(layoutId, true, useDeprecatedFieldNames);
            _LAYOUTS.put(layout.getLayoutId(), layout);
            return layout;
        }
        throw new IllegalStateException("Unknown layout ID: " + layoutId);
    }

    public static synchronized void registerLayout(Layout layout) {
        if (layout == null) {
            throw new IllegalStateException("Provided layout instance is null");
        }
        if (_INTERNAL_LAYOUTS.containsKey(layout.getLayoutId()) || _LAYOUTS.containsKey(layout.getLayoutId())) {
            throw new IllegalStateException("Layout ID must be unique: '" + layout.getLayoutId() + "' has already been registered");
        }
        if (layout instanceof FixedColumnsLayout) {
            ((FixedColumnsLayout)layout).verify();
        } else if (layout instanceof CommaSeparatedLayout) {
            ((CommaSeparatedLayout)layout).verify();
        }
        _LAYOUTS.put(layout.getLayoutId(), layout);
    }

    public static synchronized void unregisterLayout(String layoutId) {
        _LAYOUTS.remove(layoutId);
    }

    public static synchronized void unregisterAllLayouts() {
        _LAYOUTS.clear();
    }

    public static synchronized boolean isLayoutRegister(String layoutId) {
        return _LAYOUTS.containsKey(layoutId);
    }

    public static synchronized Set<String> getRegisterLayouts() {
        return Collections.unmodifiableSet(_LAYOUTS.keySet());
    }

    public static Map<String, String> getAvailableInternalLayouts() {
        HashMap<String, String> result = new HashMap<String, String>(_INTERNAL_LAYOUTS);
        for (String alias : _INTERNAL_LAYOUT_ID_ALIASES.keySet()) {
            result.remove(alias);
        }
        return result;
    }

    public static Map<String, String> getAvailableLayouts() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, Layout> entry : _LAYOUTS.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getLayoutName());
        }
        for (Map.Entry<String, Object> entry : _INTERNAL_LAYOUTS.entrySet()) {
            if (_INTERNAL_LAYOUT_ID_ALIASES.containsKey(entry.getKey()) || result.containsKey(entry.getKey())) continue;
            result.put(entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    public static List<LayoutInfo> discoverFormat(File file) {
        return LayoutFactory.discoverFormat(file, null, new LayoutInfoDiscoveryOptions());
    }

    public static List<LayoutInfo> discoverFormat(File file, String zipEntryName) {
        return LayoutFactory.discoverFormat(file, zipEntryName, null);
    }

    public static List<LayoutInfo> discoverFormat(File file, LayoutInfoDiscoveryOptions options) {
        return LayoutFactory.discoverFormat(file, null, options);
    }

    public static List<LayoutInfo> discoverFormat(File file, String zipEntryName, LayoutInfoDiscoveryOptions options) {
        LayoutInfo info;
        ArrayList<LayoutInfo> result = new ArrayList<LayoutInfo>();
        if (options == null) {
            options = new LayoutInfoDiscoveryOptions();
        }
        for (Map.Entry<String, Layout> entry : new TreeMap<String, Layout>(_LAYOUTS).entrySet()) {
            if (_INTERNAL_LAYOUTS.containsKey(entry.getKey()) || (info = entry.getValue().buildFileInfo(file, zipEntryName, options)) == null) continue;
            result.add(info);
        }
        for (String layoutId : _INTERNAL_LAYOUTS.keySet()) {
            if (!_LAYOUTS.containsKey(layoutId) || (info = _LAYOUTS.get(layoutId).buildFileInfo(file, zipEntryName, options)) == null) continue;
            result.add(info);
        }
        for (String layoutId : _INTERNAL_LAYOUTS.keySet()) {
            Layout layout;
            LayoutInfo info2;
            if (_LAYOUTS.containsKey(layoutId) || _INTERNAL_LAYOUT_ID_ALIASES.containsKey(layoutId) || (info2 = (layout = LayoutFactory.loadInternalLayout(layoutId, false, false)).buildFileInfo(file, zipEntryName, options)) == null) continue;
            result.add(info2);
        }
        return result;
    }

    static {
        _INTERNAL_LAYOUT_ID_ALIASES.put(LAYOUT_ID_NAACCR_XML_25, LAYOUT_ID_NAACCR_XML_25_ABSTRACT);
        _INTERNAL_LAYOUT_ID_ALIASES.put(LAYOUT_ID_NAACCR_XML_24, LAYOUT_ID_NAACCR_XML_24_ABSTRACT);
        _INTERNAL_LAYOUT_ID_ALIASES.put(LAYOUT_ID_NAACCR_XML_23, LAYOUT_ID_NAACCR_XML_23_ABSTRACT);
        _INTERNAL_LAYOUT_ID_ALIASES.put(LAYOUT_ID_NAACCR_XML_22, LAYOUT_ID_NAACCR_XML_22_ABSTRACT);
        _INTERNAL_LAYOUT_ID_ALIASES.put(LAYOUT_ID_NAACCR_XML_21, LAYOUT_ID_NAACCR_XML_21_ABSTRACT);
        _INTERNAL_LAYOUT_ID_ALIASES.put(LAYOUT_ID_NAACCR_XML_18, LAYOUT_ID_NAACCR_XML_18_ABSTRACT);
        _INTERNAL_LAYOUT_ID_ALIASES.put(LAYOUT_ID_NAACCR_XML_16, LAYOUT_ID_NAACCR_XML_16_ABSTRACT);
        _INTERNAL_LAYOUT_ID_ALIASES.put(LAYOUT_ID_NAACCR_XML_15, LAYOUT_ID_NAACCR_XML_15_ABSTRACT);
        _INTERNAL_LAYOUT_ID_ALIASES.put(LAYOUT_ID_NAACCR_XML_14, LAYOUT_ID_NAACCR_XML_14_ABSTRACT);
        _INTERNAL_LAYOUT_ID_ALIASES.put(LAYOUT_ID_NAACCR_18, LAYOUT_ID_NAACCR_18_ABSTRACT);
        _INTERNAL_LAYOUT_ID_ALIASES.put(LAYOUT_ID_NAACCR_16, LAYOUT_ID_NAACCR_16_ABSTRACT);
        _INTERNAL_LAYOUT_ID_ALIASES.put(LAYOUT_ID_NAACCR_15, LAYOUT_ID_NAACCR_15_ABSTRACT);
        _INTERNAL_LAYOUT_ID_ALIASES.put(LAYOUT_ID_NAACCR_14, LAYOUT_ID_NAACCR_14_ABSTRACT);
        _INTERNAL_LAYOUT_ID_ALIASES.put(LAYOUT_ID_NAACCR_13, LAYOUT_ID_NAACCR_13_ABSTRACT);
        _INTERNAL_LAYOUT_ID_ALIASES.put(LAYOUT_ID_NAACCR_12, LAYOUT_ID_NAACCR_12_ABSTRACT);
        _INTERNAL_LAYOUTS = new LinkedHashMap<String, String>();
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_25, "NAACCR XML 25 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_25_ABSTRACT, "NAACCR XML 25 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_25_MODIFIED, "NAACCR XML 25 Modified");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_25_CONFIDENTIAL, "NAACCR XML 25 Confidential");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_25_INCIDENCE, "NAACCR XML 25 Incidence");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_24, "NAACCR XML 24 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_24_ABSTRACT, "NAACCR XML 24 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_24_MODIFIED, "NAACCR XML 24 Modified");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_24_CONFIDENTIAL, "NAACCR XML 24 Confidential");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_24_INCIDENCE, "NAACCR XML 24 Incidence");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_23, "NAACCR XML 23 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_23_ABSTRACT, "NAACCR XML 23 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_23_MODIFIED, "NAACCR XML 23 Modified");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_23_CONFIDENTIAL, "NAACCR XML 23 Confidential");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_23_INCIDENCE, "NAACCR XML 23 Incidence");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_22, "NAACCR XML 22 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_22_ABSTRACT, "NAACCR XML 22 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_22_MODIFIED, "NAACCR XML 22 Modified");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_22_CONFIDENTIAL, "NAACCR XML 22 Confidential");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_22_INCIDENCE, "NAACCR XML 22 Incidence");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_21, "NAACCR XML 21 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_21_ABSTRACT, "NAACCR XML 21 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_21_MODIFIED, "NAACCR XML 21 Modified");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_21_CONFIDENTIAL, "NAACCR XML 21 Confidential");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_21_INCIDENCE, "NAACCR XML 21 Incidence");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_18, "NAACCR XML 18 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_18_ABSTRACT, "NAACCR XML 18 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_18_MODIFIED, "NAACCR XML 18 Modified");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_18_CONFIDENTIAL, "NAACCR XML 18 Confidential");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_18_INCIDENCE, "NAACCR XML 18 Incidence");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_16, "NAACCR XML 16 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_16_ABSTRACT, "NAACCR XML 16 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_16_MODIFIED, "NAACCR XML 16 Modified");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_16_CONFIDENTIAL, "NAACCR XML 16 Confidential");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_16_INCIDENCE, "NAACCR XML 16 Incidence");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_15, "NAACCR XML 15 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_15_ABSTRACT, "NAACCR XML 15 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_15_MODIFIED, "NAACCR XML 15 Modified");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_15_CONFIDENTIAL, "NAACCR XML 15 Confidential");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_15_INCIDENCE, "NAACCR XML 15 Incidence");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_14, "NAACCR XML 14 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_14_ABSTRACT, "NAACCR XML 14 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_14_MODIFIED, "NAACCR XML 14 Modified");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_14_CONFIDENTIAL, "NAACCR XML 14 Confidential");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_XML_14_INCIDENCE, "NAACCR XML 14 Incidence");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_18, "NAACCR Flat 18 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_18_ABSTRACT, "NAACCR Flat 18 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_18_MODIFIED, "NAACCR Flat 18 Modified");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_18_CONFIDENTIAL, "NAACCR Flat 18 Confidential");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_18_INCIDENCE, "NAACCR Flat 18 Incidence");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_16, "NAACCR Flat 16 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_16_ABSTRACT, "NAACCR Flat 16 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_16_MODIFIED, "NAACCR Flat 16 Modified");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_16_CONFIDENTIAL, "NAACCR Flat 16 Confidential");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_16_INCIDENCE, "NAACCR Flat 16 Incidence");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_15, "NAACCR Flat 15 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_15_ABSTRACT, "NAACCR Flat 15 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_15_MODIFIED, "NAACCR Flat 15 Modified");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_15_CONFIDENTIAL, "NAACCR Flat 15 Confidential");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_15_INCIDENCE, "NAACCR Flat 15 Incidence");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_14, "NAACCR Flat 14 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_14_ABSTRACT, "NAACCR Flat 14 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_14_MODIFIED, "NAACCR Flat 14 Modified");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_14_CONFIDENTIAL, "NAACCR Flat 14 Confidential");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_14_INCIDENCE, "NAACCR Flat 14 Incidence");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_13, "NAACCR Flat 13 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_13_ABSTRACT, "NAACCR Flat 13 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_13_MODIFIED, "NAACCR Flat 13 Modified");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_13_CONFIDENTIAL, "NAACCR Flat 13 Confidential");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_13_INCIDENCE, "NAACCR Flat 13 Incidence");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_12, "NAACCR Flat 12 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_12_ABSTRACT, "NAACCR Flat 12 Abstract");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_12_MODIFIED, "NAACCR Flat 12 Modified");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_12_CONFIDENTIAL, "NAACCR Flat 12 Confidential");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_12_INCIDENCE, "NAACCR Flat 12 Incidence");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_HL7_V4, "NAACCR HL7 v4.0");
        _INTERNAL_LAYOUTS.put(LAYOUT_ID_NAACCR_HL7_V5, "NAACCR HL7 v5.0");
        _LAYOUTS = new ConcurrentHashMap<String, Layout>();
    }
}

