/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.layout.hl7;

import com.imsweb.layout.hl7.entity.Hl7Component;
import com.imsweb.layout.hl7.entity.Hl7Field;
import com.imsweb.layout.hl7.entity.Hl7Message;
import com.imsweb.layout.hl7.entity.Hl7RepeatedField;
import com.imsweb.layout.hl7.entity.Hl7Segment;
import com.imsweb.layout.hl7.entity.Hl7SubComponent;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class Hl7MessageBuilder {
    private final Hl7Message _message;
    private Hl7Segment _currentSegment;
    private Hl7Field _currentField;
    private Hl7RepeatedField _currentRepeatedField;
    private Hl7Component _currentComponent;
    private Hl7SubComponent _currentSubComponent;

    public static Hl7MessageBuilder createMessage() {
        return Hl7MessageBuilder.createMessage(null);
    }

    public static Hl7MessageBuilder createMessage(Integer startingLineNumber) {
        Hl7Message message = new Hl7Message();
        message.setLineNumber(startingLineNumber);
        return new Hl7MessageBuilder(message);
    }

    public Hl7MessageBuilder(Hl7Message message) {
        this._message = message;
    }

    public Hl7MessageBuilder withSegment(String id) {
        this._currentSegment = new Hl7Segment(this._message, id);
        this._currentField = null;
        this._currentRepeatedField = null;
        this._currentComponent = null;
        this._currentSubComponent = null;
        return this;
    }

    public Hl7MessageBuilder withField(Integer index, String ... values) {
        if (this._currentSegment == null) {
            throw new IllegalStateException("no segment has been created yet");
        }
        this._currentField = new Hl7Field(this._currentSegment, index, values);
        this._currentRepeatedField = null;
        this._currentComponent = null;
        this._currentSubComponent = null;
        return this;
    }

    public Hl7MessageBuilder withRepeatedField() {
        if (this._currentField == null) {
            throw new IllegalStateException("no field has been created yet");
        }
        this._currentRepeatedField = new Hl7RepeatedField(this._currentField, new String[0]);
        this._currentComponent = null;
        this._currentSubComponent = null;
        return this;
    }

    public Hl7MessageBuilder withComponent(Integer index, String ... values) {
        if (this._currentRepeatedField == null) {
            this.withRepeatedField();
        }
        this._currentComponent = new Hl7Component(this._currentRepeatedField, index, values);
        this._currentSubComponent = null;
        return this;
    }

    public Hl7MessageBuilder withSubComponent(Integer index) {
        return this.withSubComponent(index, null);
    }

    public Hl7MessageBuilder withSubComponent(Integer index, String value) {
        if (this._currentComponent == null) {
            throw new IllegalStateException("no component has been created yet");
        }
        this._currentSubComponent = new Hl7SubComponent(this._currentComponent, index, value);
        return this;
    }

    public Hl7MessageBuilder withValue(String value) {
        if (this._currentSubComponent == null) {
            throw new IllegalStateException("no sub-component has been created yet");
        }
        this._currentSubComponent.setValue(value);
        this._currentSubComponent = null;
        return this;
    }

    public Hl7Message build() {
        Hl7Segment msh = this._message.getSegment("MSH");
        if (msh != null) {
            if (msh.getField(1).getValue() == null) {
                msh.addField(new Hl7Field(msh, 1, "|"));
            }
            if (msh.getField(2).getValue() == null) {
                msh.addField(new Hl7Field(msh, 2, "^~\\&"));
            }
            if (msh.getField(7).getValue() == null) {
                msh.addField(new Hl7Field(msh, 7, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss.SSS"))));
            }
            if (msh.getField(9).getValue() == null) {
                msh.addField(new Hl7Field(msh, 9, "ORU", "R01", "ORU_R01"));
            }
            if (msh.getField(11).getValue() == null) {
                msh.addField(new Hl7Field(msh, 11, "P"));
            }
            if (msh.getField(12).getValue() == null) {
                msh.addField(new Hl7Field(msh, 12, "2.5.1"));
            }
            if (msh.getField(21).getValue() == null) {
                msh.addField(new Hl7Field(msh, 21, "VOL_V_50_ORU_R01", "NAACCR_CP"));
            }
        }
        return this._message;
    }
}

