/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.layout.hl7;

import com.imsweb.layout.Field;
import com.imsweb.layout.Layout;
import com.imsweb.layout.LayoutFactory;
import com.imsweb.layout.LayoutInfo;
import com.imsweb.layout.LayoutInfoDiscoveryOptions;
import com.imsweb.layout.LayoutUtils;
import com.imsweb.layout.hl7.Hl7LayoutOptions;
import com.imsweb.layout.hl7.Hl7Utils;
import com.imsweb.layout.hl7.NaaccrHl7Field;
import com.imsweb.layout.hl7.entity.Hl7Message;
import com.imsweb.layout.hl7.entity.Hl7Segment;
import com.imsweb.layout.hl7.xml.Hl7ComponentXmlDto;
import com.imsweb.layout.hl7.xml.Hl7FieldXmlDto;
import com.imsweb.layout.hl7.xml.Hl7LayoutXmlDto;
import com.imsweb.layout.hl7.xml.Hl7SegmentXmlDto;
import com.imsweb.layout.hl7.xml.Hl7SubComponentXmlDto;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NaaccrHl7Layout
implements Layout {
    protected String _layoutId;
    protected String _layoutName;
    protected String _layoutVersion;
    protected String _layoutDesc;
    protected String _hl7Specifications;
    protected List<NaaccrHl7Field> _fields = new ArrayList<NaaccrHl7Field>();
    protected Map<String, NaaccrHl7Field> _cachedByName = new HashMap<String, NaaccrHl7Field>();

    public NaaccrHl7Layout(String layoutId, String layoutVersion, String hl7Specifications, boolean loadFields) {
        this._hl7Specifications = hl7Specifications;
        Hl7LayoutXmlDto layoutXmlDto = new Hl7LayoutXmlDto();
        layoutXmlDto.setId(layoutId);
        layoutXmlDto.setName(LayoutFactory.getAvailableInternalLayouts().get(layoutId));
        layoutXmlDto.setVersion(layoutVersion);
        layoutXmlDto.setDescription("NAACCR HL7 version " + layoutVersion);
        try {
            if (loadFields) {
                String xmlFilename = layoutId + "-layout.xml";
                Hl7LayoutXmlDto tmpXmlLayout = LayoutUtils.readHl7Layout(Thread.currentThread().getContextClassLoader().getResourceAsStream("layout/hl7/naaccr/" + xmlFilename));
                layoutXmlDto.setHl7Segments(tmpXmlLayout.getHl7Segments());
            }
            this.init(layoutXmlDto);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to instantiate NAACCR HL7 layout", e);
        }
    }

    public NaaccrHl7Layout(URL layoutUrl) throws IOException {
        if (layoutUrl == null) {
            throw new NullPointerException("Unable to create HL7 layout from null URL");
        }
        try (InputStream is = layoutUrl.openStream();){
            this.init(LayoutUtils.readHl7Layout(is));
        }
    }

    public NaaccrHl7Layout(File layoutFile) throws IOException {
        if (layoutFile == null) {
            throw new NullPointerException("Unable to create HL7-layout from null file");
        }
        if (!layoutFile.exists()) {
            throw new IOException("Unable to read from " + layoutFile.getPath());
        }
        try (InputStream is = Files.newInputStream(layoutFile.toPath(), new OpenOption[0]);){
            this.init(LayoutUtils.readHl7Layout(is));
        }
    }

    public NaaccrHl7Layout(Hl7LayoutXmlDto layoutXmlDto) throws IOException {
        if (layoutXmlDto == null) {
            throw new NullPointerException("Unable to create HL7-layout from null XML object");
        }
        this.init(layoutXmlDto);
    }

    protected void init(Hl7LayoutXmlDto layoutXmlDto) throws IOException {
        this._layoutId = layoutXmlDto.getId();
        this._layoutName = layoutXmlDto.getName();
        this._layoutVersion = layoutXmlDto.getVersion();
        this._layoutDesc = layoutXmlDto.getDescription();
        this._fields.clear();
        for (Hl7SegmentXmlDto segmentXmlDto : layoutXmlDto.getHl7Segments()) {
            for (Hl7FieldXmlDto fieldXmlDto : segmentXmlDto.getHl7Fields()) {
                NaaccrHl7Field field = this.createFieldFromXmlField(fieldXmlDto);
                ArrayList<NaaccrHl7Field> subFields = new ArrayList<NaaccrHl7Field>();
                for (Hl7ComponentXmlDto componentXmlDto : fieldXmlDto.getHl7Components()) {
                    NaaccrHl7Field subField = this.createFieldFromXmlComponent(componentXmlDto);
                    ArrayList<NaaccrHl7Field> subSubFields = new ArrayList<NaaccrHl7Field>();
                    for (Hl7SubComponentXmlDto subComponentXmlDto : componentXmlDto.getHl7SubComponents()) {
                        subSubFields.add(this.createFieldFromXmlSubComponent(subComponentXmlDto));
                    }
                    if (!subSubFields.isEmpty()) {
                        subField.setSubFields(subSubFields);
                    }
                    subFields.add(subField);
                }
                if (!subFields.isEmpty()) {
                    field.setSubFields(subFields);
                }
                this._fields.add(field);
                this._cachedByName.put(field.getName(), field);
            }
        }
    }

    protected NaaccrHl7Field createFieldFromXmlField(Hl7FieldXmlDto hl7FieldXmlDto) throws IOException {
        NaaccrHl7Field field = new NaaccrHl7Field();
        field.setName(hl7FieldXmlDto.getName());
        field.setIdentifier(hl7FieldXmlDto.getIdentifier());
        field.setLongLabel(hl7FieldXmlDto.getLongLabel());
        field.setType(hl7FieldXmlDto.getType());
        field.setMinOccurrence(hl7FieldXmlDto.getMinOccurrence());
        field.setMaxOccurrence(hl7FieldXmlDto.getMaxOccurrence());
        if (hl7FieldXmlDto.getMinOccurrence() > hl7FieldXmlDto.getMaxOccurrence()) {
            throw new IOException("Field " + field.getName() + " defines a minimum occurrence that is greater than the maximum occurrence");
        }
        return field;
    }

    protected NaaccrHl7Field createFieldFromXmlComponent(Hl7ComponentXmlDto hl7ComponentXmlDto) {
        NaaccrHl7Field field = new NaaccrHl7Field();
        field.setName(hl7ComponentXmlDto.getName());
        field.setIdentifier(hl7ComponentXmlDto.getIdentifier());
        field.setLongLabel(hl7ComponentXmlDto.getLongLabel());
        field.setType(hl7ComponentXmlDto.getType());
        return field;
    }

    protected NaaccrHl7Field createFieldFromXmlSubComponent(Hl7SubComponentXmlDto hl7FSubComponentXmlDto) {
        NaaccrHl7Field field = new NaaccrHl7Field();
        field.setName(hl7FSubComponentXmlDto.getName());
        field.setIdentifier(hl7FSubComponentXmlDto.getIdentifier());
        field.setLongLabel(hl7FSubComponentXmlDto.getLongLabel());
        field.setType(hl7FSubComponentXmlDto.getType());
        return field;
    }

    @Override
    public String getLayoutId() {
        return this._layoutId;
    }

    @Override
    public String getLayoutName() {
        return this._layoutName;
    }

    @Override
    public String getLayoutVersion() {
        return this._layoutVersion;
    }

    @Override
    public String getLayoutDescription() {
        return this._layoutDesc;
    }

    public String getHl7Specifications() {
        return this._hl7Specifications;
    }

    @Override
    public Field getFieldByName(String name) {
        return this._cachedByName.get(name);
    }

    @Override
    public Field getFieldByNaaccrItemNumber(Integer num) {
        return null;
    }

    @Override
    public List<? extends Field> getAllFields() {
        return Collections.unmodifiableList(this._fields);
    }

    @Override
    public String getFieldDocByName(String name) {
        return null;
    }

    @Override
    public String getFieldDocByNaaccrItemNumber(Integer num) {
        return null;
    }

    @Override
    public String getFieldDocDefaultCssStyle() {
        return null;
    }

    @Override
    public LayoutInfo buildFileInfo(File file, String zipEntryName, LayoutInfoDiscoveryOptions options) {
        LayoutInfo result = null;
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(LayoutUtils.createInputStream(file, zipEntryName), StandardCharsets.UTF_8));){
            String line = reader.readLine();
            while (line != null && reader.getLineNumber() < 25) {
                if (line.startsWith("MSH")) {
                    String profileIdentifier;
                    String expectedProfileIdentifier;
                    Hl7Segment segment = Hl7Utils.segmentFromString(new Hl7Message(), line);
                    String hl7Version = segment.getField(12).getComponent(1).getValue();
                    if (this._hl7Specifications.equals(hl7Version) && (expectedProfileIdentifier = "VOL_V_" + this._layoutVersion.replace(".", "") + "_ORU_R01").equals(profileIdentifier = segment.getField(21).getComponent(1).getValue())) {
                        result = new LayoutInfo();
                        result.setLayoutId(this.getLayoutId());
                        result.setLayoutName(this.getLayoutName());
                    }
                    break;
                }
                if (line.startsWith("PID")) {
                    break;
                }
                line = reader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public Hl7Message readNextMessage(LineNumberReader reader) throws IOException {
        return this.readNextMessage(reader, new Hl7LayoutOptions());
    }

    public Hl7Message readNextMessage(LineNumberReader reader, Hl7LayoutOptions options) throws IOException {
        return this.fetchNextMessage(reader, options);
    }

    public List<Hl7Message> readAllMessages(File file) throws IOException {
        return this.readAllMessages(file, new Hl7LayoutOptions());
    }

    public List<Hl7Message> readAllMessages(File file, Hl7LayoutOptions options) throws IOException {
        ArrayList<Hl7Message> result = new ArrayList<Hl7Message>();
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(LayoutUtils.createInputStream(file), options.getEncoding()));){
            Hl7Message message = this.readNextMessage(reader, options);
            while (message != null) {
                result.add(message);
                message = this.readNextMessage(reader, options);
            }
        }
        return result;
    }

    public void writeMessage(Writer writer, Hl7Message message) throws IOException {
        this.writeMessage(writer, message, new Hl7LayoutOptions());
    }

    public void writeMessage(Writer writer, Hl7Message message, Hl7LayoutOptions options) throws IOException {
        writer.write(Hl7Utils.messageToString(message, options));
        writer.write(options.getLineSeparator());
    }

    public void writeMessages(File file, List<Hl7Message> messages) throws IOException {
        this.writeMessages(file, messages, new Hl7LayoutOptions());
    }

    public void writeMessages(File file, List<Hl7Message> messages, Hl7LayoutOptions options) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(LayoutUtils.createOutputStream(file), options.getEncoding()));){
            for (Hl7Message message : messages) {
                this.writeMessage(writer, message);
                writer.write(options.getLineSeparator());
            }
        }
    }

    protected Hl7Message fetchNextMessage(LineNumberReader reader, Hl7LayoutOptions options) throws IOException {
        Hl7Message msg = null;
        String line = reader.readLine();
        while (line != null && (line.startsWith("FHS") || line.startsWith("BHS"))) {
            line = reader.readLine();
        }
        while (line != null && !line.startsWith("MSH")) {
            line = reader.readLine();
        }
        if (line != null) {
            msg = new Hl7Message();
            msg.setLineNumber(reader.getLineNumber());
            while (line != null && !line.trim().isEmpty()) {
                if (line.length() > 3) {
                    Hl7Utils.segmentFromString(msg, line, options);
                }
                reader.mark(8192);
                char[] peek = new char[3];
                int n = reader.read(peek);
                reader.reset();
                if (n != -1 && "MSH".equals(String.valueOf(peek))) break;
                line = reader.readLine();
            }
        }
        return msg;
    }
}

