/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.layout.hl7.entity;

import com.imsweb.layout.hl7.Hl7Utils;
import com.imsweb.layout.hl7.entity.Hl7RepeatedField;
import com.imsweb.layout.hl7.entity.Hl7SubComponent;
import java.util.HashMap;
import java.util.Map;

public class Hl7Component {
    private Hl7RepeatedField _repeatedField;
    private Integer _index;
    private Map<Integer, Hl7SubComponent> _subComponents;

    public Hl7Component(Hl7RepeatedField repeatedField, Integer index, String ... values) {
        if (index == null) {
            throw new IllegalStateException("Index is required");
        }
        if (index < 1 || index > 9999) {
            throw new IllegalStateException("Index must be between 1 and 9999");
        }
        this._repeatedField = repeatedField;
        this._index = index;
        this._subComponents = new HashMap<Integer, Hl7SubComponent>();
        if (repeatedField != null) {
            repeatedField.addComponent(this);
        }
        if (values != null && values.length != 0) {
            for (int i = 0; i < values.length; ++i) {
                new Hl7SubComponent(this, i + 1, values[i]);
            }
        }
    }

    public Hl7RepeatedField getRepeatedField() {
        return this._repeatedField;
    }

    public void setRepeatedField(Hl7RepeatedField repeatedField) {
        if (repeatedField == null) {
            throw new IllegalStateException("Parent repeated field cannot be null");
        }
        this._repeatedField = repeatedField;
    }

    public Integer getIndex() {
        return this._index;
    }

    public void setIndex(Integer index) {
        if (index == null) {
            throw new IllegalStateException("Index is required");
        }
        if (index < 1 || index > 9999) {
            throw new IllegalStateException("Index must be between 1 and 9999");
        }
        this._index = index;
    }

    public Map<Integer, Hl7SubComponent> getSubComponents() {
        return this._subComponents;
    }

    public void setSubComponents(Map<Integer, Hl7SubComponent> subComponents) {
        this._subComponents = subComponents == null ? new HashMap() : subComponents;
    }

    public void addSubComponent(Hl7SubComponent subComponent) {
        this._subComponents.put(subComponent.getIndex(), subComponent);
    }

    public Hl7SubComponent getSubComponent(int subComponentIdx) {
        Hl7SubComponent result = this._subComponents.get(subComponentIdx);
        return result == null ? new Hl7SubComponent(null, subComponentIdx, null) : result;
    }

    public String getValue() {
        String value = Hl7Utils.componentToString(this, false);
        return value.isEmpty() ? null : value;
    }

    public String getValue(int subComponentIdx) {
        return this.getSubComponent(subComponentIdx).getValue();
    }
}

