/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.layout.hl7.entity;

import com.imsweb.layout.hl7.entity.Hl7Component;
import com.imsweb.layout.hl7.entity.Hl7Field;
import com.imsweb.layout.hl7.entity.Hl7RepeatedField;
import com.imsweb.layout.hl7.entity.Hl7Segment;
import com.imsweb.layout.hl7.entity.Hl7SubComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Hl7Message {
    private Integer _lineNumber;
    private List<Hl7Segment> _segments = new ArrayList<Hl7Segment>();

    public List<Hl7Segment> getSegments() {
        return this._segments;
    }

    public void setSegments(List<Hl7Segment> segments) {
        this._segments = segments;
    }

    public void addSegment(Hl7Segment segment) {
        this._segments.add(segment);
    }

    public Integer getLineNumber() {
        return this._lineNumber;
    }

    public void setLineNumber(Integer lineNumber) {
        this._lineNumber = lineNumber;
    }

    public String getFieldSeparator() {
        String value = this.getMshFieldValue(1);
        return value == null ? "|" : value;
    }

    public String getComponentSeparator() {
        String value = this.getMshFieldValue(2);
        return value == null || value.length() != 4 ? "^" : String.valueOf(value.charAt(0));
    }

    public String getRepetitionSeparator() {
        String value = this.getMshFieldValue(2);
        return value == null || value.length() != 4 ? "~" : String.valueOf(value.charAt(1));
    }

    public String getEscapeCharacter() {
        String value = this.getMshFieldValue(2);
        return value == null || value.length() != 4 ? "\\" : String.valueOf(value.charAt(2));
    }

    public String getSubComponentSeparator() {
        String value = this.getMshFieldValue(2);
        return value == null || value.length() != 4 ? "&" : String.valueOf(value.charAt(3));
    }

    private String getMshFieldValue(int fieldIdx) {
        Hl7SubComponent subComponent;
        Hl7Component component;
        Hl7RepeatedField repeatedField;
        Hl7Field field;
        Hl7Segment segment = this.getSegment("MSH");
        if (segment != null && (field = segment.getField(fieldIdx)) != null && (repeatedField = field.getRepeatedField(1)) != null && (component = repeatedField.getComponent(1)) != null && (subComponent = component.getSubComponent(1)) != null) {
            return subComponent.getValue();
        }
        return null;
    }

    public Hl7Segment getSegment(String id) {
        return this.getSegment(id, 0);
    }

    public Hl7Segment getSegment(String id, int idx) {
        List filteredSegments = this._segments.stream().filter(s -> s.getId().equals(id)).collect(Collectors.toList());
        return idx >= filteredSegments.size() ? null : (Hl7Segment)filteredSegments.get(idx);
    }
}

