/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.layout.hl7;

import com.imsweb.layout.hl7.Hl7LayoutOptions;
import com.imsweb.layout.hl7.entity.Hl7Component;
import com.imsweb.layout.hl7.entity.Hl7Field;
import com.imsweb.layout.hl7.entity.Hl7Message;
import com.imsweb.layout.hl7.entity.Hl7RepeatedField;
import com.imsweb.layout.hl7.entity.Hl7Segment;
import com.imsweb.layout.hl7.entity.Hl7SubComponent;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class Hl7Utils {
    private static final Pattern _ESCAPED_SEQUENCES = Pattern.compile("\\\\([A-Z])([^\\\\]*)\\\\");
    private static final Pattern _SEGMENT_ID_PATTERN = Pattern.compile("[A-Z\\d]{3}");

    private Hl7Utils() {
    }

    public static Hl7Segment segmentFromString(Hl7Message msg, String line) {
        return Hl7Utils.segmentFromString(msg, line, new Hl7LayoutOptions());
    }

    public static Hl7Segment segmentFromString(Hl7Message msg, String line, Hl7LayoutOptions options) {
        String id;
        String string = id = line.length() < 3 ? line : line.substring(0, 3);
        if (!_SEGMENT_ID_PATTERN.matcher(id).matches()) {
            if (options.skipInvalidSegmentIds()) {
                return null;
            }
            throw new IllegalStateException("Index must be a mix of 3 uppercase letters and/or digits");
        }
        Hl7Segment segment = new Hl7Segment(msg, id);
        if ("MSH".equals(segment.getId()) && line.length() > 3) {
            String fieldSeparator = String.valueOf(line.charAt(3));
            segment.getField(2).getRepeatedField(1).getComponent(1).getSubComponent(1).setValue(fieldSeparator);
        }
        String[] fieldValues = StringUtils.splitPreserveAllTokens((String)line, (String)msg.getFieldSeparator());
        for (int fieldIdx = 1; fieldIdx < fieldValues.length; ++fieldIdx) {
            if ("MSH".equals(segment.getId()) && fieldIdx == 1) {
                if (fieldValues[1].length() > 3) {
                    segment.getField(2).getRepeatedField(1).getComponent(1).getSubComponent(1).setValue(String.valueOf(fieldValues[1].charAt(0)));
                    segment.getField(2).getRepeatedField(1).getComponent(1).getSubComponent(2).setValue(String.valueOf(fieldValues[1].charAt(1)));
                    segment.getField(2).getRepeatedField(1).getComponent(1).getSubComponent(3).setValue(String.valueOf(fieldValues[1].charAt(2)));
                    segment.getField(2).getRepeatedField(1).getComponent(1).getSubComponent(4).setValue(String.valueOf(fieldValues[1].charAt(3)));
                }
                segment.addField(new Hl7Field(segment, 2, fieldValues[1]));
                continue;
            }
            String fieldValue = fieldValues[fieldIdx];
            if (fieldValue.isEmpty()) continue;
            Hl7Field field = new Hl7Field(segment, "MSH".equals(segment.getId()) ? fieldIdx + 1 : fieldIdx, new String[0]);
            String[] repeatedFieldValues = StringUtils.splitPreserveAllTokens((String)fieldValue, (String)msg.getRepetitionSeparator());
            for (int repeatedFieldIdx = 0; repeatedFieldIdx < repeatedFieldValues.length; ++repeatedFieldIdx) {
                String repeatedFieldValue = repeatedFieldValues[repeatedFieldIdx];
                if (repeatedFieldValue.isEmpty()) continue;
                Hl7RepeatedField repeatedField = new Hl7RepeatedField(field, new String[0]);
                String[] compValues = StringUtils.splitPreserveAllTokens((String)repeatedFieldValue, (String)msg.getComponentSeparator());
                for (int compIdx = 0; compIdx < compValues.length; ++compIdx) {
                    String compValue = compValues[compIdx];
                    if (compValue.isEmpty()) continue;
                    Hl7Component component = new Hl7Component(repeatedField, compIdx + 1, new String[0]);
                    String[] subCompValues = StringUtils.splitPreserveAllTokens((String)compValue, (String)msg.getSubComponentSeparator());
                    for (int subCompIdx = 0; subCompIdx < subCompValues.length; ++subCompIdx) {
                        String subCompChar;
                        String compChar;
                        String repeatingChar;
                        String fieldChar;
                        String escapeChar = msg.getEscapeCharacter();
                        String subCompValue = Hl7Utils.decodeEscapedSequences(subCompValues[subCompIdx], escapeChar, fieldChar = msg.getFieldSeparator(), repeatingChar = msg.getRepetitionSeparator(), compChar = msg.getComponentSeparator(), subCompChar = msg.getSubComponentSeparator());
                        if (subCompValue == null || subCompValue.isEmpty()) continue;
                        new Hl7SubComponent(component, subCompIdx + 1, subCompValue);
                    }
                }
            }
        }
        return segment;
    }

    public static String messageToString(Hl7Message message) {
        return Hl7Utils.messageToString(message, new Hl7LayoutOptions());
    }

    public static String messageToString(Hl7Message message, Hl7LayoutOptions options) {
        if (message == null || message.getSegments().isEmpty()) {
            return "";
        }
        Hl7Segment msh = message.getSegment("MSH");
        if (msh != null) {
            if (msh.getField(1).getValue() == null) {
                msh.getField(1).getComponent(1).getSubComponent(1).setValue("|");
            }
            if (msh.getField(2).getValue() == null) {
                msh.getField(2).getComponent(1).getSubComponent(1).setValue("^~\\&");
            }
            if (msh.getField(7).getValue() == null) {
                msh.getField(7).getComponent(1).getSubComponent(1).setValue(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss.SSS")));
            }
            if (msh.getField(9).getValue() == null) {
                msh.getField(9).getComponent(1).getSubComponent(1).setValue("ORU");
                msh.getField(9).getComponent(2).getSubComponent(1).setValue("R01");
                msh.getField(9).getComponent(3).getSubComponent(1).setValue("ORU_R01");
            }
            if (msh.getField(11).getValue() == null) {
                msh.getField(11).getComponent(1).getSubComponent(1).setValue("P");
            }
            if (msh.getField(12).getValue() == null) {
                msh.getField(12).getComponent(1).getSubComponent(1).setValue("2.5.1");
            }
            if (msh.getField(21).getValue() == null) {
                msh.getField(21).getComponent(1).getSubComponent(1).setValue("VOL_V_50_ORU_R01");
                msh.getField(21).getComponent(2).getSubComponent(1).setValue("NAACCR_CP");
            }
        }
        return message.getSegments().stream().map(Hl7Utils::segmentToString).filter(Objects::nonNull).collect(Collectors.joining(options.getLineSeparator()));
    }

    public static String segmentToString(Hl7Segment segment) {
        return Hl7Utils.segmentToString(segment, true);
    }

    public static String segmentToString(Hl7Segment segment, boolean encode) {
        if (segment == null || segment.getFields().isEmpty()) {
            return null;
        }
        int max = segment.getFields().keySet().stream().max(Integer::compareTo).orElse(0);
        boolean msh = "MSH".equals(segment.getId());
        ArrayList<Object> list = new ArrayList<Object>(Collections.nCopies(max, null));
        segment.getFields().values().stream().filter(f -> !msh || f.getIndex() != 1).forEach(f -> list.set(msh ? f.getIndex() - 2 : f.getIndex() - 1, f));
        String separator = segment.getMessage().getFieldSeparator();
        return segment.getId() + separator + list.stream().map(f -> Hl7Utils.fieldToString(f, encode && !msh)).collect(Collectors.joining(separator));
    }

    public static String fieldToString(Hl7Field field) {
        return Hl7Utils.fieldToString(field, true);
    }

    public static String fieldToString(Hl7Field field, boolean encode) {
        if (field == null || field.getRepeatedFields().isEmpty()) {
            return "";
        }
        String separator = field.getSegment().getMessage().getRepetitionSeparator();
        return field.getRepeatedFields().stream().map(r -> Hl7Utils.repeatedFieldToString(r, encode)).collect(Collectors.joining(separator));
    }

    public static String repeatedFieldToString(Hl7RepeatedField repeatedField) {
        return Hl7Utils.repeatedFieldToString(repeatedField, true);
    }

    public static String repeatedFieldToString(Hl7RepeatedField repeatedField, boolean encode) {
        if (repeatedField == null || repeatedField.getComponents().isEmpty()) {
            return "";
        }
        int max = repeatedField.getComponents().keySet().stream().max(Integer::compareTo).orElse(0);
        ArrayList<Object> list = new ArrayList<Object>(Collections.nCopies(max, null));
        repeatedField.getComponents().values().forEach(c -> list.set(c.getIndex() - 1, c));
        String separator = repeatedField.getField().getSegment().getMessage().getComponentSeparator();
        return list.stream().map(c -> Hl7Utils.componentToString(c, encode)).collect(Collectors.joining(separator));
    }

    public static String componentToString(Hl7Component component) {
        return Hl7Utils.componentToString(component, true);
    }

    public static String componentToString(Hl7Component component, boolean encode) {
        if (component == null || component.getSubComponents().isEmpty()) {
            return "";
        }
        int max = component.getSubComponents().keySet().stream().max(Integer::compareTo).orElse(0);
        ArrayList<Object> list = new ArrayList<Object>(Collections.nCopies(max, null));
        component.getSubComponents().values().forEach(c -> list.set(c.getIndex() - 1, c));
        Hl7Message msg = component.getRepeatedField().getField().getSegment().getMessage();
        String escapeChar = msg.getEscapeCharacter();
        String fieldChar = msg.getFieldSeparator();
        String repeatingChar = msg.getRepetitionSeparator();
        String compChar = msg.getComponentSeparator();
        String subCompChar = msg.getSubComponentSeparator();
        return list.stream().map(c -> {
            if (c == null) {
                return "";
            }
            return encode ? Hl7Utils.encodeEscapedSequences(c.getValue(), escapeChar, fieldChar, repeatingChar, compChar, subCompChar) : c.getValue();
        }).collect(Collectors.joining(subCompChar));
    }

    public static String decodeEscapedSequences(String value) {
        return Hl7Utils.decodeEscapedSequences(value, "\\", "|", "~", "^", "&");
    }

    public static String decodeEscapedSequences(String value, String escapeChar, String fieldChar, String repeatChar, String compChar, String subComChar) {
        if (value == null) {
            return null;
        }
        Matcher matcher = ("\\".equals(escapeChar) ? _ESCAPED_SEQUENCES : Pattern.compile(Pattern.quote(escapeChar) + "([A-Z])([^" + escapeChar + "]*)" + Pattern.quote(escapeChar))).matcher(value);
        int currentIdx = 0;
        StringBuilder buf = new StringBuilder();
        while (matcher.find()) {
            String matchedGroups;
            buf.append(value, currentIdx, matcher.start());
            String fullOriginalGroup = escapeChar + matcher.group(1) + matcher.group(2) + escapeChar;
            switch (matchedGroups = matcher.group(1)) {
                case "F": {
                    buf.append(fieldChar);
                    break;
                }
                case "R": {
                    buf.append(repeatChar);
                    break;
                }
                case "S": {
                    buf.append(compChar);
                    break;
                }
                case "T": {
                    buf.append(subComChar);
                    break;
                }
                case "E": {
                    buf.append(escapeChar);
                    break;
                }
                case "C": 
                case "M": 
                case "X": 
                case "Z": {
                    buf.append(Hl7Utils.getHexadecimalResult(matcher.group(1) + matcher.group(2)));
                    break;
                }
                case "H": 
                case "N": {
                    break;
                }
                default: {
                    buf.append(fullOriginalGroup);
                }
            }
            currentIdx = matcher.end();
        }
        buf.append(value.substring(currentIdx));
        return buf.toString();
    }

    private static String getHexadecimalResult(String value) {
        Object result;
        boolean isInvalidMultiByte;
        char startingChar = value.charAt(0);
        String codeValue = value.substring(1);
        int codeLength = codeValue.length();
        boolean isInvalidHexadecimal = (startingChar == 'X' || startingChar == 'Z') && codeLength % 2 != 0;
        boolean isInvalidSingleByte = startingChar == 'C' && codeLength != 4;
        boolean bl = isInvalidMultiByte = startingChar == 'M' && codeLength != 4 && codeLength != 6;
        if (StringUtils.isBlank((CharSequence)codeValue)) {
            result = "";
        } else if (isInvalidHexadecimal || isInvalidSingleByte || isInvalidMultiByte) {
            result = "\\\\" + value + "\\\\";
        } else {
            try {
                StringBuilder tmpBuf = new StringBuilder();
                for (int i = 0; i < codeValue.length(); i += 2) {
                    tmpBuf.append((char)Integer.parseInt(codeValue.substring(i, i + 2), 16));
                }
                result = startingChar == 'X' ? tmpBuf.toString() : "";
            }
            catch (NumberFormatException e) {
                result = "\\\\" + value + "\\\\";
            }
        }
        return result;
    }

    public static String encodeEscapedSequences(String value) {
        return Hl7Utils.encodeEscapedSequences(value, "\\", "|", "~", "^", "&");
    }

    public static String encodeEscapedSequences(String value, String escapeChar, String fieldChar, String repeatChar, String compChar, String subComChar) {
        if (value == null) {
            return "";
        }
        value = value.replace(escapeChar, escapeChar + "E" + escapeChar);
        value = value.replace(fieldChar, escapeChar + "F" + escapeChar);
        value = value.replace(repeatChar, escapeChar + "R" + escapeChar);
        value = value.replace(compChar, escapeChar + "S" + escapeChar);
        value = value.replace(subComChar, escapeChar + "T" + escapeChar);
        value = value.replace("\r", escapeChar + "X0D" + escapeChar);
        value = value.replace("\n", escapeChar + "X0A" + escapeChar);
        return value;
    }
}

