/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccr.api.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.imsweb.naaccr.api.client.ErrorResponse;
import com.imsweb.naaccr.api.client.NaaccrApiException;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class ErrorInterceptor
implements Interceptor {
    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());
        if (response.code() != 200) {
            Object message;
            ResponseBody body = response.body();
            if (body != null) {
                try {
                    message = ((ErrorResponse)new ObjectMapper().readValue(body.byteStream(), ErrorResponse.class)).getMessage();
                }
                catch (IOException e) {
                    message = body.string();
                }
            } else {
                message = "Error code " + response.code();
            }
            throw new NaaccrApiException(response.code(), (String)message);
        }
        return response;
    }
}

