/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccr.api.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.imsweb.naaccr.api.client.ErrorInterceptor;
import com.imsweb.naaccr.api.client.NaaccrApiService;
import com.imsweb.naaccr.api.client.entity.ItemChangelog;
import com.imsweb.naaccr.api.client.entity.ItemChangelogResults;
import com.imsweb.naaccr.api.client.entity.ItemHistory;
import com.imsweb.naaccr.api.client.entity.ItemHistoryResults;
import com.imsweb.naaccr.api.client.entity.NaaccrDataItem;
import com.imsweb.naaccr.api.client.entity.NaaccrVersion;
import com.imsweb.naaccr.api.client.entity.SearchResults;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public final class NaaccrApiClient {
    public static final String NAACCR_API_URL = "https://apps.naaccr.org/data-dictionary/api/";
    public static final String NAACCR_API_VERSION = "1.0";
    public static final String NAACCR_25 = "25";
    public static final String NAACCR_24 = "24";
    public static final String NAACCR_23 = "23";
    public static final String NAACCR_22 = "22";
    public static final String NAACCR_21 = "21";
    public static final String NAACCR_LATEST = "25";
    private static NaaccrApiClient _INSTANCE;
    private final NaaccrApiService _service;

    public static NaaccrApiClient getInstance() {
        if (_INSTANCE == null) {
            _INSTANCE = new Builder().connect();
        }
        return _INSTANCE;
    }

    static ObjectMapper getMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        return mapper;
    }

    private NaaccrApiClient(String baseUrl, String apiVersion, String authorization) {
        if (!((String)baseUrl).endsWith("/")) {
            baseUrl = (String)baseUrl + "/";
        }
        baseUrl = (String)baseUrl + apiVersion + "/";
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor(chain -> {
            Request original = chain.request();
            Request.Builder requestBuilder = original.newBuilder();
            requestBuilder.addHeader("Accept", "application/json");
            if (authorization != null) {
                requestBuilder.addHeader("Authorization", authorization);
            }
            requestBuilder.method(original.method(), original.body());
            return chain.proceed(requestBuilder.build());
        }).addInterceptor((Interceptor)new ErrorInterceptor()).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl((String)baseUrl).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)NaaccrApiClient.getMapper())).client(client).build();
        this._service = (NaaccrApiService)retrofit.create(NaaccrApiService.class);
    }

    public List<NaaccrVersion> getNaaccrVersions() throws IOException {
        List results = (List)this._service.getNaaccrVersions().execute().body();
        if (results == null) {
            throw new IOException("Unable to get versions, got null results");
        }
        return results.stream().sorted(Comparator.comparing(NaaccrVersion::getVersion)).collect(Collectors.toList());
    }

    public List<NaaccrDataItem> getDataItems(String naaccrVersion) throws IOException {
        ArrayList<NaaccrDataItem> items = new ArrayList<NaaccrDataItem>();
        SearchResults results = (SearchResults)this._service.getDataItems(naaccrVersion, null).execute().body();
        if (results == null) {
            throw new IOException("Got no results");
        }
        if (results.getResults() != null && !results.getResults().isEmpty()) {
            items.addAll(results.getResults());
        }
        if (results.getCount() == null) {
            throw new IOException("Was expecting a count in the results but didn't get it");
        }
        int count = results.getCount();
        int page = 2;
        while (items.size() < count && (results = (SearchResults)this._service.getDataItems(naaccrVersion, page++).execute().body()) != null && results.getResults() != null && !results.getResults().isEmpty()) {
            items.addAll(results.getResults());
        }
        return items;
    }

    public NaaccrDataItem getDataItem(String naaccrVersion, String xmlId) throws IOException {
        return (NaaccrDataItem)this._service.getDataItem(naaccrVersion, xmlId).execute().body();
    }

    public NaaccrDataItem getDataItem(String naaccrVersion, Integer itemNumber) throws IOException {
        return this.getDataItem(naaccrVersion, itemNumber == null ? "" : itemNumber.toString());
    }

    public List<ItemChangelog> getItemChangelog(String naaccrVersion, String xmlId) throws IOException {
        ItemChangelogResults results = (ItemChangelogResults)this._service.getItemChangelog(naaccrVersion, xmlId).execute().body();
        if (results == null) {
            throw new IOException("Unable to get changelog, got null results");
        }
        return results.getResults().stream().sorted(Comparator.comparing(ItemChangelog::getModifiedAttribute)).collect(Collectors.toList());
    }

    public List<ItemChangelog> getItemChangelog(String naaccrVersion, Integer itemNumber) throws IOException {
        return this.getItemChangelog(naaccrVersion, itemNumber == null ? "" : itemNumber.toString());
    }

    public List<ItemHistory> getItemHistory(String xmlId, NaaccrItemAttribute attribute) throws IOException {
        ItemHistoryResults results = (ItemHistoryResults)this._service.getItemHistory(xmlId, attribute.getName()).execute().body();
        if (results == null) {
            throw new IOException("Unable to get history, got null results");
        }
        return results.getResults().stream().sorted(Comparator.comparing(ItemHistory::getNaaccrVersion)).collect(Collectors.toList());
    }

    public List<ItemHistory> getItemHistory(Integer itemNumber, NaaccrItemAttribute attribute) throws IOException {
        return this.getItemHistory(itemNumber == null ? "" : itemNumber.toString(), attribute);
    }

    public static class Builder {
        private String _url;
        private String _version;
        private String _authorization;

        private Properties getProperties() {
            Properties props = new Properties();
            File config = new File(System.getProperty("user.home"), ".naaccr-api-client");
            if (config.exists()) {
                try (FileInputStream in = new FileInputStream(config);){
                    props.load(in);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return props;
        }

        public Builder() {
            Properties props = this.getProperties();
            this._url = props.getProperty("url");
            if (this._url == null) {
                this._url = System.getenv("NAACCR_API_CLIENT_URL");
            }
            if (this._url == null) {
                this._url = NaaccrApiClient.NAACCR_API_URL;
            }
            this._version = props.getProperty("version");
            if (this._version == null) {
                this._version = System.getenv("NAACCR_API_CLIENT_VERSION");
            }
            if (this._version == null) {
                this._version = NaaccrApiClient.NAACCR_API_VERSION;
            }
            this._authorization = props.getProperty("authorization");
            if (this._authorization == null) {
                this._authorization = System.getenv("NAACCR_API_CLIENT_AUTHORIZATION");
            }
        }

        public Builder url(String url) {
            this._url = url;
            return this;
        }

        public Builder version(String version) {
            this._version = version;
            return this;
        }

        public NaaccrApiClient connect() {
            return new NaaccrApiClient(this._url, this._version, this._authorization);
        }
    }

    public static enum NaaccrItemAttribute {
        ITEM_NAME("ItemName"),
        ITEM_NUMBER("ItemNumber"),
        ITEM_LENGTH("ItemLength"),
        ITEM_DATA_TYPE("ItemDataType"),
        XML_NAACCR_ID("XmlNaaccrId"),
        XML_PARENT_ID("XmlParentId"),
        RECORD_TYPES("RecordTypes"),
        ALLOWABLE_VALUES("AllowableValues"),
        YEAR_IMPLEMENTED("YearImplemented"),
        VERSION_IMPLEMENTED("VersionImplemented"),
        YEAR_RETIRED("YearRetired"),
        VERSION_RETIRED("VersionRetired"),
        SECTION("Section"),
        SOURCE_OF_STANDARD("SourceOfStandard"),
        DESCRIPTION("Description"),
        RATIONALE("Rationale"),
        CLARIFICATION("Clarification"),
        GENERAL_NOTES("GeneralNotes"),
        COLLECTION_STATUS_NPCR("NpcrCollect"),
        COLLECTION_STATUS_COC("CocCollect"),
        COLLECTION_STATUS_SEER("SeerCollect"),
        FORMAT("Format"),
        CODE_HEADING("CodeHeading"),
        CODE_NOTE("CodeNote"),
        ALTERNATE_NAMES("AlternateNames"),
        ALLOWED_CODES("AllowedCodes");

        private final String _name;

        private NaaccrItemAttribute(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }
    }
}

